/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javafragment;

import java.util.Arrays;
import java.util.List;
import org.jd.core.v1.model.fragment.FlexibleFragment;
import org.jd.core.v1.model.javafragment.JavaFragment;
import org.jd.core.v1.model.javafragment.JavaFragmentVisitor;
import org.jd.core.v1.model.token.AbstractNopTokenVisitor;
import org.jd.core.v1.model.token.EndBlockToken;
import org.jd.core.v1.model.token.LineNumberToken;
import org.jd.core.v1.model.token.StartBlockToken;
import org.jd.core.v1.model.token.TextToken;
import org.jd.core.v1.model.token.Token;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor.StatementVisitor;

public class TokensFragment
extends FlexibleFragment
implements JavaFragment {
    public static final TokensFragment COMMA = new TokensFragment(TextToken.COMMA);
    public static final TokensFragment SEMICOLON = new TokensFragment(TextToken.SEMICOLON);
    public static final TokensFragment START_DECLARATION_OR_STATEMENT_BLOCK = new TokensFragment(StartBlockToken.START_DECLARATION_OR_STATEMENT_BLOCK);
    public static final TokensFragment END_DECLARATION_OR_STATEMENT_BLOCK = new TokensFragment(EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
    public static final TokensFragment END_DECLARATION_OR_STATEMENT_BLOCK_SEMICOLON = new TokensFragment(EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK, TextToken.SEMICOLON);
    public static final TokensFragment RETURN_SEMICOLON = new TokensFragment(StatementVisitor.RETURN, TextToken.SEMICOLON);
    protected List<Token> tokens;

    public TokensFragment(Token ... tokens) {
        this(Arrays.asList(tokens));
    }

    public TokensFragment(List<Token> tokens) {
        this(TokensFragment.getLineCount(tokens), tokens);
    }

    protected TokensFragment(int lineCount, List<Token> tokens) {
        super(lineCount, lineCount, lineCount, 0, "Tokens");
        this.tokens = tokens;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    protected static int getLineCount(List<Token> tokens) {
        LineCountVisitor visitor = new LineCountVisitor();
        for (Token token : tokens) {
            token.accept(visitor);
        }
        return visitor.lineCount;
    }

    @Override
    public void accept(JavaFragmentVisitor visitor) {
        visitor.visit(this);
    }

    protected static class LineCountVisitor
    extends AbstractNopTokenVisitor {
        public int lineCount = 0;

        protected LineCountVisitor() {
        }

        @Override
        public void visit(LineNumberToken token) {
            ++this.lineCount;
            assert (token.getLineNumber() == 0) : "LineNumberToken cannot have a known line number. Uses 'LineNumberTokensFragment' instead";
        }
    }
}

