"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var redux_1 = require("redux");
var chart_1 = require("../../../../state/actions/chart");
var get_chart_container_dimensions_1 = require("../../../../state/selectors/get_chart_container_dimensions");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var get_internal_is_intialized_1 = require("../../../../state/selectors/get_internal_is_intialized");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var fast_deep_equal_1 = require("../../../../utils/fast_deep_equal");
var light_theme_1 = require("../../../../utils/themes/light_theme");
var compute_annotations_1 = require("../../state/selectors/compute_annotations");
var compute_axis_ticks_dimensions_1 = require("../../state/selectors/compute_axis_ticks_dimensions");
var compute_axis_visible_ticks_1 = require("../../state/selectors/compute_axis_visible_ticks");
var compute_chart_dimensions_1 = require("../../state/selectors/compute_chart_dimensions");
var compute_chart_transform_1 = require("../../state/selectors/compute_chart_transform");
var compute_series_geometries_1 = require("../../state/selectors/compute_series_geometries");
var get_highlighted_series_1 = require("../../state/selectors/get_highlighted_series");
var get_specs_1 = require("../../state/selectors/get_specs");
var is_chart_empty_1 = require("../../state/selectors/is_chart_empty");
var indexed_geometry_map_1 = require("../../utils/indexed_geometry_map");
var renderers_1 = require("./renderers");
var XYChartComponent = (function (_super) {
    __extends(XYChartComponent, _super);
    function XYChartComponent(props) {
        var _this = _super.call(this, props) || this;
        _this.ctx = null;
        _this.devicePixelRatio = window.devicePixelRatio;
        return _this;
    }
    XYChartComponent.prototype.componentDidMount = function () {
        this.tryCanvasContext();
        if (this.props.initialized) {
            this.drawCanvas();
            this.props.onChartRendered();
        }
    };
    XYChartComponent.prototype.shouldComponentUpdate = function (nextProps) {
        return !fast_deep_equal_1.deepEqual(this.props, nextProps);
    };
    XYChartComponent.prototype.componentDidUpdate = function () {
        if (!this.ctx) {
            this.tryCanvasContext();
        }
        if (this.props.initialized) {
            this.drawCanvas();
            this.props.onChartRendered();
        }
    };
    XYChartComponent.prototype.drawCanvas = function () {
        if (this.ctx) {
            var _a = this.props, chartDimensions = _a.chartDimensions, chartRotation = _a.chartRotation;
            var clippings = {
                x: 0,
                y: 0,
                width: [90, -90].includes(chartRotation) ? chartDimensions.height : chartDimensions.width,
                height: [90, -90].includes(chartRotation) ? chartDimensions.width : chartDimensions.height,
            };
            renderers_1.renderXYChartCanvas2d(this.ctx, this.devicePixelRatio, clippings, this.props);
        }
    };
    XYChartComponent.prototype.tryCanvasContext = function () {
        var canvas = this.props.forwardStageRef.current;
        this.ctx = canvas && canvas.getContext('2d');
    };
    XYChartComponent.prototype.render = function () {
        var _a = this.props, forwardStageRef = _a.forwardStageRef, initialized = _a.initialized, isChartEmpty = _a.isChartEmpty, _b = _a.chartContainerDimensions, width = _b.width, height = _b.height;
        if (!initialized || isChartEmpty) {
            this.ctx = null;
            return null;
        }
        return (react_1.default.createElement("canvas", { ref: forwardStageRef, className: "echCanvasRenderer", width: width * this.devicePixelRatio, height: height * this.devicePixelRatio, style: {
                width: width,
                height: height,
            } }));
    };
    XYChartComponent.displayName = 'XYChart';
    return XYChartComponent;
}(react_1.default.Component));
var mapDispatchToProps = function (dispatch) {
    return redux_1.bindActionCreators({
        onChartRendered: chart_1.onChartRendered,
    }, dispatch);
};
var DEFAULT_PROPS = {
    initialized: false,
    debug: false,
    isChartEmpty: true,
    geometries: {
        areas: [],
        bars: [],
        lines: [],
        points: [],
        bubbles: [],
    },
    geometriesIndex: new indexed_geometry_map_1.IndexedGeometryMap(),
    theme: light_theme_1.LIGHT_THEME,
    chartContainerDimensions: {
        width: 0,
        height: 0,
        left: 0,
        top: 0,
    },
    chartRotation: 0,
    chartDimensions: {
        width: 0,
        height: 0,
        left: 0,
        top: 0,
    },
    chartTransform: {
        x: 0,
        y: 0,
        rotate: 0,
    },
    axesSpecs: [],
    axisTickPositions: {
        axisGridLinesPositions: new Map(),
        axisPositions: new Map(),
        axisTicks: new Map(),
        axisVisibleTicks: new Map(),
    },
    axesTicksDimensions: new Map(),
    axesGridLinesPositions: new Map(),
    annotationDimensions: new Map(),
    annotationSpecs: [],
};
var mapStateToProps = function (state) {
    if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return DEFAULT_PROPS;
    }
    var _a = compute_series_geometries_1.computeSeriesGeometriesSelector(state), geometries = _a.geometries, geometriesIndex = _a.geometriesIndex;
    return {
        initialized: true,
        isChartEmpty: is_chart_empty_1.isChartEmptySelector(state),
        debug: get_settings_specs_1.getSettingsSpecSelector(state).debug,
        geometries: geometries,
        geometriesIndex: geometriesIndex,
        theme: get_chart_theme_1.getChartThemeSelector(state),
        chartContainerDimensions: get_chart_container_dimensions_1.getChartContainerDimensionsSelector(state),
        highlightedLegendItem: get_highlighted_series_1.getHighlightedSeriesSelector(state),
        chartRotation: get_chart_rotation_1.getChartRotationSelector(state),
        chartDimensions: compute_chart_dimensions_1.computeChartDimensionsSelector(state).chartDimensions,
        chartTransform: compute_chart_transform_1.computeChartTransformSelector(state),
        axesSpecs: get_specs_1.getAxisSpecsSelector(state),
        axisTickPositions: compute_axis_visible_ticks_1.computeAxisVisibleTicksSelector(state),
        axesTicksDimensions: compute_axis_ticks_dimensions_1.computeAxisTicksDimensionsSelector(state),
        axesGridLinesPositions: compute_axis_visible_ticks_1.computeAxisVisibleTicksSelector(state).axisGridLinesPositions,
        annotationDimensions: compute_annotations_1.computeAnnotationDimensionsSelector(state),
        annotationSpecs: get_specs_1.getAnnotationSpecsSelector(state),
    };
};
exports.XYChart = react_redux_1.connect(mapStateToProps, mapDispatchToProps)(XYChartComponent);
//# sourceMappingURL=xy_chart.js.map