"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiColorPalettePicker = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _form = require("../../form");

var _utils = require("../utils");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var EuiColorPalettePicker = function EuiColorPalettePicker(_ref) {
  var className = _ref.className,
      _ref$compressed = _ref.compressed,
      compressed = _ref$compressed === void 0 ? false : _ref$compressed,
      disabled = _ref.disabled,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
      _ref$isInvalid = _ref.isInvalid,
      isInvalid = _ref$isInvalid === void 0 ? false : _ref$isInvalid,
      onChange = _ref.onChange,
      _ref$readOnly = _ref.readOnly,
      readOnly = _ref$readOnly === void 0 ? false : _ref$readOnly,
      valueOfSelected = _ref.valueOfSelected,
      palettes = _ref.palettes,
      append = _ref.append,
      prepend = _ref.prepend,
      _ref$selectionDisplay = _ref.selectionDisplay,
      selectionDisplay = _ref$selectionDisplay === void 0 ? 'palette' : _ref$selectionDisplay,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "compressed", "disabled", "fullWidth", "isInvalid", "onChange", "readOnly", "valueOfSelected", "palettes", "append", "prepend", "selectionDisplay"]);

  var getPalette = function getPalette(item) {
    var background = item.type === 'fixed' ? (0, _utils.getFixedLinearGradient)(item.palette) : (0, _utils.getLinearGradient)(item.palette);
    return _react.default.createElement("div", {
      className: "euiColorPalettePicker__itemGradient",
      style: {
        background: background
      }
    });
  };

  var paletteOptions = palettes.map(function (item) {
    var type = item.type,
        value = item.value,
        title = item.title,
        palette = item.palette,
        rest = (0, _objectWithoutProperties2.default)(item, ["type", "value", "title", "palette"]);
    var paletteForDisplay = item.type !== 'text' ? getPalette(item) : null;
    return _objectSpread({
      value: String(value),
      inputDisplay: selectionDisplay === 'title' || type === 'text' ? title : paletteForDisplay,
      dropdownDisplay: _react.default.createElement("div", {
        className: "euiColorPalettePicker__item"
      }, title && type !== 'text' && _react.default.createElement("div", {
        className: "euiColorPalettePicker__itemTitle"
      }, title), type === 'text' ? title : paletteForDisplay)
    }, rest);
  });
  return _react.default.createElement(_form.EuiSuperSelect, (0, _extends2.default)({
    className: className,
    options: paletteOptions,
    valueOfSelected: valueOfSelected,
    onChange: onChange,
    hasDividers: true,
    isInvalid: isInvalid,
    compressed: compressed,
    disabled: disabled,
    readOnly: readOnly,
    fullWidth: fullWidth,
    append: append,
    prepend: prepend
  }, rest));
};

exports.EuiColorPalettePicker = EuiColorPalettePicker;
EuiColorPalettePicker.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  compressed: _propTypes.default.bool,
  fullWidth: _propTypes.default.bool,
  isInvalid: _propTypes.default.bool,
  isLoading: _propTypes.default.bool,
  readOnly: _propTypes.default.bool,
  name: _propTypes.default.string,

  /**
     * Creates an input group with element(s) coming before input.
     * `string` | `ReactElement` or an array of these
     */
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),

  /**
     * Creates an input group with element(s) coming after input.
     * `string` | `ReactElement` or an array of these
     */
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  valueOfSelected: _propTypes.default.any,

  /**
       * Classes for the context menu item
       */
  itemClassName: _propTypes.default.string,

  /**
       * You must pass an `onChange` function to handle the update of the value
       */
  onChange: _propTypes.default.func,

  /**
       * Applied to the outermost wrapper (popover)
       */
  popoverClassName: _propTypes.default.string,

  /**
       * Controls whether the options are shown. Default: false
       */
  isOpen: _propTypes.default.bool,

  /**
       *  Specify what should be displayed after a selection: a `palette` or `title`
       */
  selectionDisplay: _propTypes.default.oneOf(["palette", "title"]),

  /**
       * An array of one of the following objects: #EuiColorPalettePickerPaletteText, #EuiColorPalettePickerPaletteFixed, #EuiColorPalettePickerPaletteGradient
       */
  palettes: _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.shape({
    /**
       *  For storing unique value of item
       */
    value: _propTypes.default.string.isRequired,

    /**
       *  The name of your palette
       */
    title: _propTypes.default.string.isRequired,

    /**
       * `text`: a text only option (a title is required).
       */
    type: _propTypes.default.oneOf(["text"]).isRequired,

    /**
       * Array of color `strings` or `ColorStops` in the form of
       * `{ stop: number, color: string }`. The stops must be numbers in an ordered range.
       */
    palette: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired, _propTypes.default.arrayOf(_propTypes.default.shape({
      stop: _propTypes.default.number.isRequired,
      color: _propTypes.default.string.isRequired
    }).isRequired).isRequired]),
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }).isRequired, _propTypes.default.shape({
    /**
       *  For storing unique value of item
       */
    value: _propTypes.default.string.isRequired,

    /**
       *  The name of your palette
       */
    title: _propTypes.default.string,

    /**
       * `fixed`: individual color blocks
       */
    type: _propTypes.default.oneOf(["fixed"]).isRequired,

    /**
       * Array of color `strings`.
       */
    palette: _propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }).isRequired, _propTypes.default.shape({
    /**
       *  For storing unique value of item
       */
    value: _propTypes.default.string.isRequired,

    /**
       *  The name of your palette
       */
    title: _propTypes.default.string,

    /**
       * `gradient`: each color fades into the next
       */
    type: _propTypes.default.oneOf(["gradient"]).isRequired,

    /**
       * Array of color `strings` or `ColorStops` in the form of
       * `{ stop: number, color: string }`. The stops must be numbers in an ordered range.
       */
    palette: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired, _propTypes.default.arrayOf(_propTypes.default.shape({
      stop: _propTypes.default.number.isRequired,
      color: _propTypes.default.string.isRequired
    }).isRequired).isRequired]).isRequired,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }).isRequired]).isRequired).isRequired
};
EuiColorPalettePicker.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiColorPalettePicker",
  "props": {
    "compressed": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "fullWidth": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "isInvalid": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "readOnly": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "selectionDisplay": {
      "defaultValue": {
        "value": "'palette'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"palette\"",
          "computed": false
        }, {
          "value": "\"title\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Specify what should be displayed after a selection: a `palette` or `title`"
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "isLoading": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "name": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "prepend": {
      "type": {
        "name": "custom",
        "raw": "_propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired])"
      },
      "required": false,
      "description": "Creates an input group with element(s) coming before input.\n`string` | `ReactElement` or an array of these"
    },
    "append": {
      "type": {
        "name": "custom",
        "raw": "_propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired])"
      },
      "required": false,
      "description": "Creates an input group with element(s) coming after input.\n`string` | `ReactElement` or an array of these"
    },
    "valueOfSelected": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "itemClassName": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Classes for the context menu item"
    },
    "onChange": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": "You must pass an `onChange` function to handle the update of the value"
    },
    "popoverClassName": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Applied to the outermost wrapper (popover)"
    },
    "isOpen": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Controls whether the options are shown. Default: false"
    },
    "palettes": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "union",
          "value": [{
            "name": "shape",
            "value": {
              "value": {
                "name": "string",
                "description": "For storing unique value of item",
                "required": true
              },
              "title": {
                "name": "string",
                "description": "The name of your palette",
                "required": true
              },
              "type": {
                "name": "enum",
                "value": [{
                  "value": "\"text\"",
                  "computed": false
                }],
                "description": "`text`: a text only option (a title is required).",
                "required": true
              },
              "palette": {
                "name": "union",
                "value": [{
                  "name": "arrayOf",
                  "value": {
                    "name": "string"
                  }
                }, {
                  "name": "arrayOf",
                  "value": {
                    "name": "shape",
                    "value": {
                      "stop": {
                        "name": "number",
                        "required": true
                      },
                      "color": {
                        "name": "string",
                        "required": true
                      }
                    }
                  }
                }],
                "description": "Array of color `strings` or `ColorStops` in the form of\n`{ stop: number, color: string }`. The stops must be numbers in an ordered range.",
                "required": false
              },
              "className": {
                "name": "string",
                "required": false
              },
              "aria-label": {
                "name": "string",
                "required": false
              },
              "data-test-subj": {
                "name": "string",
                "required": false
              }
            }
          }, {
            "name": "shape",
            "value": {
              "value": {
                "name": "string",
                "description": "For storing unique value of item",
                "required": true
              },
              "title": {
                "name": "string",
                "description": "The name of your palette",
                "required": false
              },
              "type": {
                "name": "enum",
                "value": [{
                  "value": "\"fixed\"",
                  "computed": false
                }],
                "description": "`fixed`: individual color blocks",
                "required": true
              },
              "palette": {
                "name": "arrayOf",
                "value": {
                  "name": "string"
                },
                "description": "Array of color `strings`.",
                "required": true
              },
              "className": {
                "name": "string",
                "required": false
              },
              "aria-label": {
                "name": "string",
                "required": false
              },
              "data-test-subj": {
                "name": "string",
                "required": false
              }
            }
          }, {
            "name": "shape",
            "value": {
              "value": {
                "name": "string",
                "description": "For storing unique value of item",
                "required": true
              },
              "title": {
                "name": "string",
                "description": "The name of your palette",
                "required": false
              },
              "type": {
                "name": "enum",
                "value": [{
                  "value": "\"gradient\"",
                  "computed": false
                }],
                "description": "`gradient`: each color fades into the next",
                "required": true
              },
              "palette": {
                "name": "union",
                "value": [{
                  "name": "arrayOf",
                  "value": {
                    "name": "string"
                  }
                }, {
                  "name": "arrayOf",
                  "value": {
                    "name": "shape",
                    "value": {
                      "stop": {
                        "name": "number",
                        "required": true
                      },
                      "color": {
                        "name": "string",
                        "required": true
                      }
                    }
                  }
                }],
                "description": "Array of color `strings` or `ColorStops` in the form of\n`{ stop: number, color: string }`. The stops must be numbers in an ordered range.",
                "required": true
              },
              "className": {
                "name": "string",
                "required": false
              },
              "aria-label": {
                "name": "string",
                "required": false
              },
              "data-test-subj": {
                "name": "string",
                "required": false
              }
            }
          }]
        }
      },
      "required": true,
      "description": "An array of one of the following objects: #EuiColorPalettePickerPaletteText, #EuiColorPalettePickerPaletteFixed, #EuiColorPalettePickerPaletteGradient"
    }
  }
};