import { pipeable } from './pipeable';
/**
 * @since 2.0.0
 */
export var URI = 'Writer';
/**
 * @since 2.0.0
 */
export function evalWriter(fa) {
    return fa()[0];
}
/**
 * @since 2.0.0
 */
export function execWriter(fa) {
    return fa()[1];
}
/**
 * Appends a value to the accumulator
 *
 * @since 2.0.0
 */
export function tell(w) {
    return function () { return [undefined, w]; };
}
/**
 * Modifies the result to include the changes to the accumulator
 *
 * @since 2.0.0
 */
export function listen(fa) {
    return function () {
        var _a = fa(), a = _a[0], w = _a[1];
        return [[a, w], w];
    };
}
/**
 * Applies the returned function to the accumulator
 *
 * @since 2.0.0
 */
export function pass(fa) {
    return function () {
        var _a = fa(), _b = _a[0], a = _b[0], f = _b[1], w = _a[1];
        return [a, f(w)];
    };
}
/**
 * Projects a value from modifications made to the accumulator during an action
 *
 * @since 2.0.0
 */
export function listens(f) {
    return function (fa) { return function () {
        var _a = fa(), a = _a[0], w = _a[1];
        return [[a, f(w)], w];
    }; };
}
/**
 * Modify the final accumulator value by applying a function
 *
 * @since 2.0.0
 */
export function censor(f) {
    return function (fa) { return function () {
        var _a = fa(), a = _a[0], w = _a[1];
        return [a, f(w)];
    }; };
}
/**
 * @since 2.0.0
 */
export function getMonad(M) {
    return {
        URI: URI,
        _E: undefined,
        map: writer.map,
        of: function (a) { return function () { return [a, M.empty]; }; },
        ap: function (mab, ma) { return function () {
            var _a = mab(), f = _a[0], w1 = _a[1];
            var _b = ma(), a = _b[0], w2 = _b[1];
            return [f(a), M.concat(w1, w2)];
        }; },
        chain: function (ma, f) { return function () {
            var _a = ma(), a = _a[0], w1 = _a[1];
            var _b = f(a)(), b = _b[0], w2 = _b[1];
            return [b, M.concat(w1, w2)];
        }; }
    };
}
/**
 * @since 2.0.0
 */
export var writer = {
    URI: URI,
    map: function (fa, f) { return function () {
        var _a = fa(), a = _a[0], w = _a[1];
        return [f(a), w];
    }; }
};
var map = pipeable(writer).map;
export { 
/**
 * @since 2.0.0
 */
map };
