function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { defer } from '../../../kibana_utils/public';
import { createBatchedFunction } from '../../common';
import { fetchStreaming, split } from '../streaming';
import { normalizeError } from '../../common';

/**
 * Returns a function that does not execute immediately but buffers the call internally until
 * `params.flushOnMaxItems` is reached or after `params.maxItemAge` timeout in milliseconds is reached. Once
 * one of those thresholds is reached all buffered calls are sent in one batch to the
 * server using `params.fetchStreaming` in a POST request. Responses are streamed back
 * and each batch item is resolved once corresponding response is received.
 */
export var createStreamingBatchedFunction = function createStreamingBatchedFunction(params) {
  var url = params.url,
      _params$fetchStreamin = params.fetchStreaming,
      fetchStreamingInjected = _params$fetchStreamin === void 0 ? fetchStreaming : _params$fetchStreamin,
      _params$flushOnMaxIte = params.flushOnMaxItems,
      flushOnMaxItems = _params$flushOnMaxIte === void 0 ? 25 : _params$flushOnMaxIte,
      _params$maxItemAge = params.maxItemAge,
      maxItemAge = _params$maxItemAge === void 0 ? 10 : _params$maxItemAge;

  var _createBatchedFunctio = createBatchedFunction({
    onCall: function onCall(payload) {
      var future = defer();
      var entry = {
        payload: payload,
        future: future
      };
      return [future.promise, entry];
    },
    onBatch: function () {
      var _onBatch = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(items) {
        var responsesReceived, batch, _fetchStreamingInject, stream, _iterator3, _step3, item;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                responsesReceived = 0;
                batch = items.map(function (_ref) {
                  var payload = _ref.payload;
                  return payload;
                });
                _fetchStreamingInject = fetchStreamingInjected({
                  url: url,
                  body: JSON.stringify({
                    batch: batch
                  }),
                  method: 'POST'
                }), stream = _fetchStreamingInject.stream;
                stream.pipe(split('\n')).subscribe({
                  next: function next(json) {
                    var response = JSON.parse(json);

                    if (response.error) {
                      responsesReceived++;
                      items[response.id].future.reject(response.error);
                    } else if (response.result !== undefined) {
                      responsesReceived++;
                      items[response.id].future.resolve(response.result);
                    }
                  },
                  error: function (_error) {
                    function error(_x2) {
                      return _error.apply(this, arguments);
                    }

                    error.toString = function () {
                      return _error.toString();
                    };

                    return error;
                  }(function (error) {
                    var normalizedError = normalizeError(error);
                    normalizedError.code = 'STREAM';

                    var _iterator = _createForOfIteratorHelper(items),
                        _step;

                    try {
                      for (_iterator.s(); !(_step = _iterator.n()).done;) {
                        var future = _step.value.future;
                        future.reject(normalizedError);
                      }
                    } catch (err) {
                      _iterator.e(err);
                    } finally {
                      _iterator.f();
                    }
                  }),
                  complete: function complete() {
                    var streamTerminatedPrematurely = responsesReceived !== items.length;

                    if (streamTerminatedPrematurely) {
                      var _error2 = {
                        message: 'Connection terminated prematurely.',
                        code: 'CONNECTION'
                      };

                      var _iterator2 = _createForOfIteratorHelper(items),
                          _step2;

                      try {
                        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                          var future = _step2.value.future;
                          future.reject(_error2);
                        }
                      } catch (err) {
                        _iterator2.e(err);
                      } finally {
                        _iterator2.f();
                      }
                    }
                  }
                });
                _context.next = 7;
                return stream.toPromise();

              case 7:
                _context.next = 13;
                break;

              case 9:
                _context.prev = 9;
                _context.t0 = _context["catch"](0);
                _iterator3 = _createForOfIteratorHelper(items);

                try {
                  for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                    item = _step3.value;
                    item.future.reject(_context.t0);
                  }
                } catch (err) {
                  _iterator3.e(err);
                } finally {
                  _iterator3.f();
                }

              case 13:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[0, 9]]);
      }));

      function onBatch(_x) {
        return _onBatch.apply(this, arguments);
      }

      return onBatch;
    }(),
    flushOnMaxItems: flushOnMaxItems,
    maxItemAge: maxItemAge
  }),
      _createBatchedFunctio2 = _slicedToArray(_createBatchedFunctio, 1),
      fn = _createBatchedFunctio2[0];

  return fn;
};