/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { EuiButton, EuiFlexGroup, EuiFlexItem } from '@elastic/eui';
import React from 'react';
import { toMountPoint } from '../../../../kibana_react/public';
export var onUnsupportedTimePattern = function onUnsupportedTimePattern(toasts, navigateToApp) {
  return function (_ref) {
    var id = _ref.id,
        title = _ref.title,
        index = _ref.index;
    var warningTitle = i18n.translate('data.indexPatterns.warningTitle', {
      defaultMessage: 'Support for time interval index patterns removed'
    });
    var warningText = i18n.translate('data.indexPatterns.warningText', {
      defaultMessage: 'Currently querying all indices matching {index}. {title} should be migrated to a wildcard-based index pattern.',
      values: {
        title: title,
        index: index
      }
    }); // kbnUrl was added to this service in #35262 before it was de-angularized, and merged in a PR
    // directly against the 7.x branch. Index patterns were de-angularized in #39247, and in order
    // to preserve the functionality from #35262 we need to get the injector here just for kbnUrl.
    // This has all been removed as of 8.0.
    // 2019-12-01 The usage of kbnUrl had to be removed due to the transition to NP.
    // It's now temporarily replaced by a simple replace of the single argument used by all URLs.
    // Once kbnUrl is migrated to NP, this can be updated.

    toasts.addWarning({
      title: warningTitle,
      text: toMountPoint( /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("p", null, warningText), /*#__PURE__*/React.createElement(EuiFlexGroup, {
        justifyContent: "flexEnd",
        gutterSize: "s"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButton, {
        size: "s",
        onClick: function onClick() {
          return navigateToApp('management', {
            path: "/kibana/index_patterns/index_pattern/".concat(id || '')
          });
        }
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "data.indexPatterns.editIndexPattern",
        defaultMessage: "Edit index pattern"
      }))))))
    });
  };
};