function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import { createHashHistory } from 'history';
import { createGetterSetter } from '../../kibana_utils/public';
import { search } from '../../data/public';
var angularModule = null;
var services = null;
/**
 * set bootstrapped inner angular module
 */

export function setAngularModule(module) {
  angularModule = module;
}
/**
 * get boostrapped inner angular module
 */

export function getAngularModule() {
  return angularModule;
}
export function getServices() {
  if (!services) {
    throw new Error('Discover services are not yet available');
  }

  return services;
}
export function setServices(newServices) {
  services = newServices;
}

var _createGetterSetter = createGetterSetter('urlTracker'),
    _createGetterSetter2 = _slicedToArray(_createGetterSetter, 2),
    getUrlTracker = _createGetterSetter2[0],
    setUrlTracker = _createGetterSetter2[1];

export { getUrlTracker, setUrlTracker };

var _createGetterSetter3 = createGetterSetter('DocViewsRegistry'),
    _createGetterSetter4 = _slicedToArray(_createGetterSetter3, 2),
    getDocViewsRegistry = _createGetterSetter4[0],
    setDocViewsRegistry = _createGetterSetter4[1];
/**
 * Makes sure discover and context are using one instance of history.
 */


export { getDocViewsRegistry, setDocViewsRegistry };
export var getHistory = _.once(function () {
  return createHashHistory();
});
/**
 * Discover currently uses two `history` instances: one from Kibana Platform and
 * another from `history` package. Below function is used every time Discover
 * app is loaded to synchronize both instances.
 *
 * This helper is temporary until https://github.com/elastic/kibana/issues/65161 is resolved.
 */

export var syncHistoryLocations = function syncHistoryLocations() {
  var h = getHistory();
  Object.assign(h.location, createHashHistory().location);
  return h;
};

var _createGetterSetter5 = createGetterSetter('scopedHistory'),
    _createGetterSetter6 = _slicedToArray(_createGetterSetter5, 2),
    getScopedHistory = _createGetterSetter6[0],
    setScopedHistory = _createGetterSetter6[1];

export { getScopedHistory, setScopedHistory };
var getRequestInspectorStats = search.getRequestInspectorStats,
    getResponseInspectorStats = search.getResponseInspectorStats,
    tabifyAggResponse = search.tabifyAggResponse;
export { getRequestInspectorStats, getResponseInspectorStats, tabifyAggResponse };
export { unhashUrl, redirectWhenMissing } from '../../kibana_utils/public';
export { formatMsg, formatStack, subscribeWithScope } from '../../kibana_legacy/public'; // EXPORT types

export { IndexPatternsContract, IIndexPattern, IndexPattern, indexPatterns, IFieldType, ISearchSource, EsQuerySortValue, SortDirection } from '../../data/public';