/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment } from 'react';
import { EuiCallOut, EuiIcon, EuiLink, EuiSpacer } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { useKibana } from '../../../../../../../plugins/kibana_react/public';
export var ScriptingWarningCallOut = function ScriptingWarningCallOut(_ref) {
  var _useKibana$services$d;

  var _ref$isVisible = _ref.isVisible,
      isVisible = _ref$isVisible === void 0 ? false : _ref$isVisible;
  var docLinksScriptedFields = (_useKibana$services$d = useKibana().services.docLinks) === null || _useKibana$services$d === void 0 ? void 0 : _useKibana$services$d.links.scriptedFields;
  return isVisible ? /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiCallOut, {
    title: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "indexPatternManagement.warningCallOutHeader",
      defaultMessage: "Proceed with caution"
    }),
    color: "warning",
    iconType: "alert"
  }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.warningCallOutLabel.callOutDetail",
    defaultMessage: "Please familiarize yourself with {scripFields} and with {scriptsInAggregation} before using scripted fields.",
    values: {
      scripFields: /*#__PURE__*/React.createElement(EuiLink, {
        target: "_blank",
        href: docLinksScriptedFields.scriptFields
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.warningCallOutLabel.scripFieldsLink",
        defaultMessage: "script fields"
      }), "\xA0", /*#__PURE__*/React.createElement(EuiIcon, {
        type: "link"
      })),
      scriptsInAggregation: /*#__PURE__*/React.createElement(EuiLink, {
        target: "_blank",
        href: docLinksScriptedFields.scriptAggs
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.warningCallOutLabel.scriptsInAggregationLink",
        defaultMessage: "scripts in aggregations"
      }), "\xA0", /*#__PURE__*/React.createElement(EuiIcon, {
        type: "link"
      }))
    }
  })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.warningCallOut.descriptionLabel",
    defaultMessage: "Scripted fields can be used to display and aggregate calculated values. As such, they can be very slow, and if done incorrectly, can cause Kibana to be unusable. There's no safety net here. If you make a typo, unexpected exceptions will be thrown all over the place!"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  })) : null;
};
ScriptingWarningCallOut.displayName = 'ScriptingWarningCallOut';