/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { createContext, useContext } from 'react';
import { PanelRegistry } from './registry';
var PanelContext = createContext({
  registry: new PanelRegistry()
});
export function PanelContextProvider(_ref) {
  var children = _ref.children,
      registry = _ref.registry;
  return /*#__PURE__*/React.createElement(PanelContext.Provider, {
    value: {
      registry: registry
    }
  }, children);
}
export var usePanelContext = function usePanelContext() {
  var context = useContext(PanelContext);

  if (context === undefined) {
    throw new Error('usePanelContext must be used within a <PanelContextProvider />');
  }

  return context;
};