function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useReducer, useEffect, useMemo } from 'react';
import { EuiForm, EuiAccordion, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import useUnmount from 'react-use/lib/useUnmount';
import { AggGroupNames } from '../../../data/public';
import { DefaultEditorAggSelect } from './agg_select';
import { DefaultEditorAggParam } from './agg_param';
import { getAggParamsToRender, getAggTypeOptions, isInvalidParamsTouched } from './agg_params_helper';
import { aggTypeReducer, aggParamsReducer, AGG_PARAMS_ACTION_KEYS, initAggParamsState } from './agg_params_state';
import { getEditorConfig } from './utils';
import { getSchemaByName } from '../schemas';
import { useKibana } from '../../../kibana_react/public';
var FIXED_VALUE_PROP = 'fixedValue';
var DEFAULT_PROP = 'default';

function DefaultEditorAggParams(_ref) {
  var _agg$type, _agg$params, _agg$params$field;

  var agg = _ref.agg,
      aggError = _ref.aggError,
      _ref$aggIndex = _ref.aggIndex,
      aggIndex = _ref$aggIndex === void 0 ? 0 : _ref$aggIndex,
      _ref$aggIsTooLow = _ref.aggIsTooLow,
      aggIsTooLow = _ref$aggIsTooLow === void 0 ? false : _ref$aggIsTooLow,
      className = _ref.className,
      disabledParams = _ref.disabledParams,
      groupName = _ref.groupName,
      formIsTouched = _ref.formIsTouched,
      indexPattern = _ref.indexPattern,
      metricAggs = _ref.metricAggs,
      state = _ref.state,
      setAggParamValue = _ref.setAggParamValue,
      onAggTypeChange = _ref.onAggTypeChange,
      setTouched = _ref.setTouched,
      setValidity = _ref.setValidity,
      schemas = _ref.schemas,
      _ref$allowedAggs = _ref.allowedAggs,
      allowedAggs = _ref$allowedAggs === void 0 ? [] : _ref$allowedAggs,
      _ref$hideCustomLabel = _ref.hideCustomLabel,
      hideCustomLabel = _ref$hideCustomLabel === void 0 ? false : _ref$hideCustomLabel;
  var schema = useMemo(function () {
    return getSchemaByName(schemas, agg.schema);
  }, [agg.schema, schemas]);
  var aggFilter = useMemo(function () {
    return [].concat(_toConsumableArray(allowedAggs), _toConsumableArray(schema.aggFilter || []));
  }, [allowedAggs, schema.aggFilter]);

  var _useKibana = useKibana(),
      services = _useKibana.services;

  var aggTypes = useMemo(function () {
    return services.data.search.aggs.types.getAll();
  }, [services.data.search.aggs.types]);
  var groupedAggTypeOptions = useMemo(function () {
    return getAggTypeOptions(aggTypes, agg, indexPattern, groupName, aggFilter);
  }, [aggTypes, agg, indexPattern, groupName, aggFilter]);
  var error = aggIsTooLow ? i18n.translate('visDefaultEditor.aggParams.errors.aggWrongRunOrderErrorMessage', {
    defaultMessage: '"{schema}" aggs must run before all other buckets!',
    values: {
      schema: schema.title
    }
  }) : '';
  var aggTypeName = (_agg$type = agg.type) === null || _agg$type === void 0 ? void 0 : _agg$type.name;
  var fieldName = (_agg$params = agg.params) === null || _agg$params === void 0 ? void 0 : (_agg$params$field = _agg$params.field) === null || _agg$params$field === void 0 ? void 0 : _agg$params$field.name;
  var editorConfig = useMemo(function () {
    return getEditorConfig(indexPattern, aggTypeName, fieldName);
  }, [indexPattern, aggTypeName, fieldName]);
  var params = useMemo(function () {
    return getAggParamsToRender({
      agg: agg,
      editorConfig: editorConfig,
      metricAggs: metricAggs,
      state: state,
      schemas: schemas,
      hideCustomLabel: hideCustomLabel
    });
  }, [agg, editorConfig, metricAggs, state, schemas, hideCustomLabel]);
  var allParams = [].concat(_toConsumableArray(params.basic), _toConsumableArray(params.advanced));

  var _useReducer = useReducer(aggParamsReducer, allParams, initAggParamsState),
      _useReducer2 = _slicedToArray(_useReducer, 2),
      paramsState = _useReducer2[0],
      onChangeParamsState = _useReducer2[1];

  var _useReducer3 = useReducer(aggTypeReducer, {
    touched: false,
    valid: true
  }),
      _useReducer4 = _slicedToArray(_useReducer3, 2),
      aggType = _useReducer4[0],
      onChangeAggType = _useReducer4[1];

  var isFormValid = !error && aggType.valid && Object.entries(paramsState).every(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
        paramState = _ref3[1];

    return paramState.valid;
  });
  var isAllInvalidParamsTouched = !!error || isInvalidParamsTouched(agg.type, aggType, paramsState);
  var onAggSelect = useCallback(function (value) {
    if (agg.type !== value) {
      onAggTypeChange(agg.id, value); // reset touched and valid of params

      onChangeParamsState({
        type: AGG_PARAMS_ACTION_KEYS.RESET
      });
    }
  }, [onAggTypeChange, agg]); // reset validity before component destroyed

  useUnmount(function () {
    return setValidity(true);
  });
  useEffect(function () {
    Object.entries(editorConfig).forEach(function (_ref4) {
      var _ref5 = _slicedToArray(_ref4, 2),
          param = _ref5[0],
          paramConfig = _ref5[1];

      var paramOptions = agg.type.params.find(function (paramOption) {
        return paramOption.name === param;
      });
      var hasFixedValue = paramConfig.hasOwnProperty(FIXED_VALUE_PROP);
      var hasDefault = paramConfig.hasOwnProperty(DEFAULT_PROP); // If the parameter has a fixed value in the config, set this value.
      // Also for all supported configs we should freeze the editor for this param.

      if (hasFixedValue || hasDefault) {
        var newValue;
        var property = FIXED_VALUE_PROP;
        var typedParamConfig = paramConfig;

        if (hasDefault) {
          property = DEFAULT_PROP;
          typedParamConfig = paramConfig;
        }

        if (paramOptions && paramOptions.deserialize) {
          newValue = paramOptions.deserialize(typedParamConfig[property]);
        } else {
          newValue = typedParamConfig[property];
        } // this check is obligatory to avoid infinite render, because setAggParamValue creates a brand new agg object


        if (agg.params[param] !== newValue) {
          setAggParamValue(agg.id, param, newValue);
        }
      }
    }); // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [editorConfig]);
  useEffect(function () {
    setTouched(false);
  }, [agg.type, setTouched]);
  useEffect(function () {
    setValidity(isFormValid);
  }, [isFormValid, agg.type, setValidity]);
  useEffect(function () {
    // when all invalid controls were touched or they are untouched
    setTouched(isAllInvalidParamsTouched);
  }, [isAllInvalidParamsTouched, setTouched]);
  return /*#__PURE__*/React.createElement(EuiForm, {
    className: className,
    isInvalid: !!error,
    error: error,
    "data-test-subj": "visAggEditorParams"
  }, /*#__PURE__*/React.createElement(DefaultEditorAggSelect, {
    aggError: aggError,
    id: agg.id,
    indexPattern: indexPattern,
    value: agg.type,
    aggTypeOptions: groupedAggTypeOptions,
    isSubAggregation: aggIndex >= 1 && groupName === AggGroupNames.Buckets,
    showValidation: formIsTouched || aggType.touched,
    setValue: onAggSelect,
    onChangeAggType: onChangeAggType
  }), params.basic.map(function (param) {
    var model = paramsState[param.aggParam.name] || {
      touched: false,
      valid: true
    };
    return /*#__PURE__*/React.createElement(DefaultEditorAggParam, _extends({
      key: "".concat(param.aggParam.name).concat(agg.type ? agg.type.name : ''),
      disabled: disabledParams && disabledParams.includes(param.aggParam.name),
      formIsTouched: formIsTouched,
      showValidation: formIsTouched || model.touched,
      setAggParamValue: setAggParamValue,
      onChangeParamsState: onChangeParamsState
    }, param));
  }), params.advanced.length ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(EuiAccordion, {
    id: "advancedAccordion",
    "data-test-subj": "advancedParams-".concat(agg.id),
    buttonContent: i18n.translate('visDefaultEditor.advancedToggle.advancedLinkLabel', {
      defaultMessage: 'Advanced'
    })
  }, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), params.advanced.map(function (param) {
    var model = paramsState[param.aggParam.name] || {
      touched: false,
      valid: true
    };
    return /*#__PURE__*/React.createElement(DefaultEditorAggParam, _extends({
      key: "".concat(param.aggParam.name).concat(agg.type ? agg.type.name : ''),
      disabled: disabledParams && disabledParams.includes(param.aggParam.name),
      formIsTouched: formIsTouched,
      showValidation: formIsTouched || model.touched,
      setAggParamValue: setAggParamValue,
      onChangeParamsState: onChangeParamsState
    }, param));
  }))) : null);
}

export { DefaultEditorAggParams };