function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { EuiPanel, EuiSpacer, EuiTitle } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { ColorRanges, ColorSchemaOptions, SwitchOption, ColorSchemas } from '../../../../../charts/public';

function RangesPanel(_ref) {
  var setGaugeValue = _ref.setGaugeValue,
      setTouched = _ref.setTouched,
      setValidity = _ref.setValidity,
      setValue = _ref.setValue,
      stateParams = _ref.stateParams,
      uiState = _ref.uiState,
      vis = _ref.vis;
  var setColorSchemaOptions = useCallback(function (paramName, value) {
    setGaugeValue(paramName, value); // set outline if color schema is changed to greys
    // if outline wasn't set explicitly yet

    if (paramName === 'colorSchema' && value === ColorSchemas.Greys && typeof stateParams.gauge.outline === 'undefined') {
      setGaugeValue('outline', true);
    }
  }, [setGaugeValue, stateParams]);
  return /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeVislib.controls.gaugeOptions.rangesTitle",
    defaultMessage: "Ranges"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(ColorRanges, {
    "data-test-subj": "gaugeColorRange",
    colorsRange: stateParams.gauge.colorsRange,
    setValue: setGaugeValue,
    setTouched: setTouched,
    setValidity: setValidity
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    disabled: stateParams.gauge.colorsRange.length < 2,
    label: i18n.translate('visTypeVislib.controls.gaugeOptions.autoExtendRangeLabel', {
      defaultMessage: 'Auto extend range'
    }),
    tooltip: i18n.translate('visTypeVislib.controls.gaugeOptions.extendRangeTooltip', {
      defaultMessage: 'Extends range to the maximum value in your data.'
    }),
    paramName: "extendRange",
    value: stateParams.gauge.extendRange,
    setValue: setGaugeValue
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    "data-test-subj": "gaugePercentageMode",
    label: i18n.translate('visTypeVislib.controls.gaugeOptions.percentageModeLabel', {
      defaultMessage: 'Percentage mode'
    }),
    paramName: "percentageMode",
    value: stateParams.gauge.percentageMode,
    setValue: setGaugeValue
  }), /*#__PURE__*/React.createElement(ColorSchemaOptions, {
    disabled: stateParams.gauge.colorsRange.length < 2,
    colorSchema: stateParams.gauge.colorSchema,
    colorSchemas: vis.type.editorConfig.collections.colorSchemas,
    invertColors: stateParams.gauge.invertColors,
    uiState: uiState,
    setValue: setColorSchemaOptions
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.controls.gaugeOptions.showOutline', {
      defaultMessage: 'Show outline'
    }),
    paramName: "outline",
    value: stateParams.gauge.outline,
    setValue: setGaugeValue
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.controls.gaugeOptions.showLegendLabel', {
      defaultMessage: 'Show legend'
    }),
    paramName: "addLegend",
    value: stateParams.addLegend,
    setValue: setValue
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.controls.gaugeOptions.showScaleLabel', {
      defaultMessage: 'Show scale'
    }),
    paramName: "show",
    value: stateParams.gauge.scale.show,
    setValue: function setValue(paramName, value) {
      return setGaugeValue('scale', _objectSpread(_objectSpread({}, stateParams.gauge.scale), {}, _defineProperty({}, paramName, value)));
    }
  }));
}

export { RangesPanel };