/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useMemo } from 'react';
import { EuiTitle, EuiFlexGroup, EuiFlexItem, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { TruncateLabelsOption } from '../../common';
import { getRotateOptions } from '../../../utils/collections';
import { SelectOption, SwitchOption } from '../../../../../charts/public';

function LabelOptions(_ref) {
  var axisLabels = _ref.axisLabels,
      axisFilterCheckboxName = _ref.axisFilterCheckboxName,
      setAxisLabel = _ref.setAxisLabel;
  var setAxisLabelRotate = useCallback(function (paramName, value) {
    setAxisLabel(paramName, Number(value));
  }, [setAxisLabel]);
  var rotateOptions = useMemo(getRotateOptions, []);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeVislib.controls.pointSeries.categoryAxis.labelsTitle",
    defaultMessage: "Labels"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.controls.pointSeries.categoryAxis.showLabelsLabel', {
      defaultMessage: 'Show labels'
    }),
    paramName: "show",
    value: axisLabels.show,
    setValue: setAxisLabel
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    "data-test-subj": axisFilterCheckboxName,
    disabled: !axisLabels.show,
    label: i18n.translate('visTypeVislib.controls.pointSeries.categoryAxis.filterLabelsLabel', {
      defaultMessage: 'Filter labels'
    }),
    paramName: "filter",
    value: axisLabels.filter,
    setValue: setAxisLabel
  }), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(SelectOption, {
    disabled: !axisLabels.show,
    label: i18n.translate('visTypeVislib.controls.pointSeries.categoryAxis.alignLabel', {
      defaultMessage: 'Align'
    }),
    options: rotateOptions,
    paramName: "rotate",
    value: axisLabels.rotate,
    setValue: setAxisLabelRotate
  })), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(TruncateLabelsOption, {
    disabled: !axisLabels.show,
    value: axisLabels.truncate,
    setValue: setAxisLabel
  }))));
}

export { LabelOptions };