/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useCallback } from 'react';
import { EuiFlexGroup, EuiFlexItem, EuiFormRow } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { ScaleTypes } from '../../../utils/collections';
import { NumberInputOption } from '../../../../../charts/public';
var rangeError = i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.minErrorMessage', {
  defaultMessage: 'Min should be less than Max.'
});
var minError = i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.minNeededScaleText', {
  defaultMessage: 'Min must exceed 0 when a log scale is selected.'
});

function areExtentsValid() {
  var min = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  var max = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

  if (min === null || max === null) {
    return true;
  }

  return max > min;
}

function isNullOrUndefined(value) {
  return value === null || value === undefined;
}

function YExtents(_ref) {
  var scale = _ref.scale,
      setScale = _ref.setScale,
      setMultipleValidity = _ref.setMultipleValidity;
  var min = scale.min,
      max = scale.max,
      type = scale.type;
  var errors = [];

  if (!areExtentsValid(min, max)) {
    errors.push(rangeError);
  }

  if (type === ScaleTypes.LOG && (isNullOrUndefined(min) || min <= 0)) {
    errors.push(minError);
  }

  var isValid = !errors.length;
  var setExtents = useCallback(function (paramName, value) {
    setScale(paramName, value === '' ? null : value);
  }, [setScale]);
  useEffect(function () {
    setMultipleValidity('yExtents', isValid);
    return function () {
      return setMultipleValidity('yExtents', true);
    };
  }, [isValid, setMultipleValidity]);
  return /*#__PURE__*/React.createElement(EuiFormRow, {
    error: errors,
    isInvalid: !!errors.length,
    fullWidth: true,
    compressed: true
  }, /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(NumberInputOption, {
    "data-test-subj": "yAxisYExtentsMin",
    isInvalid: !!errors.length,
    label: i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.minLabel', {
      defaultMessage: 'Min'
    }),
    step: 0.1,
    paramName: "min",
    value: isNullOrUndefined(min) ? '' : min,
    setValue: setExtents
  })), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(NumberInputOption, {
    "data-test-subj": "yAxisYExtentsMax",
    label: i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.maxLabel', {
      defaultMessage: 'Max'
    }),
    step: 0.1,
    paramName: "max",
    value: isNullOrUndefined(max) ? '' : max,
    setValue: setExtents
  })))));
}

export { YExtents };