/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.FoldingHandler;
import com.intellij.psi.codeStyle.arrangement.FoldingInfo;
import com.intellij.psi.codeStyle.arrangement.Info;
import com.intellij.psi.codeStyle.arrangement.RangeHandler;
import com.intellij.psi.codeStyle.arrangement.RichTextHandler;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRearrangerTest
extends BasePlatformTestCase {
    private static final RichTextHandler[] RICH_TEXT_HANDLERS = new RichTextHandler[]{new RangeHandler(), new FoldingHandler()};
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("([^\\s]+)=([^\\s]+)");
    protected FileType fileType;
    protected Language language;

    @NotNull
    protected CommonCodeStyleSettings getCommonSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = CodeStyle.getSettings((Project)this.myFixture.getProject()).getCommonSettings(this.language);
        if (commonCodeStyleSettings == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(0);
        }
        return commonCodeStyleSettings;
    }

    protected static ArrangementSectionRule section(StdArrangementMatchRule ... rules) {
        if (rules == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(1);
        }
        return AbstractRearrangerTest.section(null, null, rules);
    }

    protected static ArrangementSectionRule section(@Nullable String start, @Nullable String end, StdArrangementMatchRule ... rules) {
        if (rules == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(2);
        }
        return ArrangementSectionRule.create((String)start, (String)end, (StdArrangementMatchRule[])rules);
    }

    protected static StdArrangementRuleAliasToken alias(@NotNull String id, StdArrangementMatchRule ... rules) {
        if (id == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(3);
        }
        if (rules == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(4);
        }
        return new StdArrangementRuleAliasToken(id, id, (List)ContainerUtil.newArrayList((Object[])rules));
    }

    @NotNull
    protected static ArrangementGroupingRule group(@NotNull ArrangementSettingsToken type) {
        if (type == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(5);
        }
        return AbstractRearrangerTest.group(type, StdArrangementTokens.Order.KEEP);
    }

    @NotNull
    protected static ArrangementGroupingRule group(@NotNull ArrangementSettingsToken type, @NotNull ArrangementSettingsToken order) {
        if (type == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(6);
        }
        if (order == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(7);
        }
        return new ArrangementGroupingRule(type, order);
    }

    @NotNull
    protected static StdArrangementMatchRule rule(@NotNull ArrangementSettingsToken token) {
        if (token == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(8);
        }
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)AbstractRearrangerTest.atom(token)));
    }

    @NotNull
    protected static StdArrangementMatchRule nameRule(@NotNull String nameFilter, ArrangementSettingsToken ... tokens) {
        if (nameFilter == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(9);
        }
        if (tokens == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(10);
        }
        if (tokens.length == 0) {
            return new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)AbstractRearrangerTest.atom(nameFilter)));
        }
        ArrangementAtomMatchCondition[] conditions = new ArrangementAtomMatchCondition[tokens.length + 1];
        conditions[0] = AbstractRearrangerTest.atom(nameFilter);
        for (int i = 0; i < tokens.length; ++i) {
            conditions[i + 1] = AbstractRearrangerTest.atom(tokens[i]);
        }
        ArrangementMatchCondition compositeCondition = ArrangementUtil.combine((ArrangementMatchCondition[])conditions);
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher(compositeCondition));
    }

    @NotNull
    protected static StdArrangementMatchRule rule(ArrangementSettingsToken ... conditions) {
        if (conditions == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(11);
        }
        return AbstractRearrangerTest.rule(ContainerUtil.map((Object[])conditions, it -> AbstractRearrangerTest.atom(it)));
    }

    @NotNull
    protected static StdArrangementMatchRule rule(@NotNull List<ArrangementAtomMatchCondition> conditions) {
        if (conditions == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(12);
        }
        return AbstractRearrangerTest.rule(conditions.toArray(new ArrangementAtomMatchCondition[0]));
    }

    @NotNull
    protected static StdArrangementMatchRule rule(ArrangementAtomMatchCondition ... conditions) {
        if (conditions == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(13);
        }
        ArrangementMatchCondition compositeCondition = ArrangementUtil.combine((ArrangementMatchCondition[])conditions);
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher(compositeCondition));
    }

    @NotNull
    protected static StdArrangementMatchRule ruleWithOrder(@NotNull ArrangementSettingsToken orderType, @NotNull StdArrangementMatchRule rule2) {
        if (orderType == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(14);
        }
        if (rule2 == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(15);
        }
        return new StdArrangementMatchRule(rule2.getMatcher(), orderType);
    }

    @NotNull
    protected static ArrangementAtomMatchCondition atom(@NotNull ArrangementSettingsToken token) {
        if (token == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(16);
        }
        return new ArrangementAtomMatchCondition(token);
    }

    protected static ArrangementAtomMatchCondition atom(@NotNull ArrangementSettingsToken token, boolean included) {
        if (token == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(17);
        }
        return new ArrangementAtomMatchCondition(token, (Object)included);
    }

    @NotNull
    protected static ArrangementAtomMatchCondition atom(@NotNull String nameFilter) {
        if (nameFilter == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(18);
        }
        return new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME, (Object)nameFilter);
    }

    protected void doTest(@NotNull Map<String, ?> args) {
        if (args == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(19);
        }
        List groupingRules = (List)ObjectUtils.coalesce((Object)((List)args.get("groups")), Collections.emptyList());
        List rules = (List)args.get("rules");
        List<ArrangementSectionRule> sectionRules = this.getSectionRules(rules);
        List aliases = (List)ObjectUtils.coalesce((Object)((List)args.get("aliases")), Collections.emptyList());
        StdArrangementExtendableSettings arrangementSettings = new StdArrangementExtendableSettings(groupingRules, sectionRules, (Collection)aliases);
        String text = (String)args.get("initial");
        String expected = (String)args.get("expected");
        List ranges = (List)args.get("ranges");
        this.doTestWithSettings(text, expected, (ArrangementSettings)arrangementSettings, ranges);
    }

    protected void doTestWithSettings(@NotNull String text, @NotNull String expected, @Nullable ArrangementSettings arrangementSettings, @Nullable List<TextRange> ranges) {
        if (text == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(20);
        }
        if (expected == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(21);
        }
        Info info = AbstractRearrangerTest.parse(text);
        if (!AbstractRearrangerTest.isEmpty(ranges) && !AbstractRearrangerTest.isEmpty(info.ranges)) {
            AbstractRearrangerTest.fail((String)("Duplicate ranges set: explicit: " + ranges + ", derived: " + info.ranges + ", text:\n" + text));
        }
        if (AbstractRearrangerTest.isEmpty(info.ranges)) {
            info.ranges = !AbstractRearrangerTest.isEmpty(ranges) ? ranges : Collections.singletonList(TextRange.from((int)0, (int)text.length()));
        }
        this.myFixture.configureByText(this.fileType, info.text);
        FoldingModel foldingModel = this.myFixture.getEditor().getFoldingModel();
        for (FoldingInfo foldingInfo : info.foldings) {
            foldingModel.runBatchFoldingOperation(() -> {
                FoldRegion region = foldingModel.addFoldRegion(foldingInfo.start, foldingInfo.end, foldingInfo.placeholder);
                if (region != null) {
                    region.setExpanded(false);
                }
            });
        }
        if (arrangementSettings != null) {
            CommonCodeStyleSettings settings = CodeStyle.getSettings((Project)this.myFixture.getProject()).getCommonSettings(this.language);
            settings.setArrangementSettings(arrangementSettings);
        }
        ArrangementEngine engine = ArrangementEngine.getInstance();
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> engine.arrange(this.myFixture.getEditor(), this.myFixture.getFile(), info.ranges), null, null);
        Info after2 = AbstractRearrangerTest.parse(expected);
        AbstractRearrangerTest.assertEquals((String)after2.text, (String)this.myFixture.getEditor().getDocument().getText());
        for (FoldingInfo it : after2.foldings) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(it.start);
            AbstractRearrangerTest.assertNotNull((String)("Expected to find fold region at offset " + it.start), (Object)foldRegion);
            AbstractRearrangerTest.assertEquals((int)it.end, (int)foldRegion.getEndOffset());
        }
    }

    @NotNull
    protected List<ArrangementSectionRule> getSectionRules(@Nullable List<?> rules) {
        if (rules == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                AbstractRearrangerTest.$$$reportNull$$$0(22);
            }
            return list;
        }
        List list = ContainerUtil.map(rules, o -> o instanceof ArrangementSectionRule ? (ArrangementSectionRule)o : ArrangementSectionRule.create((StdArrangementMatchRule[])new StdArrangementMatchRule[]{(StdArrangementMatchRule)o}));
        if (list == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(23);
        }
        return list;
    }

    private static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    @NotNull
    private static Info parse(@NotNull String text) {
        if (text == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(24);
        }
        Info result = new Info();
        StringBuilder buffer = new StringBuilder(text);
        int offset = 0;
        while (offset < buffer.length()) {
            RichTextHandler handler = null;
            int richTextMarkStart = -1;
            for (RichTextHandler h : RICH_TEXT_HANDLERS) {
                int i = buffer.indexOf("<" + h.getMarker(), offset);
                if (i < 0 || handler != null && i >= richTextMarkStart) continue;
                richTextMarkStart = i;
                handler = h;
            }
            if (handler == null) break;
            String marker = handler.getMarker();
            int attrStart = richTextMarkStart + marker.length() + 1;
            int openingTagEnd = buffer.indexOf(">", richTextMarkStart);
            int openTagLength = openingTagEnd - richTextMarkStart + 1;
            Map<String, String> attributes = AbstractRearrangerTest.parseAttributes(buffer.substring(attrStart, openingTagEnd));
            String closingTag = "</" + marker + ">";
            int closingTagStart = buffer.indexOf(closingTag);
            assert (closingTagStart > 0);
            handler.handle(result, attributes, richTextMarkStart, closingTagStart - openTagLength);
            buffer.delete(closingTagStart, closingTagStart + closingTag.length());
            buffer.delete(richTextMarkStart, openingTagEnd + 1);
            offset = closingTagStart - openTagLength;
        }
        result.text = buffer.toString();
        Info info = result;
        if (info == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(25);
        }
        return info;
    }

    @NotNull
    private static Map<String, String> parseAttributes(@NotNull String text) {
        if (text == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(26);
        }
        if (text.isEmpty()) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                AbstractRearrangerTest.$$$reportNull$$$0(27);
            }
            return map;
        }
        Matcher matcher = ATTRIBUTE_PATTERN.matcher(text);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            result.put(matcher.group(1), matcher.group(2));
        }
        LinkedHashMap<String, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            AbstractRearrangerTest.$$$reportNull$$$0(28);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/AbstractRearrangerTest";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 8: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameFilter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 20: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/AbstractRearrangerTest";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSectionRules";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "section";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "alias";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "rule";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "nameRule";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "ruleWithOrder";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "atom";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doTestWithSettings";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

