/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.testFramework.EmptyFileBasedIndex;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jetbrains.annotations.NotNull;
import org.junit.internal.MethodSorter;

public interface TestIndexingModeSupporter {
    public void setIndexingMode(@NotNull IndexingMode var1);

    @NotNull
    public IndexingMode getIndexingMode();

    public static void addTest(@NotNull Class<? extends TestIndexingModeSupporter> aClass, @NotNull IndexingModeTestHandler handler, @NotNull TestSuite parentSuite) {
        if (aClass == null) {
            TestIndexingModeSupporter.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            TestIndexingModeSupporter.$$$reportNull$$$0(1);
        }
        if (parentSuite == null) {
            TestIndexingModeSupporter.$$$reportNull$$$0(2);
        }
        if (handler.shouldIgnore(aClass)) {
            return;
        }
        try {
            TestSuite suite = handler.createTestSuite();
            suite.setName(aClass.getSimpleName());
            boolean foundTests = false;
            Constructor<? extends TestIndexingModeSupporter> constructor = aClass.getConstructor(new Class[0]);
            for (Method declaredMethod : MethodSorter.getDeclaredMethods(aClass)) {
                String methodName;
                if (!Modifier.isPublic(declaredMethod.getModifiers()) || !(methodName = declaredMethod.getName()).startsWith("test") || TestFrameworkUtil.isPerformanceTest(methodName, aClass.getName()) || handler.shouldIgnore(declaredMethod, aClass)) continue;
                TestIndexingModeSupporter aCase = constructor.newInstance(new Object[0]);
                aCase.setIndexingMode(handler.getIndexingMode());
                if (aCase instanceof TestCase) {
                    TestCase testCase = (TestCase)aCase;
                    testCase.setName(methodName);
                    suite.addTest((Test)testCase);
                } else {
                    parentSuite.addTest(TestSuite.warning((String)(aClass.getName() + "is not a TestSuite")));
                }
                foundTests = true;
            }
            if (foundTests) {
                parentSuite.addTest((Test)suite);
            }
        }
        catch (NoSuchMethodException e) {
            parentSuite.addTest(TestSuite.warning((String)("Failed to find default constructor for " + aClass.getName() + ", see log")));
            e.printStackTrace();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            parentSuite.addTest(TestSuite.warning((String)("Failed to instantiate " + aClass.getName() + ", see log")));
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "handler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "parentSuite";
                break;
            }
        }
        objectArray[1] = "com/intellij/testFramework/TestIndexingModeSupporter";
        objectArray[2] = "addTest";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class IndexingModeTestHandler {
        public final String myTestSuiteName;
        public final String myTestNamePrefix;

        protected IndexingModeTestHandler(@NotNull String testSuiteName, @NotNull String testNamePrefix) {
            if (testSuiteName == null) {
                IndexingModeTestHandler.$$$reportNull$$$0(0);
            }
            if (testNamePrefix == null) {
                IndexingModeTestHandler.$$$reportNull$$$0(1);
            }
            this.myTestSuiteName = testSuiteName;
            this.myTestNamePrefix = testNamePrefix;
        }

        public TestSuite createTestSuite() {
            return new NamedTestSuite(this.myTestSuiteName, this.myTestNamePrefix);
        }

        public abstract boolean shouldIgnore(@NotNull Class<? extends TestIndexingModeSupporter> var1);

        public abstract boolean shouldIgnore(@NotNull Method var1, @NotNull Class<? extends TestIndexingModeSupporter> var2);

        @NotNull
        public abstract IndexingMode getIndexingMode();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "testSuiteName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "testNamePrefix";
                    break;
                }
            }
            objectArray[1] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingModeTestHandler";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class NamedTestSuite
        extends TestSuite {
            private final String myPrefix;

            private NamedTestSuite(String name, String prefix) {
                super(name);
                this.myPrefix = prefix;
            }

            public void setName(String name) {
                super.setName(this.myPrefix + name);
            }
        }
    }

    public static enum IndexingMode {
        SMART{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (testRootDisposable == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "testRootDisposable";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingMode$1";
                objectArray[2] = "setUpTest";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        DUMB_FULL_INDEX{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (testRootDisposable == null) {
                    2.$$$reportNull$$$0(1);
                }
                IndexingMode.indexEverythingAndBecomeDumb(project2);
            }

            @Override
            public void ensureIndexingStatus(@NotNull Project project2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                DumbServiceImpl dumbService = DumbServiceImpl.getInstance((Project)project2);
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    dumbService.setDumb(false);
                    dumbService.queueTask((DumbModeTask)new UnindexedFilesUpdater(project2));
                    dumbService.setDumb(true);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testRootDisposable";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingMode$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setUpTest";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "ensureIndexingStatus";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        DUMB_RUNTIME_ONLY_INDEX{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                if (project2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (testRootDisposable == null) {
                    3.$$$reportNull$$$0(1);
                }
                IndexingMode.becomeDumb(project2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "testRootDisposable";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingMode$3";
                objectArray[2] = "setUpTest";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        DUMB_EMPTY_INDEX{

            @Override
            public void setUpTest(@NotNull Project project2, @NotNull Disposable testRootDisposable) {
                if (project2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (testRootDisposable == null) {
                    4.$$$reportNull$$$0(1);
                }
                ServiceContainerUtil.replaceService((ComponentManager)ApplicationManager.getApplication(), FileBasedIndex.class, new EmptyFileBasedIndex(), testRootDisposable);
                IndexingMode.becomeDumb(project2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "testRootDisposable";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingMode$4";
                objectArray[2] = "setUpTest";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        public abstract void setUpTest(@NotNull Project var1, @NotNull Disposable var2);

        public void ensureIndexingStatus(@NotNull Project project2) {
            if (project2 == null) {
                IndexingMode.$$$reportNull$$$0(0);
            }
        }

        private static void becomeDumb(@NotNull Project project2) {
            if (project2 == null) {
                IndexingMode.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().invokeAndWait(() -> DumbServiceImpl.getInstance((Project)project2).setDumb(true));
        }

        private static void indexEverythingAndBecomeDumb(@NotNull Project project2) {
            if (project2 == null) {
                IndexingMode.$$$reportNull$$$0(2);
            }
            DumbServiceImpl dumbService = DumbServiceImpl.getInstance((Project)project2);
            ApplicationManager.getApplication().invokeAndWait(() -> {
                dumbService.setDumb(false);
                dumbService.queueTask((DumbModeTask)new UnindexedFilesUpdater(project2));
                dumbService.setDumb(true);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/testFramework/TestIndexingModeSupporter$IndexingMode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "ensureIndexingStatus";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "becomeDumb";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexEverythingAndBecomeDumb";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

