/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLexer;
import com.intellij.json.JsonParserDefinition;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JsonNamesValidator
implements NamesValidator {
    private final JsonLexer myLexer = new JsonLexer();

    public synchronized boolean isKeyword(@NotNull String name, Project project) {
        if (name == null) {
            JsonNamesValidator.$$$reportNull$$$0(0);
        }
        this.myLexer.start(name);
        return JsonParserDefinition.JSON_KEYWORDS.contains(this.myLexer.getTokenType()) && this.myLexer.getTokenEnd() == name.length();
    }

    public synchronized boolean isIdentifier(@NotNull String name, Project project) {
        if (name == null) {
            JsonNamesValidator.$$$reportNull$$$0(1);
        }
        if (!StringUtil.startsWithChar((CharSequence)name, (char)'\'') && !StringUtil.startsWithChar((CharSequence)name, (char)'\"')) {
            name = "\"" + name;
        }
        if (!StringUtil.endsWithChar((CharSequence)name, (char)'\"') && !StringUtil.endsWithChar((CharSequence)name, (char)'\'')) {
            name = name + "\"";
        }
        this.myLexer.start(name);
        IElementType type = this.myLexer.getTokenType();
        return this.myLexer.getTokenEnd() == name.length() && (type == JsonElementTypes.DOUBLE_QUOTED_STRING || type == JsonElementTypes.SINGLE_QUOTED_STRING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "name";
        objectArray2[1] = "com/intellij/json/JsonNamesValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isKeyword";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

