/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.ListCreationQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStatement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyListCreationInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyListCreationInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyListCreationInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyListCreationInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            PyExpression statement;
            if (!(node.getAssignedValue() instanceof PyListLiteralExpression)) {
                return;
            }
            PyExpression[] targets = node.getTargets();
            if (targets.length != 1) {
                return;
            }
            PyExpression target = targets[0];
            String name = target.getName();
            if (name == null) {
                return;
            }
            PyStatement expressionStatement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)node, PyStatement.class);
            if (!(expressionStatement instanceof PyExpressionStatement)) {
                return;
            }
            ListCreationQuickFix quickFix = null;
            String message = "This list creation could be rewritten as a list literal";
            while (expressionStatement instanceof PyExpressionStatement && (statement = ((PyExpressionStatement)expressionStatement).getExpression()) instanceof PyCallExpression) {
                PyCallExpression callExpression = (PyCallExpression)statement;
                PyExpression callee = callExpression.getCallee();
                if (callee instanceof PyQualifiedExpression) {
                    PyArgumentList argList;
                    PyExpression qualifier = ((PyQualifiedExpression)callee).getQualifier();
                    String funcName = ((PyQualifiedExpression)callee).getReferencedName();
                    if (qualifier != null && name.equals(qualifier.getText()) && "append".equals(funcName) && (argList = callExpression.getArgumentList()) != null) {
                        for (PyExpression argument : argList.getArguments()) {
                            if (!argument.getText().equals(name)) continue;
                            if (quickFix != null) {
                                this.registerProblem((PsiElement)node, "This list creation could be rewritten as a list literal", quickFix);
                            }
                            return;
                        }
                        if (quickFix == null) {
                            quickFix = new ListCreationQuickFix(node);
                        }
                        quickFix.addStatement((PyExpressionStatement)expressionStatement);
                    }
                }
                if (quickFix == null) {
                    return;
                }
                expressionStatement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)expressionStatement, PyStatement.class);
            }
            if (quickFix != null) {
                this.registerProblem((PsiElement)node, "This list creation could be rewritten as a list literal", quickFix);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyListCreationInspection$Visitor", "<init>"));
        }
    }
}

