/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.inspections.PyEncodingUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddEncodingQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PyNonAsciiCharInspection
extends PyInspection {
    public String myDefaultEncoding = "utf-8";
    public int myEncodingFormatIndex = 0;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyNonAsciiCharInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyNonAsciiCharInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    public JComponent createOptionsPanel() {
        return PythonUiService.getInstance().createEncodingsOptionsPanel(PyEncodingUtil.POSSIBLE_ENCODINGS, this.myDefaultEncoding, PyEncodingUtil.ENCODING_FORMAT, this.myEncodingFormatIndex, (Consumer<String>)((Consumer)encoding -> {
            this.myDefaultEncoding = encoding;
        }), (Consumer<Integer>)((Consumer)formatIndex -> {
            this.myEncodingFormatIndex = formatIndex;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyNonAsciiCharInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class Visitor
    extends PyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        public void visitComment(@NotNull PsiComment node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.checkString((PsiElement)node, node.getText());
        }

        private void checkString(PsiElement node, String value) {
            if (LanguageLevel.forElement(node).isPython2()) {
                PsiFile file = node.getContainingFile();
                if (file == null) {
                    return;
                }
                String charsetString = PythonFileType.getCharsetFromEncodingDeclaration(file);
                boolean hasNonAscii = false;
                CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
                int length = value.length();
                char c = '\u0000';
                for (int i = 0; i < length; ++i) {
                    c = value.charAt(i);
                    if (asciiEncoder.canEncode(c)) continue;
                    hasNonAscii = true;
                    break;
                }
                if (hasNonAscii && charsetString == null) {
                    this.registerProblem(node, "Non-ASCII character " + c + " in file, but no encoding declared", new AddEncodingQuickFix(PyNonAsciiCharInspection.this.myDefaultEncoding, PyNonAsciiCharInspection.this.myEncodingFormatIndex));
                }
            }
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            this.checkString(node, node.getText());
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            this.checkString((PsiElement)node, node.getText());
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            this.checkString(node, node.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyNonAsciiCharInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitComment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

