/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.jetbrains.python.defaultProjectAwareService.PyDefaultProjectAwareModuleConfiguratorImpl;
import com.jetbrains.python.defaultProjectAwareService.PyDefaultProjectAwareService;
import com.jetbrains.python.defaultProjectAwareService.PyDefaultProjectAwareServiceClasses;
import com.jetbrains.python.defaultProjectAwareService.PyDefaultProjectAwareServiceModuleConfigurator;
import com.jetbrains.python.testing.PyTestFrameworkService;
import com.jetbrains.python.testing.PythonTestConfigurationsModel;
import com.jetbrains.python.testing.TestRunnerDetector;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestRunnerService
extends PyDefaultProjectAwareService<ServiceState, TestRunnerService, AppService, ModuleService> {
    private static final PyDefaultProjectAwareServiceClasses<ServiceState, TestRunnerService, AppService, ModuleService> SERVICE_CLASSES = new PyDefaultProjectAwareServiceClasses(AppService.class, ModuleService.class);
    private static final TestRunnerDetector DETECTOR = new TestRunnerDetector();
    private final List<String> myConfigurations = new ArrayList<String>();

    protected TestRunnerService() {
        super(new ServiceState());
        this.myConfigurations.add(PythonTestConfigurationsModel.getPythonsUnittestName());
        for (String framework : PyTestFrameworkService.getFrameworkNamesArray()) {
            this.myConfigurations.add(PyTestFrameworkService.getSdkReadableNameByFramework(framework));
        }
    }

    @NotNull
    public final List<String> getConfigurations() {
        List<String> list = this.myConfigurations;
        if (list == null) {
            TestRunnerService.$$$reportNull$$$0(0);
        }
        return list;
    }

    public final void setProjectConfiguration(@NotNull String projectConfiguration) {
        if (projectConfiguration == null) {
            TestRunnerService.$$$reportNull$$$0(1);
        }
        ((ServiceState)this.getState()).PROJECT_TEST_RUNNER = projectConfiguration;
    }

    @NotNull
    public static TestRunnerService getInstance(@Nullable Module module) {
        TestRunnerService testRunnerService = SERVICE_CLASSES.getService(module);
        if (testRunnerService == null) {
            TestRunnerService.$$$reportNull$$$0(2);
        }
        return testRunnerService;
    }

    @NotNull
    public static PyDefaultProjectAwareServiceModuleConfigurator getConfigurator() {
        return new PyDefaultProjectAwareModuleConfiguratorImpl<ServiceState, TestRunnerService, AppService, ModuleService>(SERVICE_CLASSES, DETECTOR);
    }

    @NotNull
    public final String getProjectConfiguration() {
        String runnerFromConfig = ((ServiceState)this.getState()).PROJECT_TEST_RUNNER;
        if ("py.test".equals(runnerFromConfig)) {
            runnerFromConfig = "pytest";
        }
        String string = runnerFromConfig;
        if (string == null) {
            TestRunnerService.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/TestRunnerService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/TestRunnerService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProjectConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @State(name="TestRunnerService")
    static final class ModuleService
    extends TestRunnerService {
        ModuleService() {
        }
    }

    @State(name="AppTestRunnerService", storages={@Storage(value="TestRunnerService.xml")})
    static final class AppService
    extends TestRunnerService {
        AppService() {
        }
    }

    static final class ServiceState {
        @NotNull
        public String PROJECT_TEST_RUNNER;

        ServiceState(@NotNull String projectTestRunner) {
            if (projectTestRunner == null) {
                ServiceState.$$$reportNull$$$0(0);
            }
            assert (!projectTestRunner.isEmpty());
            this.PROJECT_TEST_RUNNER = projectTestRunner;
        }

        ServiceState() {
            this(PythonTestConfigurationsModel.getPythonsUnittestName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectTestRunner", "com/jetbrains/python/testing/TestRunnerService$ServiceState", "<init>"));
        }
    }
}

