/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.validation.PyAnnotator;
import org.jetbrains.annotations.NotNull;

public class TypeAnnotationTargetAnnotator
extends PyAnnotator {
    @Override
    public void visitPyAssignmentStatement(PyAssignmentStatement node) {
        if (node.getAnnotation() != null && LanguageLevel.forElement(node).isAtLeast(LanguageLevel.PYTHON36)) {
            PyExpression target;
            if (node.getRawTargets().length > 1) {
                this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyBundle.message("ANN.variable.annotation.cannot.be.used.in.assignment.with.multiple.targets", new Object[0])).create();
            }
            if ((target = node.getLeftHandSideExpression()) != null) {
                this.checkAnnotationTarget(target);
            }
        }
    }

    @Override
    public void visitPyTypeDeclarationStatement(PyTypeDeclarationStatement node) {
        if (node.getAnnotation() != null && LanguageLevel.forElement(node).isAtLeast(LanguageLevel.PYTHON36)) {
            this.checkAnnotationTarget(node.getTarget());
        }
    }

    private void checkAnnotationTarget(@NotNull PyExpression expression) {
        PyExpression innerExpr;
        if (expression == null) {
            TypeAnnotationTargetAnnotator.$$$reportNull$$$0(0);
        }
        if ((innerExpr = PyPsiUtils.flattenParens(expression)) instanceof PyTupleExpression || innerExpr instanceof PyListLiteralExpression) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyBundle.message("ANN.variable.annotation.cannot.be.combined.with.tuple.unpacking", new Object[0])).range((PsiElement)innerExpr).create();
        } else if (innerExpr != null && !(innerExpr instanceof PyTargetExpression) && !(innerExpr instanceof PySubscriptionExpression)) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyBundle.message("ANN.illegal.target.for.variable.annotation", new Object[0])).range((PsiElement)innerExpr).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/validation/TypeAnnotationTargetAnnotator", "checkAnnotationTarget"));
    }
}

