/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ObjectUtils;
import org.editorconfig.Utils;
import org.jetbrains.annotations.NotNull;

public class EditorConfigStatusListener
implements CodeStyleSettingsListener,
Disposable {
    private boolean myEnabledStatus;
    private final VirtualFile myVirtualFile;
    private final Project myProject;

    public EditorConfigStatusListener(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myEnabledStatus = Utils.isEnabled(project);
        this.myVirtualFile = virtualFile;
        CodeStyleSettingsManager.getInstance((Project)project).addListener((CodeStyleSettingsListener)this);
    }

    public final void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        boolean newEnabledStatus;
        if (event == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(2);
        }
        if (this.myEnabledStatus != (newEnabledStatus = Utils.isEnabled(this.myProject))) {
            this.myEnabledStatus = newEnabledStatus;
            this.onEditorConfigEnabled(newEnabledStatus);
        }
    }

    private void onEditorConfigEnabled(boolean isEnabled) {
        if (!isEnabled) {
            FileEditorManager.getInstance((Project)this.myProject).closeFile(this.myVirtualFile);
            FileEditorManager.getInstance((Project)this.myProject).openFile(this.myVirtualFile, false);
        }
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myVirtualFile);
        ObjectUtils.consumeIfNotNull((Object)FileDocumentManager.getInstance().getDocument(this.myVirtualFile), document -> ObjectUtils.consumeIfNotNull((Object)PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document), psiFile -> DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile)));
    }

    public void dispose() {
        CodeStyleSettingsManager.removeListener((Project)this.myProject, (CodeStyleSettingsListener)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "org/editorconfig/configmanagement/editor/EditorConfigStatusListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "codeStyleSettingsChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

