/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.highlighting.Util;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.diff.impl.processing.UniteSameType;
import com.intellij.openapi.diff.impl.processing.Word;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class ByWord
implements DiffPolicy {
    private static final Logger LOG = Logger.getInstance(ByWord.class);
    private final ComparisonPolicy myComparisonPolicy;

    public ByWord(ComparisonPolicy comparisonPolicy) {
        this.myComparisonPolicy = comparisonPolicy;
    }

    @Override
    public DiffFragment @NotNull [] buildFragments(@NotNull String text1, @NotNull String text2) throws FilesTooBigForDiffException {
        if (text1 == null) {
            ByWord.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(1);
        }
        DiffFragment[] diffFragmentArray = this.buildFragments(DiffString.create(text1), DiffString.create(text2));
        if (diffFragmentArray == null) {
            ByWord.$$$reportNull$$$0(2);
        }
        return diffFragmentArray;
    }

    @Override
    public DiffFragment @NotNull [] buildFragments(@NotNull DiffString text1, @NotNull DiffString text2) throws FilesTooBigForDiffException {
        if (text1 == null) {
            ByWord.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            ByWord.$$$reportNull$$$0(4);
        }
        Object[] words1 = ByWord.buildWords(text1, this.myComparisonPolicy);
        Object[] words2 = ByWord.buildWords(text2, this.myComparisonPolicy);
        Diff.Change change = Diff.buildChanges(words1, words2);
        change = Util.concatEquals(change, words1, words2);
        if (Math.max(ByWord.countNotWhitespaces((Word[])words1), ByWord.countNotWhitespaces((Word[])words2)) > 0 && ByWord.countEqual(change, (Word[])words1, (Word[])words2) == 0) {
            DiffFragment[] diffFragmentArray = new DiffFragment[]{this.myComparisonPolicy.createFragment(text1, text2)};
            if (diffFragmentArray == null) {
                ByWord.$$$reportNull$$$0(5);
            }
            return diffFragmentArray;
        }
        FragmentBuilder result = new FragmentBuilder((Word[])words1, (Word[])words2, this.myComparisonPolicy, text1, text2);
        FragmentBuilder.Version version1 = result.getVersion1();
        FragmentBuilder.Version version2 = result.getVersion2();
        while (change != null) {
            if (change.line0 > version1.getCurrentWordIndex()) {
                ByWord.processEquals(change.line0, change.line1, result);
            }
            if (change.inserted == 0) {
                ByWord.processOneside(version1, change.deleted);
            } else if (change.deleted == 0) {
                ByWord.processOneside(version2, change.inserted);
            } else {
                DiffString prefix1 = version1.getCurrentWordPrefix();
                DiffString prefix2 = version2.getCurrentWordPrefix();
                if (!prefix1.isEmpty() || !prefix2.isEmpty()) {
                    result.add(this.myComparisonPolicy.createFragment(prefix1, prefix2));
                }
                result.addChangedWords(change.deleted, change.inserted);
            }
            change = change.link;
        }
        ByWord.processEquals(words1.length, words2.length, result);
        result.addTails();
        DiffFragment[] fragments = result.getFragments();
        DiffFragment firstFragment = fragments[0];
        if (firstFragment.isEmpty()) {
            DiffFragment[] newFragments = new DiffFragment[fragments.length - 1];
            System.arraycopy(fragments, 1, newFragments, 0, newFragments.length);
            fragments = newFragments;
        }
        if (fragments == null) {
            ByWord.$$$reportNull$$$0(6);
        }
        return fragments;
    }

    private static int countNotWhitespaces(Word @NotNull [] words) {
        if (words == null) {
            ByWord.$$$reportNull$$$0(7);
        }
        int counter = 0;
        for (Word word : words) {
            if (word.isWhitespace()) continue;
            ++counter;
        }
        return counter;
    }

    private static int countEqual(Diff.Change change, Word @NotNull [] words1, Word @NotNull [] words2) {
        if (words1 == null) {
            ByWord.$$$reportNull$$$0(8);
        }
        if (words2 == null) {
            ByWord.$$$reportNull$$$0(9);
        }
        int counter = 0;
        int position1 = 0;
        int position2 = 0;
        while (change != null) {
            if (change.line0 > position1) {
                int same = change.line0 - position1;
                LOG.assertTrue(same == change.line1 - position2);
                for (int i = 0; i < same; ++i) {
                    if (words1[position1 + i].isWhitespace() || words2[position2 + i].isWhitespace()) continue;
                    ++counter;
                }
                position1 += same;
                position2 += same;
            }
            position1 += change.deleted;
            position2 += change.inserted;
            change = change.link;
        }
        int tailCount = words1.length - position1;
        LOG.assertTrue(tailCount == words2.length - position2);
        while (tailCount > 0) {
            if (!words1[words1.length - tailCount].isWhitespace() && !words2[words2.length - tailCount].isWhitespace()) {
                ++counter;
            }
            --tailCount;
        }
        return counter;
    }

    private static void processOneside(@NotNull FragmentBuilder.Version version, int wordCount) {
        if (version == null) {
            ByWord.$$$reportNull$$$0(10);
        }
        DiffString prefix = version.getCurrentWordPrefix();
        version.addOneSide(prefix, wordCount);
    }

    private static void processEquals(int changed1, int changed2, @NotNull FragmentBuilder result) throws FilesTooBigForDiffException {
        if (result == null) {
            ByWord.$$$reportNull$$$0(11);
        }
        while (result.getVersion1().getCurrentWordIndex() < changed1) {
            result.processEqual();
        }
        LOG.assertTrue(changed2 == result.getVersion2().getCurrentWordIndex());
    }

    static Word @NotNull [] buildWords(@NotNull String text, @NotNull ComparisonPolicy policy) {
        if (text == null) {
            ByWord.$$$reportNull$$$0(12);
        }
        if (policy == null) {
            ByWord.$$$reportNull$$$0(13);
        }
        return ByWord.buildWords(DiffString.create(text), policy);
    }

    static Word @NotNull [] buildWords(@NotNull DiffString text, @NotNull ComparisonPolicy policy) {
        if (text == null) {
            ByWord.$$$reportNull$$$0(14);
        }
        if (policy == null) {
            ByWord.$$$reportNull$$$0(15);
        }
        ArrayList<Word> words = new ArrayList<Word>();
        if (text.isEmpty() || !Character.isWhitespace(text.charAt(0))) {
            words.add(policy.createFormatting(text, TextRange.EMPTY_RANGE));
        }
        int start = 0;
        boolean withinFormatting = true;
        for (int i = 0; i < text.length(); ++i) {
            char nextChar = text.charAt(i);
            boolean isWhitespace = Character.isWhitespace(nextChar);
            if (withinFormatting) {
                if (isWhitespace) continue;
                if (start != -1 && start < i) {
                    words.add(policy.createFormatting(text, new TextRange(start, i)));
                }
                start = -1;
                withinFormatting = false;
            }
            if (nextChar == '\n') {
                if (start != -1) {
                    words.add(new Word(text, new TextRange(start, i)));
                }
                start = i;
                withinFormatting = true;
                continue;
            }
            if (Util.DELIMITERS_SET.contains((int)nextChar)) {
                if (start == -1) continue;
                words.add(new Word(text, new TextRange(start, i)));
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start != -1) {
            TextRange range = new TextRange(start, text.length());
            Word lastWord = withinFormatting ? policy.createFormatting(text, range) : new Word(text, range);
            words.add(lastWord);
        }
        Word[] wordArray = words.toArray(new Word[0]);
        if (wordArray == null) {
            ByWord.$$$reportNull$$$0(16);
        }
        return wordArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/processing/ByWord";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/processing/ByWord";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFragments";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFragments";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "countNotWhitespaces";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "countEqual";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processOneside";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processEquals";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildWords";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FragmentBuilder {
        private final ArrayList<DiffFragment> myFragments;
        private final Version myVersion1;
        private final Version myVersion2;
        private final DiffPolicy.ByChar BY_CHAR;
        private final DiffCorrection.ChangedSpace CORRECTION;
        private final ComparisonPolicy myComparisonPolicy;

        FragmentBuilder(Word @NotNull [] words1, Word @NotNull [] words2, @NotNull ComparisonPolicy comparisonPolicy, @NotNull DiffString text1, @NotNull DiffString text2) {
            if (comparisonPolicy == null) {
                FragmentBuilder.$$$reportNull$$$0(0);
            }
            if (text1 == null) {
                FragmentBuilder.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                FragmentBuilder.$$$reportNull$$$0(2);
            }
            if (words1 == null) {
                FragmentBuilder.$$$reportNull$$$0(3);
            }
            if (words2 == null) {
                FragmentBuilder.$$$reportNull$$$0(4);
            }
            this.myFragments = new ArrayList();
            this.myVersion1 = new Version(words1, text1, this, true);
            this.myVersion2 = new Version(words2, text2, this, false);
            this.BY_CHAR = new DiffPolicy.ByChar(comparisonPolicy);
            this.CORRECTION = new DiffCorrection.ChangedSpace(comparisonPolicy);
            this.myComparisonPolicy = comparisonPolicy;
        }

        public DiffFragment @NotNull [] getFragments() {
            DiffFragment[] diffFragmentArray = this.myFragments.toArray(new DiffFragment[0]);
            if (diffFragmentArray == null) {
                FragmentBuilder.$$$reportNull$$$0(5);
            }
            return diffFragmentArray;
        }

        @NotNull
        public Version getVersion1() {
            Version version = this.myVersion1;
            if (version == null) {
                FragmentBuilder.$$$reportNull$$$0(6);
            }
            return version;
        }

        @NotNull
        public Version getVersion2() {
            Version version = this.myVersion2;
            if (version == null) {
                FragmentBuilder.$$$reportNull$$$0(7);
            }
            return version;
        }

        private void addAll(DiffFragment @NotNull [] fragments) {
            if (fragments == null) {
                FragmentBuilder.$$$reportNull$$$0(8);
            }
            for (DiffFragment fragment : fragments) {
                this.add(fragment);
            }
        }

        private void add(@NotNull DiffFragment fragment) {
            int lastIndex;
            DiffFragment prevFragment;
            if (fragment == null) {
                FragmentBuilder.$$$reportNull$$$0(9);
            }
            DiffString text1 = fragment.getText1();
            DiffString text2 = fragment.getText2();
            if (text1 != null) {
                this.myVersion1.addOffset(text1.length());
            }
            if (text2 != null) {
                this.myVersion2.addOffset(text2.length());
            }
            if (fragment.isEqual() && !this.myFragments.isEmpty() && (prevFragment = this.myFragments.get(lastIndex = this.myFragments.size() - 1)).isEqual()) {
                prevFragment.appendText1(text1);
                prevFragment.appendText2(text2);
                return;
            }
            this.myFragments.add(fragment);
        }

        private void addEqual(@NotNull Word word1, @NotNull Word word2) throws FilesTooBigForDiffException {
            if (word1 == null) {
                FragmentBuilder.$$$reportNull$$$0(10);
            }
            if (word2 == null) {
                FragmentBuilder.$$$reportNull$$$0(11);
            }
            this.addAll(this.CORRECTION.correct(new DiffFragment[]{this.myComparisonPolicy.createFragment(word1, word2)}));
        }

        public void processEqual() throws FilesTooBigForDiffException {
            Word word1 = this.myVersion1.getCurrentWord();
            Word word2 = this.myVersion2.getCurrentWord();
            this.addAll(this.fragmentsByChar(this.myVersion1.getCurrentWordPrefix(), this.myVersion2.getCurrentWordPrefix()));
            this.addEqual(word1, word2);
            this.addPostfixes();
            this.myVersion1.incCurrentWord();
            this.myVersion2.incCurrentWord();
        }

        private DiffFragment @NotNull [] fragmentsByChar(@NotNull DiffString text1, @NotNull DiffString text2) throws FilesTooBigForDiffException {
            if (text1 == null) {
                FragmentBuilder.$$$reportNull$$$0(12);
            }
            if (text2 == null) {
                FragmentBuilder.$$$reportNull$$$0(13);
            }
            if (text1.isEmpty() && text2.isEmpty()) {
                if (DiffFragment.EMPTY_ARRAY == null) {
                    FragmentBuilder.$$$reportNull$$$0(14);
                }
                return DiffFragment.EMPTY_ARRAY;
            }
            DiffString side1 = text1.preappend(this.myVersion1.getPrevChar());
            DiffString side2 = text2.preappend(this.myVersion2.getPrevChar());
            DiffFragment[] fragments = this.BY_CHAR.buildFragments(side1, side2);
            DiffFragment[] diffFragmentArray = Util.cutFirst(fragments);
            if (diffFragmentArray == null) {
                FragmentBuilder.$$$reportNull$$$0(15);
            }
            return diffFragmentArray;
        }

        private void addPostfixes() throws FilesTooBigForDiffException {
            DiffFragment[] fragments;
            DiffFragment firstFragment;
            DiffString postfix1 = this.myVersion1.getCurrentWordPostfixAndOneMore();
            DiffString postfix2 = this.myVersion2.getCurrentWordPostfixAndOneMore();
            int length1 = postfix1.length();
            int length2 = postfix2.length();
            DiffFragment wholePostfix = this.myComparisonPolicy.createFragment(postfix1, postfix2);
            if (wholePostfix.isEqual()) {
                this.add(DiffFragment.unchanged(FragmentBuilder.cutLast(postfix1, length1), FragmentBuilder.cutLast(postfix2, length2)));
                return;
            }
            if ((length1 > 0 || length2 > 0) && (firstFragment = (fragments = this.BY_CHAR.buildFragments(postfix1, postfix2))[0]).isEqual()) {
                DiffString text1 = FragmentBuilder.cutLast(firstFragment.getText1(), length1);
                DiffString text2 = FragmentBuilder.cutLast(firstFragment.getText2(), length2);
                this.add(this.myComparisonPolicy.createFragment(text1, text2));
            }
        }

        @NotNull
        private static DiffString cutLast(@NotNull DiffString text, int length) {
            if (text == null) {
                FragmentBuilder.$$$reportNull$$$0(16);
            }
            if (text.length() < length) {
                DiffString diffString = text;
                if (diffString == null) {
                    FragmentBuilder.$$$reportNull$$$0(17);
                }
                return diffString;
            }
            DiffString diffString = text.substring(0, text.length() - 1);
            if (diffString == null) {
                FragmentBuilder.$$$reportNull$$$0(18);
            }
            return diffString;
        }

        private void addOneSide(@NotNull DiffString text, @NotNull FragmentSide side) {
            if (text == null) {
                FragmentBuilder.$$$reportNull$$$0(19);
            }
            if (side == null) {
                FragmentBuilder.$$$reportNull$$$0(20);
            }
            DiffFragment fragment = side.createFragment(text, null, false);
            this.add(this.myComparisonPolicy.createFragment(fragment.getText1(), fragment.getText2()));
        }

        public void addChangedWords(int wordCount1, int wordCount2) {
            this.add(new DiffFragment(this.myVersion1.getWordSequence(wordCount1), this.myVersion2.getWordSequence(wordCount2)));
            this.myVersion1.incCurrentWord(wordCount1);
            this.myVersion2.incCurrentWord(wordCount2);
        }

        public void addTails() throws FilesTooBigForDiffException {
            DiffFragment lastFragment;
            DiffString tail1 = this.myVersion1.getNotProcessedTail();
            DiffString tail2 = this.myVersion2.getNotProcessedTail();
            if (tail1.isEmpty() && tail2.isEmpty()) {
                return;
            }
            DiffFragment[] fragments = this.fragmentsByChar(tail1, tail2);
            if (!this.myFragments.isEmpty() && (lastFragment = this.myFragments.get(this.myFragments.size() - 1)).isChange()) {
                int oneSideCount;
                for (oneSideCount = 0; oneSideCount < fragments.length && fragments[oneSideCount].isOneSide(); ++oneSideCount) {
                }
                if (oneSideCount > 0) {
                    this.myFragments.remove(this.myFragments.size() - 1);
                    DiffFragment[] onesideFragments = new DiffFragment[oneSideCount];
                    DiffFragment[] otherFragments = new DiffFragment[fragments.length - oneSideCount];
                    System.arraycopy(fragments, 0, onesideFragments, 0, oneSideCount);
                    System.arraycopy(fragments, oneSideCount, otherFragments, 0, otherFragments.length);
                    DiffFragment startingOneSides = UniteSameType.uniteAll(onesideFragments);
                    if (startingOneSides.isOneSide()) {
                        this.myFragments.add(lastFragment);
                        this.add(startingOneSides);
                    } else {
                        lastFragment = Util.unite(lastFragment, startingOneSides);
                        this.myFragments.add(lastFragment);
                    }
                    fragments = otherFragments;
                }
            }
            this.addAll(fragments);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 14: 
                case 15: 
                case 17: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 14: 
                case 15: 
                case 17: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comparisonPolicy";
                    break;
                }
                case 1: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 2: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "words1";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "words2";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 14: 
                case 15: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word1";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word2";
                    break;
                }
                case 16: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFragments";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersion1";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersion2";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fragmentsByChar";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cutLast";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 14: 
                case 15: 
                case 17: 
                case 18: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addAll";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addEqual";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "fragmentsByChar";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "cutLast";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "addOneSide";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 14: 
                case 15: 
                case 17: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static class Version {
            private final Word @NotNull [] myWords;
            private int myCurrentWord;
            private int myOffset;
            @NotNull
            private final DiffString myText;
            @NotNull
            private final FragmentBuilder myBuilder;
            private final FragmentSide mySide;

            public Version(Word @NotNull [] words, @NotNull DiffString text, @NotNull FragmentBuilder builder, boolean delete) {
                if (text == null) {
                    Version.$$$reportNull$$$0(0);
                }
                if (builder == null) {
                    Version.$$$reportNull$$$0(1);
                }
                if (words == null) {
                    Version.$$$reportNull$$$0(2);
                }
                this.myCurrentWord = 0;
                this.myOffset = 0;
                this.myWords = words;
                this.myText = text;
                this.myBuilder = builder;
                this.mySide = delete ? FragmentSide.SIDE1 : FragmentSide.SIDE2;
            }

            public int getProcessedOffset() {
                return this.myOffset;
            }

            public int getCurrentWordIndex() {
                return this.myCurrentWord;
            }

            public void addOffset(int offset) {
                this.myOffset += offset;
            }

            public void incCurrentWord() {
                this.incCurrentWord(1);
            }

            @NotNull
            public DiffString getWordSequence(int wordCount) {
                int start = this.myWords[this.myCurrentWord].getStart();
                int end = this.myWords[this.myCurrentWord + wordCount - 1].getEnd();
                DiffString diffString = this.myText.substring(start, end);
                if (diffString == null) {
                    Version.$$$reportNull$$$0(3);
                }
                return diffString;
            }

            public void incCurrentWord(int inserted) {
                this.myCurrentWord += inserted;
            }

            @NotNull
            public Word getCurrentWord() {
                Word word = this.myWords[this.myCurrentWord];
                if (word == null) {
                    Version.$$$reportNull$$$0(4);
                }
                return word;
            }

            @NotNull
            public DiffString getCurrentWordPrefix() {
                DiffString diffString = this.getCurrentWord().getPrefix(this.getProcessedOffset());
                if (diffString == null) {
                    Version.$$$reportNull$$$0(5);
                }
                return diffString;
            }

            @NotNull
            public DiffString getCurrentWordPostfixAndOneMore() {
                int nextStart = this.myCurrentWord < this.myWords.length - 1 ? this.myWords[this.myCurrentWord + 1].getStart() : this.myText.length();
                Word word = this.getCurrentWord();
                DiffString postfix = this.myText.substring(word.getEnd(), nextStart);
                DiffString diffString = postfix.append(nextStart == this.myText.length() ? (char)'\n' : this.myText.charAt(nextStart));
                if (diffString == null) {
                    Version.$$$reportNull$$$0(6);
                }
                return diffString;
            }

            @NotNull
            public DiffString getNotProcessedTail() {
                LOG.assertTrue(this.myCurrentWord == this.myWords.length);
                DiffString diffString = this.myText.substring(this.myOffset, this.myText.length());
                if (diffString == null) {
                    Version.$$$reportNull$$$0(7);
                }
                return diffString;
            }

            public char getPrevChar() {
                return this.myOffset == 0 ? (char)'\n' : this.myText.charAt(this.myOffset - 1);
            }

            public void addOneSide(@NotNull DiffString prefix, int wordCount) {
                if (prefix == null) {
                    Version.$$$reportNull$$$0(8);
                }
                if (!prefix.isEmpty()) {
                    this.myBuilder.addOneSide(prefix, this.mySide);
                }
                this.myBuilder.addOneSide(this.getWordSequence(wordCount), this.mySide);
                this.incCurrentWord(wordCount);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "words";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder$Version";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "prefix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder$Version";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getWordSequence";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCurrentWord";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCurrentWordPrefix";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCurrentWordPostfixAndOneMore";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNotProcessedTail";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "addOneSide";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

