/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathMapping<T> {
    private final boolean myCaseSensitive;
    private final Map<String, T> myPathMap;
    private final TIntHashSet myPathHashSet = new TIntHashSet();

    public FilePathMapping(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
        this.myPathMap = new THashMap(FilePathHashingStrategy.create((boolean)caseSensitive));
    }

    public void add(@NotNull String filePath, @NotNull T value) {
        if (filePath == null) {
            FilePathMapping.$$$reportNull$$$0(0);
        }
        if (value == null) {
            FilePathMapping.$$$reportNull$$$0(1);
        }
        String path2 = StringUtil.trimTrailing((String)filePath, (char)'/');
        this.myPathMap.put(path2, value);
        this.myPathHashSet.add(FilePathMapping.pathHashCode(this.myCaseSensitive, path2));
    }

    public void remove(@NotNull String filePath) {
        if (filePath == null) {
            FilePathMapping.$$$reportNull$$$0(2);
        }
        String path2 = StringUtil.trimTrailing((String)filePath, (char)'/');
        this.myPathMap.remove(path2);
    }

    @NotNull
    public Collection<T> values() {
        Collection<T> collection = this.myPathMap.values();
        if (collection == null) {
            FilePathMapping.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Nullable
    public T getMappingFor(@NotNull FilePath filePath) {
        if (filePath == null) {
            FilePathMapping.$$$reportNull$$$0(4);
        }
        String path2 = filePath.getPath();
        int index = 0;
        int prefixHash = 0;
        TIntArrayList matches = new TIntArrayList();
        if (this.myPathHashSet.contains(prefixHash)) {
            matches.add(index);
        }
        while (index < path2.length()) {
            int nextIndex = path2.indexOf(47, index + 1);
            if (nextIndex == -1) {
                nextIndex = path2.length();
            }
            if (this.myPathHashSet.contains(prefixHash = FilePathMapping.pathHashCode(this.myCaseSensitive, path2, index, nextIndex, prefixHash))) {
                matches.add(nextIndex);
            }
            index = nextIndex;
        }
        for (int i = matches.size() - 1; i >= 0; --i) {
            String prefix = path2.substring(0, matches.get(i));
            T root = this.myPathMap.get(prefix);
            if (root == null) continue;
            return root;
        }
        return null;
    }

    private static int pathHashCode(boolean caseSensitive, @NotNull String path2) {
        if (path2 == null) {
            FilePathMapping.$$$reportNull$$$0(5);
        }
        return FilePathMapping.pathHashCode(caseSensitive, path2, 0, path2.length(), 0);
    }

    private static int pathHashCode(boolean caseSensitive, @NotNull String path2, int offset1, int offset2, int prefixHash) {
        if (path2 == null) {
            FilePathMapping.$$$reportNull$$$0(6);
        }
        if (caseSensitive) {
            return StringUtil.stringHashCode((CharSequence)path2, (int)offset1, (int)offset2, (int)prefixHash);
        }
        return StringUtil.stringHashCodeInsensitive((CharSequence)path2, (int)offset1, (int)offset2, (int)prefixHash);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/projectlevelman/FilePathMapping";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/FilePathMapping";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMappingFor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pathHashCode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

