/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.DateTimeFormatManager;
import com.intellij.util.text.JBDateFormat;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum VcsLogColumn {
    ROOT("", (Class)FilePath.class){

        @Override
        public String getLocalizedName() {
            return "";
        }
    }
    ,
    COMMIT("Subject", (Class)GraphCommitCell.class){

        @Override
        public String getLocalizedName() {
            return VcsLogBundle.message((String)"vcs.log.column.subject", (Object[])new Object[0]);
        }
    }
    ,
    AUTHOR("Author", (Class)String.class){

        @Override
        public String getLocalizedName() {
            return VcsLogBundle.message((String)"vcs.log.column.author", (Object[])new Object[0]);
        }
    }
    ,
    DATE("Date", (Class)String.class){

        @Override
        public String getLocalizedName() {
            return VcsLogBundle.message((String)"vcs.log.column.date", (Object[])new Object[0]);
        }

        @Override
        public String getContentSample() {
            if (DateTimeFormatManager.getInstance().isPrettyFormattingAllowed()) {
                return null;
            }
            return JBDateFormat.getFormatter().formatDateTime(DateFormatUtil.getSampleDateTime());
        }
    }
    ,
    HASH("Hash", (Class)String.class){

        @Override
        public String getLocalizedName() {
            return VcsLogBundle.message((String)"vcs.log.column.hash", (Object[])new Object[0]);
        }

        @Override
        public String getContentSample() {
            return StringUtil.repeat((String)"e", (int)8);
        }
    };

    @NotNull
    public static final List<VcsLogColumn> DYNAMIC_COLUMNS;
    private static final VcsLogColumn @NotNull [] COLUMNS;
    @NotNull
    private final String myName;
    @NotNull
    private final Class<?> myContentClass;

    private VcsLogColumn(String name, Class<?> contentClass) {
        if (name == null) {
            VcsLogColumn.$$$reportNull$$$0(0);
        }
        if (contentClass == null) {
            VcsLogColumn.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myContentClass = contentClass;
    }

    public boolean isDynamic() {
        return DYNAMIC_COLUMNS.contains((Object)this);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            VcsLogColumn.$$$reportNull$$$0(2);
        }
        return string;
    }

    public abstract String getLocalizedName();

    @NotNull
    public String getStableName() {
        String string = this.myName.toLowerCase(Locale.ROOT);
        if (string == null) {
            VcsLogColumn.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    Class<?> getContentClass() {
        Class<?> clazz = this.myContentClass;
        if (clazz == null) {
            VcsLogColumn.$$$reportNull$$$0(4);
        }
        return clazz;
    }

    @Nullable
    public String getContentSample() {
        return null;
    }

    static boolean isValidColumnOrder(@NotNull List<Integer> columnOrder) {
        if (columnOrder == null) {
            VcsLogColumn.$$$reportNull$$$0(5);
        }
        int columnCount = VcsLogColumn.count();
        if (!columnOrder.contains(ROOT.ordinal())) {
            return false;
        }
        if (!columnOrder.contains(COMMIT.ordinal())) {
            return false;
        }
        for (Integer index : columnOrder) {
            if (index != null && index >= 0 && index < columnCount) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static VcsLogColumn fromOrdinal(int index) {
        VcsLogColumn vcsLogColumn = COLUMNS[index];
        if (vcsLogColumn == null) {
            VcsLogColumn.$$$reportNull$$$0(6);
        }
        return vcsLogColumn;
    }

    public static int count() {
        return COLUMNS.length;
    }

    static {
        DYNAMIC_COLUMNS = ContainerUtil.immutableList((Object[])new VcsLogColumn[]{AUTHOR, DATE, HASH});
        COLUMNS = VcsLogColumn.values();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/table/VcsLogColumn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogColumn";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStableName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromOrdinal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidColumnOrder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

