/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader;

import com.intellij.internal.statistic.StatisticsStringUtil;
import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.DataCollectorSystemEventLogger;
import com.intellij.internal.statistic.eventLog.DeviceConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfig;
import com.intellij.internal.statistic.eventLog.EventLogSendListener;
import com.intellij.internal.statistic.eventLog.EventLogStatisticsService;
import com.intellij.internal.statistic.eventLog.config.EventLogExternalApplicationInfo;
import com.intellij.internal.statistic.eventLog.config.EventLogExternalRecorderConfig;
import com.intellij.internal.statistic.uploader.EventLogUploaderCliParser;
import com.intellij.internal.statistic.uploader.ExternalDataCollectorLogger;
import com.intellij.internal.statistic.uploader.events.ExternalEventsLogger;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventLogUploader {
    private static final int WAIT_FOR_IDE_MS = 2000;

    public static void main(String[] args) {
        EventLogUploader.execute(args);
    }

    private static void execute(String[] args) {
        final ExternalEventsLogger eventsLogger = new ExternalEventsLogger();
        ExternalDataCollectorLogger logger = new ExternalDataCollectorLogger();
        logger.info("Process started with '" + String.join((CharSequence)" ", args) + "'");
        eventsLogger.logSendingLogsStarted();
        if (args.length == 0) {
            logger.warn("No arguments were found");
            eventsLogger.logSendingLogsFinished("NO_ARGUMENTS");
            return;
        }
        Map<String, String> options = EventLogUploaderCliParser.parseOptions(args);
        DeviceConfiguration device = EventLogUploader.newDeviceConfig(options);
        if (device == null) {
            logger.warn("Failed creating device config from arguments");
            eventsLogger.logSendingLogsFinished("NO_DEVICE_CONFIG");
            return;
        }
        EventLogRecorderConfig recorder = EventLogUploader.newRecorderConfig(options);
        if (recorder == null) {
            logger.warn("Failed creating recorder config from arguments");
            eventsLogger.logSendingLogsFinished("NO_RECORDER_CONFIG");
            return;
        }
        EventLogApplicationInfo appInfo = EventLogUploader.newApplicationInfo(options, logger, eventsLogger);
        if (appInfo == null) {
            logger.warn("Failed creating application info from arguments");
            eventsLogger.logSendingLogsFinished("NO_APPLICATION_CONFIG");
            return;
        }
        if (!EventLogUploader.waitForIde(logger, options, 20)) {
            logger.warn("Cannot send logs because IDE didn't close during 40000ms");
            eventsLogger.logSendingLogsFinished("IDE_NOT_CLOSING");
            return;
        }
        logger.info("Start uploading...");
        logger.info("{url:" + appInfo.getTemplateUrl() + ", product:" + appInfo.getProductCode() + ", userAgent:" + appInfo.getUserAgent() + ", internal:" + appInfo.isInternal() + ", isTest:" + appInfo.isTest() + "}");
        String logs = recorder.getLogFilesProvider().getLogFiles().stream().map(file -> file.getFile().getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
        logger.info("{recorder:" + recorder.getRecorderId() + ", files:" + logs + "}");
        logger.info("{device:" + device.getDeviceId() + ", bucket:" + device.getBucket() + "}");
        try {
            EventLogStatisticsService service = new EventLogStatisticsService(device, recorder, appInfo, new EventLogSendListener(){

                @Override
                public void onLogsSend(@NotNull List<String> successfullySentFiles, int failed, int totalLocalFiles) {
                    if (successfullySentFiles == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    eventsLogger.logSendingLogsSucceed(successfullySentFiles, failed, totalLocalFiles);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfullySentFiles", "com/intellij/internal/statistic/uploader/EventLogUploader$1", "onLogsSend"));
                }
            });
            StatisticsResult result = service.send();
            eventsLogger.logSendingLogsFinished(result.getCode());
            if (logger.isTraceEnabled()) {
                logger.trace("Uploading finished with " + result.getCode().name());
                logger.trace(result.getDescription());
            }
        }
        catch (Exception e) {
            logger.warn("Failed sending files: " + e.getMessage());
            eventsLogger.logSendingLogsFinished("ERROR_ON_SEND");
        }
    }

    @Nullable
    private static DeviceConfiguration newDeviceConfig(Map<String, String> options) {
        try {
            int bucketInt;
            String bucketOption = options.get("--bucket");
            String deviceOption = options.get("--device");
            int n = bucketInt = bucketOption != null ? Integer.parseInt(bucketOption) : -1;
            if (deviceOption != null && bucketInt >= 0 && bucketInt < 256) {
                return new DeviceConfiguration(deviceOption, bucketInt);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static EventLogRecorderConfig newRecorderConfig(Map<String, String> options) {
        String logs;
        String recorder = options.get("--recorder");
        if (recorder != null && (logs = options.get("--files")) != null) {
            List files2 = StatisticsStringUtil.split((String)logs, (char)File.pathSeparatorChar);
            return new EventLogExternalRecorderConfig(recorder, files2);
        }
        return null;
    }

    @Nullable
    private static EventLogApplicationInfo newApplicationInfo(Map<String, String> options, DataCollectorDebugLogger logger, DataCollectorSystemEventLogger eventLogger) {
        String url = options.get("--url");
        String productCode = options.get("--product");
        String productVersion = options.get("--product-version");
        String userAgent = options.get("--user-agent");
        if (url != null && productCode != null) {
            boolean isInternal = options.containsKey("--internal");
            boolean isTest = options.containsKey("--test");
            boolean isEAP = options.containsKey("--eap");
            return new EventLogExternalApplicationInfo(url, productCode, productVersion, userAgent, isInternal, isTest, isEAP, logger, eventLogger);
        }
        return null;
    }

    private static boolean waitForIde(DataCollectorDebugLogger logger, Map<String, String> options, int maxAttempts) {
        String ideToken = options.get("--ide-token");
        if (ideToken == null) {
            return true;
        }
        logger.info("IDE token file: " + ideToken);
        File token = new File(ideToken);
        try {
            for (int attempt = 0; attempt < maxAttempts && token.exists(); ++attempt) {
                logger.info("Waiting for 2000ms for IDE to close. Attempt #" + attempt);
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !token.exists();
    }
}

