/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.whitelist;

import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogSystemLogger;
import com.intellij.internal.statistic.eventLog.validator.persistence.EventLogWhitelistPersistence;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.whitelist.BaseWhitelistStorage;
import com.intellij.internal.statistic.eventLog.whitelist.EventLogMetadataLoader;
import com.intellij.internal.statistic.eventLog.whitelist.EventLogServerWhitelistLoader;
import com.intellij.internal.statistic.service.fus.EventLogMetadataLoadException;
import com.intellij.internal.statistic.service.fus.EventLogMetadataParseException;
import com.intellij.internal.statistic.service.fus.EventLogMetadataUpdateError;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhitelistStorage
extends BaseWhitelistStorage {
    private static final Logger LOG = Logger.getInstance(WhitelistStorage.class);
    protected final ConcurrentMap<String, EventGroupRules> eventsValidators;
    @NotNull
    private final Semaphore mySemaphore;
    @NotNull
    private final String myRecorderId;
    @Nullable
    private String myVersion;
    @NotNull
    private final EventLogWhitelistPersistence myWhitelistPersistence;
    @NotNull
    private final EventLogMetadataLoader myWhitelistLoader;

    WhitelistStorage(@NotNull String recorderId) {
        if (recorderId == null) {
            WhitelistStorage.$$$reportNull$$$0(0);
        }
        this.eventsValidators = new ConcurrentHashMap<String, EventGroupRules>();
        this.myRecorderId = recorderId;
        this.mySemaphore = new Semaphore();
        this.myWhitelistPersistence = new EventLogWhitelistPersistence(recorderId);
        this.myWhitelistLoader = new EventLogServerWhitelistLoader(recorderId);
        this.myVersion = this.loadValidatorsFromLocalCache(recorderId);
    }

    protected WhitelistStorage(@NotNull String recorderId, @NotNull EventLogWhitelistPersistence persistence, @NotNull EventLogMetadataLoader loader) {
        if (recorderId == null) {
            WhitelistStorage.$$$reportNull$$$0(1);
        }
        if (persistence == null) {
            WhitelistStorage.$$$reportNull$$$0(2);
        }
        if (loader == null) {
            WhitelistStorage.$$$reportNull$$$0(3);
        }
        this.eventsValidators = new ConcurrentHashMap<String, EventGroupRules>();
        this.myRecorderId = recorderId;
        this.mySemaphore = new Semaphore();
        this.myWhitelistPersistence = persistence;
        this.myWhitelistLoader = loader;
        this.myVersion = this.loadValidatorsFromLocalCache(recorderId);
    }

    @Override
    @Nullable
    public EventGroupRules getGroupRules(@NotNull String groupId) {
        if (groupId == null) {
            WhitelistStorage.$$$reportNull$$$0(4);
        }
        return (EventGroupRules)this.eventsValidators.get(groupId);
    }

    @Nullable
    private String loadValidatorsFromLocalCache(@NotNull String recorderId) {
        String whiteListContent;
        if (recorderId == null) {
            WhitelistStorage.$$$reportNull$$$0(5);
        }
        if ((whiteListContent = this.myWhitelistPersistence.getCachedMetadata()) != null) {
            try {
                String newVersion = this.updateValidators(whiteListContent);
                EventLogSystemLogger.logMetadataLoad(recorderId, newVersion);
                return newVersion;
            }
            catch (EventLogMetadataParseException e) {
                EventLogSystemLogger.logMetadataErrorOnLoad(this.myRecorderId, (EventLogMetadataUpdateError)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String updateValidators(@NotNull String whiteListContent) throws EventLogMetadataParseException {
        if (whiteListContent == null) {
            WhitelistStorage.$$$reportNull$$$0(6);
        }
        this.mySemaphore.down();
        try {
            FUStatisticsWhiteListGroupsService.WLGroups groups = FUStatisticsWhiteListGroupsService.parseWhiteListContent((String)whiteListContent);
            EventLogBuild build2 = EventLogBuild.fromString((String)EventLogConfiguration.INSTANCE.getBuild());
            Map<String, EventGroupRules> result = this.createValidators(build2, groups);
            this.isWhiteListInitialized.set(false);
            this.eventsValidators.clear();
            this.eventsValidators.putAll(result);
            this.isWhiteListInitialized.set(true);
            String string = groups.version;
            return string;
        }
        finally {
            this.mySemaphore.up();
        }
    }

    @Override
    public void update() {
        long lastModifiedLocally = this.myWhitelistPersistence.getLastModified();
        long lastModifiedOnServer = this.myWhitelistLoader.getLastModifiedOnServer();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loading whitelist, last modified cached=" + lastModifiedLocally + ", last modified on the server=" + lastModifiedOnServer);
        }
        try {
            if (lastModifiedOnServer <= 0L || lastModifiedOnServer > lastModifiedLocally || this.isUnreachableWhitelist()) {
                String whitelistFromServer = this.myWhitelistLoader.loadMetadataFromServer();
                String version = this.updateValidators(whitelistFromServer);
                this.myWhitelistPersistence.cacheWhiteList(whitelistFromServer, lastModifiedOnServer);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Update local whitelist, last modified cached=" + this.myWhitelistPersistence.getLastModified());
                }
                if (version != null && !StringUtil.equals((CharSequence)version, (CharSequence)this.myVersion)) {
                    this.myVersion = version;
                    EventLogSystemLogger.logMetadataUpdated(this.myRecorderId, this.myVersion);
                }
            }
        }
        catch (EventLogMetadataLoadException | EventLogMetadataParseException e) {
            EventLogSystemLogger.logMetadataErrorOnUpdate(this.myRecorderId, (EventLogMetadataUpdateError)e);
        }
    }

    @Override
    public void reload() {
        this.myVersion = this.loadValidatorsFromLocalCache(this.myRecorderId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistence";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteListContent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/eventLog/whitelist/WhitelistStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupRules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loadValidatorsFromLocalCache";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateValidators";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

