/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Calendar;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationInfo {
    public static ApplicationInfo getInstance() {
        return (ApplicationInfo)ApplicationManager.getApplication().getService(ApplicationInfo.class);
    }

    public abstract Calendar getBuildDate();

    @NotNull
    public abstract BuildNumber getBuild();

    @NotNull
    public abstract String getApiVersion();

    public abstract String getMajorVersion();

    public abstract String getMinorVersion();

    public abstract String getMicroVersion();

    public abstract String getPatchVersion();

    public abstract String getVersionName();

    public final String getMinorVersionMainPart() {
        String value = StringUtil.substringBefore((String)this.getMinorVersion(), (String)".");
        return value == null ? this.getMinorVersion() : value;
    }

    public abstract String getCompanyName();

    public abstract String getShortCompanyName();

    public abstract String getCompanyURL();

    public abstract String getJetBrainsTvUrl();

    public abstract String getEvalLicenseUrl();

    public abstract String getKeyConversionUrl();

    @Nullable
    public abstract int[] getAboutLogoRect();

    public abstract boolean hasHelp();

    public abstract boolean hasContextHelp();

    @NotNull
    public abstract String getFullVersion();

    @NotNull
    public abstract String getStrictVersion();

    public static boolean helpAvailable() {
        return ApplicationManager.getApplication() != null && ApplicationInfo.getInstance() != null && ApplicationInfo.getInstance().hasHelp();
    }

    public static boolean contextHelpAvailable() {
        return ApplicationManager.getApplication() != null && ApplicationInfo.getInstance() != null && ApplicationInfo.getInstance().hasContextHelp();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public String getBuildNumber() {
        return this.getBuild().asString();
    }

    public abstract String getFullApplicationName();
}

