/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogBuilder
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DialogBuilder.class);
    @NonNls
    public static final String REQUEST_FOCUS_ENABLED = "requestFocusEnabled";
    private JComponent myCenterPanel;
    private JComponent myNorthPanel;
    private String myTitle;
    private JComponent myPreferedFocusComponent;
    private String myDimensionServiceKey;
    private ArrayList<ActionDescriptor> myActions = null;
    private final MyDialogWrapper myDialogWrapper;
    private Runnable myCancelOperation = null;
    private Runnable myOkOperation = null;

    public int show() {
        return this.showImpl(true).getExitCode();
    }

    public boolean showAndGet() {
        return this.showImpl(true).isOK();
    }

    public void showNotModal() {
        this.showImpl(false);
    }

    public DialogBuilder(@Nullable Project project) {
        this.myDialogWrapper = new MyDialogWrapper(project, true);
        Disposer.register((Disposable)this.myDialogWrapper.getDisposable(), (Disposable)this);
    }

    public DialogBuilder(@Nullable Component parent) {
        this.myDialogWrapper = new MyDialogWrapper(parent, true);
        Disposer.register((Disposable)this.myDialogWrapper.getDisposable(), (Disposable)this);
    }

    public DialogBuilder() {
        this((Project)null);
    }

    public void dispose() {
    }

    private MyDialogWrapper showImpl(boolean isModal) {
        this.myDialogWrapper.setTitle(this.myTitle);
        this.myDialogWrapper.init();
        this.myDialogWrapper.setModal(isModal);
        this.myDialogWrapper.show();
        if (isModal) {
            this.myDialogWrapper.dispose();
        }
        return this.myDialogWrapper;
    }

    public void setCenterPanel(JComponent centerPanel) {
        this.myCenterPanel = centerPanel;
    }

    @NotNull
    public DialogBuilder centerPanel(@NotNull JComponent centerPanel) {
        if (centerPanel == null) {
            DialogBuilder.$$$reportNull$$$0(0);
        }
        this.myCenterPanel = centerPanel;
        DialogBuilder dialogBuilder = this;
        if (dialogBuilder == null) {
            DialogBuilder.$$$reportNull$$$0(1);
        }
        return dialogBuilder;
    }

    @NotNull
    public DialogBuilder setNorthPanel(@NotNull JComponent northPanel) {
        if (northPanel == null) {
            DialogBuilder.$$$reportNull$$$0(2);
        }
        this.myNorthPanel = northPanel;
        DialogBuilder dialogBuilder = this;
        if (dialogBuilder == null) {
            DialogBuilder.$$$reportNull$$$0(3);
        }
        return dialogBuilder;
    }

    public void setTitle(@NlsContexts.DialogTitle String title) {
        this.myTitle = title;
    }

    @NotNull
    public DialogBuilder title(@NotNull @NlsContexts.DialogTitle String title) {
        if (title == null) {
            DialogBuilder.$$$reportNull$$$0(4);
        }
        this.myTitle = title;
        DialogBuilder dialogBuilder = this;
        if (dialogBuilder == null) {
            DialogBuilder.$$$reportNull$$$0(5);
        }
        return dialogBuilder;
    }

    public void setPreferredFocusComponent(JComponent component) {
        this.myPreferedFocusComponent = component;
    }

    public void setDimensionServiceKey(@NonNls String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
    }

    public DialogBuilder dimensionKey(@NotNull String dimensionServiceKey) {
        if (dimensionServiceKey == null) {
            DialogBuilder.$$$reportNull$$$0(6);
        }
        this.myDimensionServiceKey = dimensionServiceKey;
        return this;
    }

    public void addAction(Action action) {
        this.addActionDescriptor(new CustomActionDescriptor(action));
    }

    public <T extends ActionDescriptor> T addActionDescriptor(T actionDescriptor) {
        this.getActionDescriptors().add(actionDescriptor);
        return actionDescriptor;
    }

    private ArrayList<ActionDescriptor> getActionDescriptors() {
        if (this.myActions == null) {
            this.removeAllActions();
        }
        return this.myActions;
    }

    public void setActionDescriptors(ActionDescriptor ... descriptors) {
        this.removeAllActions();
        ContainerUtil.addAll(this.myActions, (Object[])descriptors);
    }

    public void removeAllActions() {
        this.myActions = new ArrayList();
    }

    public Window getWindow() {
        return this.myDialogWrapper.getWindow();
    }

    public CustomizableAction addOkAction() {
        return this.addActionDescriptor(new OkActionDescriptor());
    }

    public CustomizableAction addCancelAction() {
        return this.addActionDescriptor(new CancelActionDescriptor());
    }

    public CustomizableAction addCloseButton() {
        CustomizableAction closeAction = this.addOkAction();
        closeAction.setText(CommonBundle.getCloseButtonText());
        return closeAction;
    }

    public void addDisposable(@NotNull Disposable disposable) {
        if (disposable == null) {
            DialogBuilder.$$$reportNull$$$0(7);
        }
        Disposer.register((Disposable)this, (Disposable)disposable);
    }

    public void setButtonsAlignment(int alignment) {
        this.myDialogWrapper.setButtonsAlignment(alignment);
    }

    public DialogWrapper getDialogWrapper() {
        return this.myDialogWrapper;
    }

    public void showModal(boolean modal) {
        if (modal) {
            this.show();
        } else {
            this.showNotModal();
        }
    }

    public void setHelpId(@NonNls String helpId) {
        this.myDialogWrapper.setHelpId(helpId);
    }

    public void setCancelOperation(Runnable runnable) {
        this.myCancelOperation = runnable;
    }

    public void setOkOperation(Runnable runnable) {
        this.myOkOperation = runnable;
    }

    public void setOkActionEnabled(boolean isEnabled) {
        this.myDialogWrapper.setOKActionEnabled(isEnabled);
    }

    @NotNull
    public DialogBuilder okActionEnabled(boolean isEnabled) {
        this.myDialogWrapper.setOKActionEnabled(isEnabled);
        DialogBuilder dialogBuilder = this;
        if (dialogBuilder == null) {
            DialogBuilder.$$$reportNull$$$0(8);
        }
        return dialogBuilder;
    }

    @NotNull
    public DialogBuilder resizable(boolean resizable) {
        this.myDialogWrapper.setResizable(resizable);
        DialogBuilder dialogBuilder = this;
        if (dialogBuilder == null) {
            DialogBuilder.$$$reportNull$$$0(9);
        }
        return dialogBuilder;
    }

    public CustomizableAction getOkAction() {
        return DialogBuilder.get(this.getActionDescriptors(), OkActionDescriptor.class);
    }

    private static CustomizableAction get(ArrayList<ActionDescriptor> actionDescriptors, Class aClass) {
        for (ActionDescriptor actionDescriptor : actionDescriptors) {
            if (!actionDescriptor.getClass().isAssignableFrom(aClass)) continue;
            return (CustomizableAction)((Object)actionDescriptor);
        }
        return null;
    }

    public CustomizableAction getCancelAction() {
        return DialogBuilder.get(this.getActionDescriptors(), CancelActionDescriptor.class);
    }

    public Component getCenterPanel() {
        return this.myCenterPanel;
    }

    public void setErrorText(@NlsContexts.DialogMessage @Nullable String text) {
        this.myDialogWrapper.setErrorText(text);
    }

    public void setErrorText(@NlsContexts.DialogMessage @Nullable String text, @Nullable JComponent component) {
        this.myDialogWrapper.setErrorText(text, component);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "centerPanel";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/DialogBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "northPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimensionServiceKey";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/DialogBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "centerPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setNorthPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "title";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "okActionEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resizable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "centerPanel";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setNorthPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "title";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dimensionKey";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDisposable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDialogWrapper
    extends DialogWrapper {
        private String myHelpId;

        private MyDialogWrapper(Project project, boolean canBeParent) {
            super(project, canBeParent);
            this.myHelpId = null;
        }

        private MyDialogWrapper(Component parent, boolean canBeParent) {
            super(parent, canBeParent);
            this.myHelpId = null;
        }

        public void setHelpId(String helpId) {
            this.myHelpId = helpId;
        }

        @Override
        @Nullable
        protected String getHelpId() {
            return this.myHelpId;
        }

        @Override
        public void init() {
            super.init();
        }

        @Override
        @NotNull
        public Action getOKAction() {
            Action action = super.getOKAction();
            if (action == null) {
                MyDialogWrapper.$$$reportNull$$$0(0);
            }
            return action;
        }

        @Override
        @NotNull
        public Action getCancelAction() {
            Action action = super.getCancelAction();
            if (action == null) {
                MyDialogWrapper.$$$reportNull$$$0(1);
            }
            return action;
        }

        @Override
        protected JComponent createCenterPanel() {
            return DialogBuilder.this.myCenterPanel;
        }

        @Override
        protected JComponent createNorthPanel() {
            return DialogBuilder.this.myNorthPanel;
        }

        @Override
        public void dispose() {
            DialogBuilder.this.myPreferedFocusComponent = null;
            super.dispose();
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            if (DialogBuilder.this.myPreferedFocusComponent != null) {
                return DialogBuilder.this.myPreferedFocusComponent;
            }
            FocusTraversalPolicy focusTraversalPolicy = null;
            for (Container container = DialogBuilder.this.myCenterPanel; container != null && (focusTraversalPolicy = container.getFocusTraversalPolicy()) == null && !(container instanceof Window); container = container.getParent()) {
            }
            if (focusTraversalPolicy == null) {
                return null;
            }
            Component component = focusTraversalPolicy.getDefaultComponent(DialogBuilder.this.myCenterPanel);
            while (!(component instanceof JComponent) && component != null) {
                component = focusTraversalPolicy.getComponentAfter(DialogBuilder.this.myCenterPanel, component);
            }
            return (JComponent)component;
        }

        @Override
        protected String getDimensionServiceKey() {
            return DialogBuilder.this.myDimensionServiceKey;
        }

        @Override
        protected JButton createJButtonForAction(Action action) {
            JButton button = super.createJButtonForAction(action);
            Object value = action.getValue(DialogBuilder.REQUEST_FOCUS_ENABLED);
            if (value instanceof Boolean) {
                button.setRequestFocusEnabled((Boolean)value);
            }
            return button;
        }

        @Override
        public void doCancelAction() {
            if (!this.getCancelAction().isEnabled()) {
                return;
            }
            if (DialogBuilder.this.myCancelOperation != null) {
                DialogBuilder.this.myCancelOperation.run();
            } else {
                super.doCancelAction();
            }
        }

        @Override
        protected void doOKAction() {
            if (DialogBuilder.this.myOkOperation != null) {
                DialogBuilder.this.myOkOperation.run();
            } else {
                super.doOKAction();
            }
        }

        @Override
        protected Action @NotNull [] createActions() {
            if (DialogBuilder.this.myActions == null) {
                Action[] actionArray = super.createActions();
                if (actionArray == null) {
                    MyDialogWrapper.$$$reportNull$$$0(2);
                }
                return actionArray;
            }
            ArrayList<Action> actions = new ArrayList<Action>(DialogBuilder.this.myActions.size());
            for (ActionDescriptor actionDescriptor : DialogBuilder.this.myActions) {
                actions.add(actionDescriptor.getAction(this));
            }
            if (this.myHelpId != null) {
                actions.add(this.getHelpAction());
            }
            Action[] actionArray = actions.toArray(new Action[0]);
            if (actionArray == null) {
                MyDialogWrapper.$$$reportNull$$$0(3);
            }
            return actionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/ui/DialogBuilder$MyDialogWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOKAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCancelAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class CancelActionDescriptor
    extends BuiltinAction {
        @Override
        protected Action getBuiltinAction(MyDialogWrapper dialogWrapper) {
            return dialogWrapper.getCancelAction();
        }
    }

    public static class OkActionDescriptor
    extends BuiltinAction {
        @Override
        protected Action getBuiltinAction(MyDialogWrapper dialogWrapper) {
            return dialogWrapper.getOKAction();
        }
    }

    private static abstract class BuiltinAction
    implements ActionDescriptor,
    CustomizableAction {
        protected String myText = null;

        private BuiltinAction() {
        }

        @Override
        public void setText(String text) {
            this.myText = text;
        }

        @Override
        public Action getAction(DialogWrapper dialogWrapper) {
            Action builtinAction = this.getBuiltinAction((MyDialogWrapper)dialogWrapper);
            if (this.myText != null) {
                builtinAction.putValue("Name", this.myText);
            }
            return builtinAction;
        }

        protected abstract Action getBuiltinAction(MyDialogWrapper var1);
    }

    public static class CustomActionDescriptor
    implements ActionDescriptor {
        private final Action myAction;

        public CustomActionDescriptor(Action action) {
            this.myAction = action;
        }

        @Override
        public Action getAction(DialogWrapper dialogWrapper) {
            return this.myAction;
        }
    }

    public static interface CustomizableAction {
        public void setText(String var1);
    }

    public static class CloseDialogAction
    extends DialogActionDescriptor {
        private final int myExitCode;

        public CloseDialogAction() {
            this(CommonBundle.getCloseButtonText(), -1, 1);
        }

        public CloseDialogAction(String name, int mnemonicChar, int exitCode) {
            super(name, mnemonicChar);
            this.myExitCode = exitCode;
        }

        public static CloseDialogAction createDefault(String name, int mnemonicChar, int exitCode) {
            CloseDialogAction closeDialogAction = new CloseDialogAction(name, mnemonicChar, exitCode);
            closeDialogAction.setDefault(true);
            return closeDialogAction;
        }

        @Override
        protected Action createAction(final DialogWrapper dialogWrapper) {
            return new AbstractAction(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    dialogWrapper.close(myExitCode);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/DialogBuilder$CloseDialogAction$1", "actionPerformed"));
                }
            };
        }
    }

    public static abstract class DialogActionDescriptor
    implements ActionDescriptor {
        private final String myName;
        private final Object myMnemonicChar;
        private boolean myIsDefault = false;

        protected DialogActionDescriptor(String name, int mnemonicChar) {
            this.myName = name;
            this.myMnemonicChar = mnemonicChar == -1 ? null : Integer.valueOf(mnemonicChar);
        }

        @Override
        public Action getAction(DialogWrapper dialogWrapper) {
            Action action = this.createAction(dialogWrapper);
            action.putValue("Name", this.myName);
            if (this.myMnemonicChar != null) {
                action.putValue("MnemonicKey", this.myMnemonicChar);
            }
            if (this.myIsDefault) {
                action.putValue("Default", Boolean.TRUE);
            }
            return action;
        }

        public void setDefault(boolean isDefault) {
            this.myIsDefault = isDefault;
        }

        protected abstract Action createAction(DialogWrapper var1);
    }

    public static interface ActionDescriptor {
        public Action getAction(DialogWrapper var1);
    }
}

