/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.SmartHashSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnActionButton
extends AnAction
implements ShortcutProvider {
    private boolean myEnabled;
    private boolean myVisible;
    private ShortcutSet myShortcut;
    private JComponent myContextComponent;
    private Set<AnActionButtonUpdater> myUpdaters;
    private final List<ActionButtonListener> myListeners;

    public AnActionButton(@NlsContexts.Button String text) {
        super(() -> text);
        this.myEnabled = true;
        this.myVisible = true;
        this.myListeners = new ArrayList<ActionButtonListener>();
    }

    public AnActionButton(@NotNull Supplier<String> dynamicText) {
        if (dynamicText == null) {
            AnActionButton.$$$reportNull$$$0(0);
        }
        super(dynamicText);
        this.myEnabled = true;
        this.myVisible = true;
        this.myListeners = new ArrayList<ActionButtonListener>();
    }

    public AnActionButton(@NlsContexts.Button String text, @NlsContexts.Tooltip String description, @Nullable Icon icon) {
        super(text, description, icon);
        this.myEnabled = true;
        this.myVisible = true;
        this.myListeners = new ArrayList<ActionButtonListener>();
    }

    public AnActionButton(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, @Nullable Icon icon) {
        if (dynamicText == null) {
            AnActionButton.$$$reportNull$$$0(1);
        }
        if (dynamicDescription == null) {
            AnActionButton.$$$reportNull$$$0(2);
        }
        super(dynamicText, dynamicDescription, icon);
        this.myEnabled = true;
        this.myVisible = true;
        this.myListeners = new ArrayList<ActionButtonListener>();
    }

    public AnActionButton(@NlsContexts.Button String text, Icon icon) {
        this(text, null, icon);
    }

    public AnActionButton(@NotNull Supplier<String> dynamicText, Icon icon) {
        if (dynamicText == null) {
            AnActionButton.$$$reportNull$$$0(3);
        }
        this(dynamicText, Presentation.NULL_STRING, icon);
    }

    public AnActionButton() {
        this.myEnabled = true;
        this.myVisible = true;
        this.myListeners = new ArrayList<ActionButtonListener>();
    }

    public static AnActionButton fromAction(AnAction action) {
        Presentation presentation = action.getTemplatePresentation();
        AnActionButtonWrapper button = action instanceof CheckedActionGroup ? new CheckedAnActionButton(presentation, action) : new AnActionButtonWrapper(presentation, action);
        button.setShortcut(action.getShortcutSet());
        return button;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.myEnabled != enabled) {
            this.myEnabled = enabled;
            this.myListeners.forEach(l -> l.isEnabledChanged(enabled));
        }
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible) {
        if (this.myVisible != visible) {
            this.myVisible = visible;
            this.myListeners.forEach(l -> l.isVisibleChanged(visible));
        }
    }

    @Override
    public final void update(@NotNull AnActionEvent e) {
        boolean enabled;
        if (e == null) {
            AnActionButton.$$$reportNull$$$0(4);
        }
        boolean bl = enabled = this.isEnabled() && this.isContextComponentOk();
        if (enabled && this.myUpdaters != null) {
            for (AnActionButtonUpdater updater : this.myUpdaters) {
                if (updater.isEnabled(e)) continue;
                enabled = false;
                break;
            }
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(this.isVisible());
        if (enabled) {
            this.updateButton(e);
        }
    }

    public final void addCustomUpdater(@NotNull AnActionButtonUpdater updater) {
        if (updater == null) {
            AnActionButton.$$$reportNull$$$0(5);
        }
        if (this.myUpdaters == null) {
            this.myUpdaters = new SmartHashSet();
        }
        this.myUpdaters.add(updater);
    }

    public void updateButton(@NotNull AnActionEvent e) {
        if (e == null) {
            AnActionButton.$$$reportNull$$$0(6);
        }
        JComponent component = this.getContextComponent();
        e.getPresentation().setEnabled(component != null && component.isShowing() && component.isEnabled());
    }

    @Override
    public ShortcutSet getShortcut() {
        return this.myShortcut;
    }

    public void setShortcut(ShortcutSet shortcut) {
        this.myShortcut = shortcut;
    }

    public void setContextComponent(JComponent contextComponent) {
        this.myContextComponent = contextComponent;
    }

    public JComponent getContextComponent() {
        return this.myContextComponent;
    }

    @NotNull
    public DataContext getDataContext() {
        DataContext dataContext = DataManager.getInstance().getDataContext(this.getContextComponent());
        if (dataContext == null) {
            AnActionButton.$$$reportNull$$$0(7);
        }
        return dataContext;
    }

    private boolean isContextComponentOk() {
        return this.myContextComponent == null || this.myContextComponent.isVisible() && ComponentUtil.getParentOfType(JLayeredPane.class, (Component)this.myContextComponent) != null;
    }

    @Nullable
    public final RelativePoint getPreferredPopupPoint() {
        Container c = this.myContextComponent;
        ActionToolbar toolbar = null;
        while (!((c = c.getParent()) == null || c instanceof JComponent && (toolbar = (ActionToolbar)((JComponent)c).getClientProperty("ACTION_TOOLBAR")) != null)) {
        }
        if (toolbar instanceof JComponent) {
            for (Component comp : ((JComponent)((Object)toolbar)).getComponents()) {
                if (!(comp instanceof ActionButtonComponent) || !(comp instanceof AnActionHolder) || ((AnActionHolder)((Object)comp)).getAction() != this) continue;
                return new RelativePoint((Component)comp.getParent(), new Point(comp.getX(), comp.getY() + comp.getHeight()));
            }
        }
        return null;
    }

    public void addActionButtonListener(ActionButtonListener l, Disposable parentDisposable) {
        this.myListeners.add(l);
        Disposer.register((Disposable)parentDisposable, () -> this.myListeners.remove(l));
    }

    public boolean removeActionButtonListener(ActionButtonListener l) {
        return this.myListeners.remove(l);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/AnActionButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/AnActionButton";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addCustomUpdater";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateButton";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ActionButtonListener {
        default public void isVisibleChanged(boolean newValue) {
        }

        default public void isEnabledChanged(boolean newValue) {
        }
    }

    public static class AnActionEventWrapper
    extends AnActionEvent {
        private final AnActionButton myPeer;

        private AnActionEventWrapper(AnActionEvent e, AnActionButton peer) {
            super(e.getInputEvent(), e.getDataContext(), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers());
            this.myPeer = peer;
        }

        public void showPopup(JBPopup popup) {
            popup.show(this.myPeer.getPreferredPopupPoint());
        }
    }

    public static class AnActionButtonWrapper
    extends AnActionButton
    implements ActionWithDelegate<AnAction> {
        private final AnAction myAction;

        public AnActionButtonWrapper(Presentation presentation, @NotNull AnAction action) {
            if (action == null) {
                AnActionButtonWrapper.$$$reportNull$$$0(0);
            }
            super(presentation.getText(), presentation.getDescription(), presentation.getIcon());
            this.myAction = action;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AnActionButtonWrapper.$$$reportNull$$$0(1);
            }
            this.myAction.actionPerformed(new AnActionEventWrapper(e, this));
        }

        @Override
        public void updateButton(@NotNull AnActionEvent e) {
            if (e == null) {
                AnActionButtonWrapper.$$$reportNull$$$0(2);
            }
            this.myAction.update(e);
            boolean enabled = e.getPresentation().isEnabled();
            boolean visible = e.getPresentation().isVisible();
            if (enabled && visible) {
                super.updateButton(e);
            }
        }

        @Override
        public boolean isDumbAware() {
            return this.myAction.isDumbAware();
        }

        @Override
        @NotNull
        public AnAction getDelegate() {
            AnAction anAction = this.myAction;
            if (anAction == null) {
                AnActionButtonWrapper.$$$reportNull$$$0(3);
            }
            return anAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/AnActionButton$AnActionButtonWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/AnActionButton$AnActionButtonWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updateButton";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CheckedAnActionButton
    extends AnActionButtonWrapper
    implements CheckedActionGroup {
        public CheckedAnActionButton(Presentation presentation, @NotNull AnAction action) {
            if (action == null) {
                CheckedAnActionButton.$$$reportNull$$$0(0);
            }
            super(presentation, action);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ui/AnActionButton$CheckedAnActionButton", "<init>"));
        }
    }
}

