/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import gnu.trove.TObjectIntHashMap;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListFocusTraversalPolicy
extends LayoutFocusTraversalPolicy {
    private final Component[] myComponents;
    private final TObjectIntHashMap<Component> myComponentToIndex;

    public ListFocusTraversalPolicy(@NotNull List<? extends Component> components) {
        if (components == null) {
            ListFocusTraversalPolicy.$$$reportNull$$$0(0);
        }
        this.myComponents = components.toArray(new Component[0]);
        this.myComponentToIndex = ListFocusTraversalPolicy.indexMap(this.myComponents);
    }

    @Override
    protected boolean accept(Component aComponent) {
        return super.accept(aComponent) && aComponent.isShowing();
    }

    @Override
    public Component getFirstComponent(Container aContainer) {
        return this.getNextComponent(0);
    }

    @Override
    public Component getLastComponent(Container aContainer) {
        return this.getPreviousComponent(this.myComponents.length - 1);
    }

    @Override
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        if (!this.myComponentToIndex.containsKey((Object)aComponent)) {
            return null;
        }
        return this.getNextComponent(this.myComponentToIndex.get((Object)aComponent) + 1);
    }

    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        if (!this.myComponentToIndex.containsKey((Object)aComponent)) {
            return null;
        }
        return this.getPreviousComponent(this.myComponentToIndex.get((Object)aComponent) - 1);
    }

    @Nullable
    private Component getNextComponent(int startIndex) {
        Component result;
        int index;
        for (index = startIndex; index < this.myComponents.length; ++index) {
            result = this.myComponents[index];
            if (!this.accept(result)) continue;
            return result;
        }
        for (index = 0; index < startIndex; ++index) {
            result = this.myComponents[index];
            if (!this.accept(result)) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private Component getPreviousComponent(int startIndex) {
        Component result;
        int index;
        for (index = startIndex; index >= 0; --index) {
            result = this.myComponents[index];
            if (!this.accept(result)) continue;
            return result;
        }
        for (index = this.myComponents.length - 1; index > startIndex; --index) {
            result = this.myComponents[index];
            if (!this.accept(result)) continue;
            return result;
        }
        return null;
    }

    @NotNull
    private static <X> TObjectIntHashMap<X> indexMap(X @NotNull [] array) {
        if (array == null) {
            ListFocusTraversalPolicy.$$$reportNull$$$0(1);
        }
        TObjectIntHashMap map = new TObjectIntHashMap(array.length);
        for (X x : array) {
            if (map.contains(x)) continue;
            map.put(x, map.size());
        }
        map.compact();
        TObjectIntHashMap tObjectIntHashMap = map;
        if (tObjectIntHashMap == null) {
            ListFocusTraversalPolicy.$$$reportNull$$$0(2);
        }
        return tObjectIntHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ListFocusTraversalPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ListFocusTraversalPolicy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "indexMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "indexMap";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

