/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.encoding;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingReference
implements PsiReference,
EmptyResolveMessageProvider {
    private final PsiElement myElement;
    private final String myCharsetName;
    private final TextRange myRangeInElement;

    public EncodingReference(PsiElement element2, String charsetName, TextRange rangeInElement) {
        this.myElement = element2;
        this.myCharsetName = charsetName;
        this.myRangeInElement = rangeInElement;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            EncodingReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRangeInElement;
        if (textRange == null) {
            EncodingReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        return CharsetToolkit.forName((String)this.myCharsetName) == null ? null : this.myElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myCharsetName;
        if (string == null) {
            EncodingReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            EncodingReference.$$$reportNull$$$0(3);
        }
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            EncodingReference.$$$reportNull$$$0(4);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element2) {
        if (element2 == null) {
            EncodingReference.$$$reportNull$$$0(5);
        }
        return false;
    }

    public Object @NotNull [] getVariants() {
        Charset[] charsets = CharsetToolkit.getAvailableCharsets();
        ArrayList<LookupElementBuilder> suggestions = new ArrayList<LookupElementBuilder>(charsets.length);
        for (Charset charset : charsets) {
            suggestions.add(LookupElementBuilder.create((String)charset.name()).withCaseSensitivity(false));
        }
        Object[] objectArray = suggestions.toArray(LookupElement.EMPTY_ARRAY);
        if (objectArray == null) {
            EncodingReference.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CodeInsightBundle.message((String)"unknown.encoding.0", (Object[])new Object[0]);
        if (string == null) {
            EncodingReference.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/encoding/EncodingReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/encoding/EncodingReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

