/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.Symbol;
import com.intellij.model.psi.impl.TargetsKt;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\r"}, d2={"highlightSymbolUsages", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "symbol", "Lcom/intellij/model/Symbol;", "clearHighlights", "", "highlightUsages", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class HighlightUsagesKt {
    public static final boolean highlightUsages(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        Collection<Symbol> allTargets = TargetsKt.targetSymbols(file2, caretModel.getOffset());
        if (allTargets.isEmpty()) {
            return false;
        }
        boolean clearHighlights = HighlightUsagesHandler.isClearHighlights(editor);
        for (Symbol symbol : allTargets) {
            HighlightUsagesKt.highlightSymbolUsages(project, editor, file2, symbol, clearHighlights);
        }
        return true;
    }

    private static final void highlightSymbolUsages(Project project, Editor editor, PsiFile file2, Symbol symbol, boolean clearHighlights) {
        EditorWindow editorWindow;
        PsiCompiledFile psiCompiledFile;
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        PsiFile psiFile = file2;
        if (!(psiFile instanceof PsiCompiledFile)) {
            psiFile = null;
        }
        PsiFile fileToUse = injectedLanguageManager.getTopLevelFile((psiCompiledFile = (PsiCompiledFile)psiFile) != null && (psiCompiledFile = psiCompiledFile.getDecompiledPsiFile()) != null ? (PsiElement)psiCompiledFile : (PsiElement)file2);
        Editor editor2 = editor;
        if (!(editor2 instanceof EditorWindow)) {
            editor2 = null;
        }
        if ((editorWindow = (EditorWindow)editor2) == null || (editorWindow = editorWindow.getDelegate()) == null) {
            editorWindow = editor;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)editorWindow, (String)"(editor as? EditorWindow)?.delegate ?: editor");
        EditorWindow editorToUse = editorWindow;
        Couple<List<TextRange>> couple = IdentifierHighlighterPass.getUsages(fileToUse, symbol);
        Intrinsics.checkExpressionValueIsNotNull(couple, (String)"IdentifierHighlighterPas\u2026Usages(fileToUse, symbol)");
        Couple<List<TextRange>> usages = couple;
        HighlightUsagesHandler.highlightUsages(project, editorToUse, usages, clearHighlights);
    }
}

