/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.navigation.CtrlMouseHandler;
import com.intellij.codeInsight.navigation.CtrlMouseInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class BaseCtrlMouseInfo
implements CtrlMouseInfo {
    @NotNull
    private final @NotNull List<@NotNull TextRange> myRanges;

    protected BaseCtrlMouseInfo(@NotNull @NotNull List<@NotNull TextRange> ranges) {
        if (ranges == null) {
            BaseCtrlMouseInfo.$$$reportNull$$$0(0);
        }
        this.myRanges = ranges;
    }

    protected BaseCtrlMouseInfo(@NotNull PsiElement elementAtPointer) {
        if (elementAtPointer == null) {
            BaseCtrlMouseInfo.$$$reportNull$$$0(1);
        }
        this(BaseCtrlMouseInfo.getReferenceRanges(elementAtPointer));
    }

    @NotNull
    private static List<TextRange> getReferenceRanges(@NotNull PsiElement elementAtPointer) {
        if (elementAtPointer == null) {
            BaseCtrlMouseInfo.$$$reportNull$$$0(2);
        }
        if (!elementAtPointer.isPhysical()) {
            List<TextRange> list2 = Collections.emptyList();
            if (list2 == null) {
                BaseCtrlMouseInfo.$$$reportNull$$$0(3);
            }
            return list2;
        }
        int textOffset = elementAtPointer.getTextOffset();
        TextRange range2 = elementAtPointer.getTextRange();
        if (range2 == null) {
            throw new AssertionError((Object)("Null range for " + elementAtPointer + " of " + elementAtPointer.getClass()));
        }
        if (textOffset < range2.getStartOffset() || textOffset < 0) {
            CtrlMouseHandler.LOG.error("Invalid text offset " + textOffset + " of element " + elementAtPointer + " of " + elementAtPointer.getClass());
            textOffset = range2.getStartOffset();
        }
        List<TextRange> list3 = Collections.singletonList(new TextRange(textOffset, range2.getEndOffset()));
        if (list3 == null) {
            BaseCtrlMouseInfo.$$$reportNull$$$0(4);
        }
        return list3;
    }

    @Override
    @NotNull
    public final @NotNull List<@NotNull TextRange> getRanges() {
        List<TextRange> list2 = this.myRanges;
        if (list2 == null) {
            BaseCtrlMouseInfo.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAtPointer";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/BaseCtrlMouseInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/BaseCtrlMouseInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceRanges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceRanges";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

