/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"writeContentEntry", "", "contentEntry", "Lcom/intellij/openapi/roots/ContentEntry;", "writer", "Lcom/google/gson/stream/JsonWriter;", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "writeModuleDescription", "module", "Lcom/intellij/openapi/module/Module;", "writeOrderEntry", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "writeProjectDescription", "project", "Lcom/intellij/openapi/project/Project;", "path", "Ljava/nio/file/Path;", "type", "", "Lcom/intellij/openapi/roots/SourceFolder;", "intellij.platform.analysis.impl"})
public final class ProjectDescriptionUtilKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeProjectDescription(@NotNull Path path, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
        BufferedWriter writer = Files.newBufferedWriter(path, CharsetToolkit.UTF8_CHARSET, new OpenOption[0]);
        Closeable closeable = writer;
        boolean bl = false;
        Throwable throwable = null;
        try {
            JsonWriter jsonWriter;
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl2 = false;
            JsonWriter jsonWriter2 = jsonWriter = gson2.newJsonWriter((Writer)writer);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter2, (String)"jsonWriter");
            ProjectDescriptionUtilKt.writeProjectDescription(project, jsonWriter2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void writeProjectDescription(Project project, JsonWriter writer) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] modules2 = moduleManager.getModules();
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)pathMacroManager, (String)"PathMacroManager.getInstance(project)");
        PathMacroManager macroManager = pathMacroManager;
        writer.beginObject();
        writer.name("modules");
        writer.beginArray();
        Module[] moduleArray = modules2;
        int n = moduleArray.length;
        for (int j = 0; j < n; ++j) {
            Module module;
            Module module2 = module = moduleArray[j];
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            ProjectDescriptionUtilKt.writeModuleDescription(module2, writer, macroManager);
        }
        writer.endArray();
        writer.endObject();
    }

    private static final void writeModuleDescription(Module module, JsonWriter writer, PathMacroManager macroManager) {
        int n;
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        writer.beginObject();
        writer.name("Name").value(module.getName());
        writer.name("ContentEntries").beginArray();
        ModuleRootManager moduleRootManager = rootManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"rootManager");
        ContentEntry[] contentEntryArray = moduleRootManager.getContentEntries();
        int n2 = contentEntryArray.length;
        for (n = 0; n < n2; ++n) {
            ContentEntry contentEntry;
            ContentEntry contentEntry2 = contentEntry = contentEntryArray[n];
            Intrinsics.checkExpressionValueIsNotNull((Object)contentEntry2, (String)"contentEntry");
            ProjectDescriptionUtilKt.writeContentEntry(contentEntry2, writer, macroManager);
        }
        writer.endArray();
        writer.name("OrderEntries").beginArray();
        contentEntryArray = rootManager.getOrderEntries();
        n2 = contentEntryArray.length;
        for (n = 0; n < n2; ++n) {
            ContentEntry orderEntry;
            ContentEntry contentEntry = orderEntry = contentEntryArray[n];
            Intrinsics.checkExpressionValueIsNotNull((Object)contentEntry, (String)"orderEntry");
            ProjectDescriptionUtilKt.writeOrderEntry((OrderEntry)contentEntry, writer, macroManager);
        }
        writer.endArray();
        writer.endObject();
    }

    private static final void writeContentEntry(ContentEntry contentEntry, JsonWriter writer, PathMacroManager macroManager) {
        writer.beginObject();
        writer.name("Path").value(macroManager.collapsePath(contentEntry.getUrl()));
        writer.name("SourceFolders").beginArray();
        for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
            writer.beginObject();
            JsonWriter jsonWriter = writer.name("Path");
            SourceFolder sourceFolder2 = sourceFolder;
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceFolder2, (String)"sourceFolder");
            jsonWriter.value(macroManager.collapsePath(sourceFolder2.getUrl()));
            writer.name("Type").value(ProjectDescriptionUtilKt.type(sourceFolder));
            writer.endObject();
        }
        for (SourceFolder sourceFolder : contentEntry.getExcludeFolders()) {
            writer.beginObject();
            JsonWriter jsonWriter = writer.name("Path");
            SourceFolder sourceFolder3 = sourceFolder;
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceFolder3, (String)"excludeFolder");
            jsonWriter.value(macroManager.collapsePath(sourceFolder3.getUrl()));
            writer.name("Type").value("Exclude");
            writer.endObject();
        }
        writer.endArray();
        writer.endObject();
    }

    private static final void writeOrderEntry(OrderEntry orderEntry, JsonWriter writer, PathMacroManager macroManager) {
        writer.beginObject();
        writer.name("Name").value(orderEntry.getPresentableName());
        writer.name("Roots").beginArray();
        for (String root : orderEntry.getUrls(OrderRootType.CLASSES)) {
            writer.beginObject();
            writer.name("Path").value(macroManager.collapsePath(root));
            writer.endObject();
        }
        writer.endArray();
        writer.endObject();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String type(@NotNull SourceFolder $this$type) {
        JpsModuleSourceRootType jpsModuleSourceRootType = $this$type.getRootType();
        if (Intrinsics.areEqual((Object)jpsModuleSourceRootType, (Object)JavaResourceRootType.RESOURCE)) {
            return "Resource";
        }
        if (Intrinsics.areEqual((Object)jpsModuleSourceRootType, (Object)JavaResourceRootType.TEST_RESOURCE)) {
            return "TestResource";
        }
        if (Intrinsics.areEqual((Object)jpsModuleSourceRootType, (Object)JavaSourceRootType.TEST_SOURCE)) {
            return "TestSource";
        }
        if (!Intrinsics.areEqual((Object)jpsModuleSourceRootType, (Object)JavaSourceRootType.SOURCE)) return "Source";
        JavaSourceRootProperties javaSourceRootProperties = (JavaSourceRootProperties)$this$type.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
        if (javaSourceRootProperties == null) return "Source";
        if (!javaSourceRootProperties.isForGeneratedSources()) return "Source";
        return "GeneratedSource";
    }
}

