/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultiFilesSettings {
    private SettingsXmlFile myProjectFile;
    private final List<SettingsXmlFile> mySettingsFiles;

    protected MultiFilesSettings(@Nullable Path projectFile, File @Nullable [] settingsFiles, @NotNull ConversionContextImpl context) throws CannotConvertException {
        if (context == null) {
            MultiFilesSettings.$$$reportNull$$$0(0);
        }
        if (projectFile == null && settingsFiles == null) {
            throw new IllegalArgumentException("Either project file or settings files should be not null");
        }
        if (projectFile != null && Files.exists(projectFile, new LinkOption[0])) {
            this.myProjectFile = context.getOrCreateFile(projectFile);
        }
        this.mySettingsFiles = new ArrayList<SettingsXmlFile>();
        if (settingsFiles != null) {
            for (File file2 : settingsFiles) {
                this.mySettingsFiles.add(context.getOrCreateFile(file2.toPath()));
            }
        }
    }

    @NotNull
    protected Collection<? extends Element> getSettings(@NotNull String componentName, @NotNull String tagName) {
        if (componentName == null) {
            MultiFilesSettings.$$$reportNull$$$0(1);
        }
        if (tagName == null) {
            MultiFilesSettings.$$$reportNull$$$0(2);
        }
        ArrayList result2 = new ArrayList();
        if (this.myProjectFile != null) {
            result2.addAll(JDOMUtil.getChildren((Element)this.myProjectFile.findComponent(componentName), (String)tagName));
        }
        for (SettingsXmlFile file2 : this.mySettingsFiles) {
            result2.addAll(JDOMUtil.getChildren((Element)file2.getRootElement(), (String)tagName));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            MultiFilesSettings.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public Collection<Path> getAffectedFiles() {
        ArrayList<Path> files2 = new ArrayList<Path>();
        if (this.myProjectFile != null) {
            files2.add(this.myProjectFile.getFile());
        }
        for (SettingsXmlFile file2 : this.mySettingsFiles) {
            files2.add(file2.getFile());
        }
        return files2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/MultiFilesSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/MultiFilesSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

