/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContentImpl;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentBase;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.contents.FileDocumentContentImpl;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.vcs.DiffVcsFacade;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.LightColors;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffContentFactoryImpl
extends DiffContentFactoryEx {
    private static final Logger LOG = Logger.getInstance(DiffContentFactoryImpl.class);

    @NotNull
    public EmptyContent createEmpty() {
        return new EmptyContent();
    }

    @NotNull
    public DocumentContent create(@NotNull String text) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(0);
        }
        DocumentContent documentContent = this.create(null, text);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(1);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(2);
        }
        DocumentContent documentContent = this.create(null, text, type);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(3);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type, boolean respectLineSeparators) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(4);
        }
        DocumentContent documentContent = this.create(null, text, type, respectLineSeparators);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(5);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable VirtualFile highlightFile) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(6);
        }
        DocumentContent documentContent = this.create(null, text, highlightFile);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(7);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable DocumentContent referent) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(8);
        }
        DocumentContent documentContent = this.create(null, text, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(9);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(10);
        }
        DocumentContent documentContent = this.create(project, text, (FileType)null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(11);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable FileType type) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(12);
        }
        DocumentContent documentContent = this.create(project, text, type, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(13);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable FileType type, boolean respectLineSeparators) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(14);
        }
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByFileType(type).buildFromText(text, respectLineSeparators);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(15);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @NotNull FilePath filePath) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(16);
        }
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(17);
        }
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByFilePath(filePath).buildFromText(text, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(18);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable VirtualFile highlightFile) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(19);
        }
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByHighlightFile(highlightFile).buildFromText(text, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(20);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable DocumentContent referent) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(21);
        }
        if (referent == null) {
            DocumentContent documentContent = this.create(text);
            if (documentContent == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(22);
            }
            return documentContent;
        }
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByReferent(referent).buildFromText(text, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(23);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createEditable(@Nullable Project project, @NotNull String text, @Nullable FileType fileType) {
        if (text == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(24);
        }
        DocumentContent documentContent = this.documentContent(project, false).contextByFileType(fileType).buildFromText(text, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(25);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull Document document, @Nullable DocumentContent referent) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(26);
        }
        DocumentContent documentContent = this.create(null, document, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(27);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(28);
        }
        DocumentContent documentContent = this.create(project, document, (FileType)null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(29);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable FileType fileType) {
        VirtualFile file2;
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(30);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) != null) {
            return new FileDocumentContentImpl(project, document, file2);
        }
        return new DocumentContentImpl(project, document, fileType);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable VirtualFile highlightFile) {
        VirtualFile file2;
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(31);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) != null && file2.equals(highlightFile)) {
            return new FileDocumentContentImpl(project, document, file2);
        }
        if (highlightFile == null) {
            return new DocumentContentImpl(document);
        }
        return new FileReferentDocumentContent(project, document, highlightFile);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable DocumentContent referent) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(32);
        }
        if (referent == null) {
            return new DocumentContentImpl(document);
        }
        return new ContentReferentDocumentContent(project, document, referent);
    }

    @NotNull
    public DiffContent create(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(33);
        }
        return DiffContentFactoryImpl.createContentFromFile(project, file2);
    }

    @Nullable
    public DocumentContent createDocument(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(34);
        }
        return (DocumentContent)ObjectUtils.tryCast((Object)DiffContentFactoryImpl.createContentFromFile(project, file2), DocumentContent.class);
    }

    @Nullable
    public FileContent createFile(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(35);
        }
        if (file2.isDirectory()) {
            return null;
        }
        return (FileContent)this.create(project, file2);
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project, @NotNull Document document, @NotNull TextRange range2) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(36);
        }
        if (range2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(37);
        }
        DocumentContent content2 = this.create(project, document);
        DocumentContent documentContent = this.createFragment(project, content2, range2);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(38);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project, @NotNull DocumentContent content2, @NotNull TextRange range2) {
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(39);
        }
        if (range2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(40);
        }
        return new DocumentFragmentContent(project, content2, range2);
    }

    @NotNull
    public DiffContent createClipboardContent() {
        DocumentContent documentContent = this.createClipboardContent(null, null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(41);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable DocumentContent referent) {
        DocumentContent documentContent = this.createClipboardContent(null, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(42);
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createClipboardContent(@Nullable Project project) {
        DocumentContent documentContent = this.createClipboardContent(project, null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(43);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable Project project, @Nullable DocumentContent referent) {
        String text = StringUtil.notNullize((String)((String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)));
        DocumentContent documentContent = this.documentContent(project, false).contextByReferent(referent).withFileName("Clipboard.txt").buildFromText(text, false);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(44);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull FilePath filePath) throws IOException {
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(45);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(46);
        }
        DiffContent diffContent = this.createFromBytes(project, content2, filePath, null);
        if (diffContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(47);
        }
        return diffContent;
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull FilePath filePath, @Nullable Charset defaultCharset) throws IOException {
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(48);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(49);
        }
        if (defaultCharset == null && DiffContentFactoryImpl.isBinaryContent(content2, filePath.getFileType())) {
            return DiffContentFactoryImpl.createBinaryImpl(project, content2, filePath.getFileType(), filePath, filePath.getVirtualFile());
        }
        return this.createDocumentFromBytes(project, content2, filePath, defaultCharset);
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull FileType fileType, @NotNull String fileName) throws IOException {
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(50);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(51);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(52);
        }
        if (DiffContentFactoryImpl.isBinaryContent(content2, fileType)) {
            return DiffContentFactoryImpl.createBinaryImpl(project, content2, fileType, DiffVcsFacade.getInstance().getFilePath(fileName), null);
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project, content2, fileType, fileName);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(53);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull VirtualFile highlightFile) throws IOException {
        if (highlightFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(54);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(55);
        }
        if (DiffContentFactoryImpl.isBinaryContent(content2, highlightFile.getFileType())) {
            return DiffContentFactoryImpl.createBinaryImpl(project, content2, highlightFile.getFileType(), DiffVcsFacade.getInstance().getFilePath(highlightFile), highlightFile);
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project, content2, highlightFile);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(56);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull FileType fileType, @NotNull String fileName) {
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(57);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(58);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(59);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(project, content2, fileType);
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByFileType(fileType).withFileName(fileName).buildFromBytes(content2, charset);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(60);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull FilePath filePath) {
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(61);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(62);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(project, content2, filePath);
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByFilePath(filePath).buildFromBytes(content2, charset);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(63);
        }
        return documentContent;
    }

    @NotNull
    private DocumentContent createDocumentFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull FilePath filePath, @Nullable Charset defaultCharset) {
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(64);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(65);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(project, content2, filePath, defaultCharset);
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByFilePath(filePath).buildFromBytes(content2, charset);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(66);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, byte @NotNull [] content2, @NotNull VirtualFile highlightFile) {
        if (highlightFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(67);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(68);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(project, content2, highlightFile);
        DocumentContent documentContent = this.readOnlyDocumentContent(project).contextByHighlightFile(highlightFile).buildFromBytes(content2, charset);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(69);
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createBinary(@Nullable Project project, byte @NotNull [] content2, @NotNull FileType type, @NotNull String fileName) throws IOException {
        if (type == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(70);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(71);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(72);
        }
        return DiffContentFactoryImpl.createBinaryImpl(project, content2, type, DiffVcsFacade.getInstance().getFilePath(fileName), null);
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(73);
        }
        return DiffContentFactoryImpl.createContentFromFile(project, file2, file2);
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(74);
        }
        if (file2.isDirectory()) {
            return new DirectoryContentImpl(project, file2, highlightFile);
        }
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(file2));
        if (document != null) {
            return new FileDocumentContentImpl(project, document, file2, highlightFile);
        }
        return new FileContentImpl(project, file2, highlightFile);
    }

    @NotNull
    private static DiffContent createBinaryImpl(@Nullable Project project, byte @NotNull [] content2, @NotNull FileType type, @NotNull FilePath path, @Nullable VirtualFile highlightFile) throws IOException {
        Object file2;
        boolean useTemporalFile;
        if (type == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(75);
        }
        if (path == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(76);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(77);
        }
        boolean bl = useTemporalFile = type instanceof ArchiveFileType || BinaryFileTypeDecompilers.getInstance().forFileType(type) != null;
        if (useTemporalFile) {
            file2 = DiffContentFactoryImpl.createTemporalFile(path.getName(), content2);
        } else {
            file2 = new MyBinaryLightVirtualFile(path, type, content2);
            file2.setWritable(false);
        }
        file2.putUserData(DiffUtil.TEMP_FILE_KEY, (Object)Boolean.TRUE);
        return DiffContentFactoryImpl.createContentFromFile(project, file2, highlightFile);
    }

    @NotNull
    private static VirtualFile createTemporalFile(@NonNls @NotNull String suffix, byte @NotNull [] content2) throws IOException {
        VirtualFile file2;
        if (suffix == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(78);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(79);
        }
        File tempFile = FileUtil.createTempFile((String)"tmp_", (String)PathUtil.suggestFileName((String)("_" + suffix), (boolean)true, (boolean)false), (boolean)true);
        if (content2.length != 0) {
            FileUtil.writeToFile((File)tempFile, (byte[])content2);
        }
        if (!tempFile.setWritable(false, false)) {
            LOG.warn("Can't set writable attribute of temporal file");
        }
        if ((file2 = VfsUtil.findFileByIoFile((File)tempFile, (boolean)true)) == null) {
            throw new IOException("Can't create temp file for revision content");
        }
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file2});
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(80);
        }
        return virtualFile;
    }

    @NotNull
    private static Document createDocument(@Nullable Project project, @NotNull String content2, @Nullable FileType fileType, @NonNls @NotNull FilePath filePath, boolean readOnly) {
        Document document;
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(81);
        }
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(82);
        }
        if ((document = DiffContentFactoryImpl.createPsiDocument(project, content2, fileType, filePath, readOnly)) == null) {
            document = EditorFactory.getInstance().createDocument((CharSequence)content2);
            document.setReadOnly(readOnly);
        }
        Document document2 = document;
        if (document2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(83);
        }
        return document2;
    }

    @Nullable
    private static Document createPsiDocument(@Nullable Project project, @NotNull String content2, @Nullable FileType fileType, @NonNls @NotNull FilePath filePath, boolean readOnly) {
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(84);
        }
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(85);
        }
        if (project == null || project.isDefault()) {
            return null;
        }
        if (fileType == null || fileType.isBinary()) {
            return null;
        }
        MyLightVirtualFile file2 = new MyLightVirtualFile(filePath, fileType, content2);
        file2.setWritable(!readOnly);
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument((VirtualFile)file2));
        if (document == null) {
            return null;
        }
        ReadAction.run(() -> PsiDocumentManager.getInstance((Project)project).getPsiFile(document));
        return document;
    }

    private static boolean isBinaryContent(byte @NotNull [] content2, @NotNull FileType fileType) {
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(86);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(87);
        }
        if (UnknownFileType.INSTANCE.equals(fileType)) {
            return DiffContentFactoryImpl.guessCharsetFromContent(content2) == null;
        }
        if (fileType instanceof UIBasedFileType) {
            return true;
        }
        return fileType.isBinary();
    }

    @NotNull
    public static Charset guessCharset(@Nullable Project project, byte @NotNull [] content2, @NotNull FilePath filePath) {
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(88);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(89);
        }
        return DiffContentFactoryImpl.guessCharset(project, content2, filePath, null);
    }

    @NotNull
    private static Charset guessCharset(@Nullable Project project, byte @NotNull [] content2, @NotNull FilePath filePath, @Nullable Charset defaultCharset) {
        EncodingManager e;
        Charset propertiesCharset;
        FileType fileType;
        Charset charset;
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(90);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(91);
        }
        if ((charset = DiffContentFactoryImpl.guessCharsetFromContent(content2, fileType = filePath.getFileType())) != null) {
            Charset charset2 = charset;
            if (charset2 == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(92);
            }
            return charset2;
        }
        if (defaultCharset != null) {
            Charset charset3 = defaultCharset;
            if (charset3 == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(93);
            }
            return charset3;
        }
        if (fileType == StdFileTypes.PROPERTIES && (propertiesCharset = (e = project != null ? EncodingProjectManager.getInstance((Project)project) : EncodingManager.getInstance()).getDefaultCharsetForPropertiesFiles(null)) != null) {
            if (e.isNative2AsciiForPropertiesFiles()) {
                Charset charset4 = Native2AsciiCharset.wrap((Charset)propertiesCharset);
                if (charset4 == null) {
                    DiffContentFactoryImpl.$$$reportNull$$$0(94);
                }
                return charset4;
            }
            Charset charset5 = propertiesCharset;
            if (charset5 == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(95);
            }
            return charset5;
        }
        Charset charset6 = filePath.getCharset(project);
        if (charset6 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(96);
        }
        return charset6;
    }

    @NotNull
    public static Charset guessCharset(@Nullable Project project, byte @NotNull [] content2, @NotNull VirtualFile highlightFile) {
        Charset charset;
        if (highlightFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(97);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(98);
        }
        if ((charset = DiffContentFactoryImpl.guessCharsetFromContent(content2, highlightFile.getFileType())) != null) {
            Charset charset2 = charset;
            if (charset2 == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(99);
            }
            return charset2;
        }
        Charset charset3 = highlightFile.getCharset();
        if (charset3 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(100);
        }
        return charset3;
    }

    @NotNull
    public static Charset guessCharset(@Nullable Project project, byte @NotNull [] content2, @NotNull FileType fileType) {
        Charset charset;
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(101);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(102);
        }
        if ((charset = DiffContentFactoryImpl.guessCharsetFromContent(content2, fileType)) != null) {
            Charset charset2 = charset;
            if (charset2 == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(103);
            }
            return charset2;
        }
        EncodingManager e = project != null ? EncodingProjectManager.getInstance((Project)project) : EncodingManager.getInstance();
        Charset charset3 = e.getDefaultCharset();
        if (charset3 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(104);
        }
        return charset3;
    }

    @Nullable
    private static Charset guessCharsetFromContent(byte @NotNull [] content2, @NotNull FileType fileType) {
        Charset guessedCharset;
        Charset bomCharset;
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(105);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(106);
        }
        if ((bomCharset = CharsetToolkit.guessFromBOM((byte[])content2)) != null) {
            return bomCharset;
        }
        if (fileType.isBinary() && (guessedCharset = DiffContentFactoryImpl.guessCharsetFromContent(content2)) != null) {
            return guessedCharset;
        }
        return null;
    }

    @Nullable
    private static Charset guessCharsetFromContent(byte @NotNull [] content2) {
        CharsetToolkit toolkit;
        Charset fromBOM;
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(107);
        }
        if ((fromBOM = (toolkit = new CharsetToolkit(content2)).guessFromBOM()) != null) {
            return fromBOM;
        }
        CharsetToolkit.GuessedEncoding guessedEncoding = toolkit.guessFromContent(content2.length);
        switch (guessedEncoding) {
            case SEVEN_BIT: {
                return StandardCharsets.US_ASCII;
            }
            case VALID_UTF8: {
                return StandardCharsets.UTF_8;
            }
        }
        return null;
    }

    @NotNull
    private DiffContentFactoryEx.DocumentContentBuilder readOnlyDocumentContent(@Nullable Project project) {
        DiffContentFactoryEx.DocumentContentBuilder documentContentBuilder = this.documentContent(project, true);
        if (documentContentBuilder == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(108);
        }
        return documentContentBuilder;
    }

    @Override
    @NotNull
    public DiffContentFactoryEx.DocumentContentBuilder documentContent(@Nullable Project project, boolean readOnly) {
        DiffContentFactoryEx.DocumentContentBuilder documentContentBuilder = new DocumentContentBuilderImpl(project).withReadOnly(readOnly);
        if (documentContentBuilder == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(109);
        }
        return documentContentBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 53: 
            case 56: 
            case 60: 
            case 63: 
            case 66: 
            case 69: 
            case 80: 
            case 83: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 99: 
            case 100: 
            case 103: 
            case 104: 
            case 108: 
            case 109: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 53: 
            case 56: 
            case 60: 
            case 63: 
            case 66: 
            case 69: 
            case 80: 
            case 83: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 99: 
            case 100: 
            case 103: 
            case 104: 
            case 108: 
            case 109: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 53: 
            case 56: 
            case 60: 
            case 63: 
            case 66: 
            case 69: 
            case 80: 
            case 83: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 99: 
            case 100: 
            case 103: 
            case 104: 
            case 108: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl";
                break;
            }
            case 17: 
            case 45: 
            case 48: 
            case 61: 
            case 64: 
            case 82: 
            case 85: 
            case 88: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 39: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 59: 
            case 62: 
            case 65: 
            case 68: 
            case 72: 
            case 77: 
            case 79: 
            case 81: 
            case 84: 
            case 87: 
            case 89: 
            case 91: 
            case 98: 
            case 102: 
            case 106: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 50: 
            case 57: 
            case 86: 
            case 101: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 51: 
            case 58: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 54: 
            case 67: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightFile";
                break;
            }
            case 70: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditable";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createFragment";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createClipboardContent";
                break;
            }
            case 47: 
            case 53: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromBytes";
                break;
            }
            case 60: 
            case 63: 
            case 66: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocumentFromBytes";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporalFile";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 99: 
            case 100: 
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "guessCharset";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "readOnlyDocumentContent";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "documentContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 53: 
            case 56: 
            case 60: 
            case 63: 
            case 66: 
            case 69: 
            case 80: 
            case 83: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 99: 
            case 100: 
            case 103: 
            case 104: 
            case 108: 
            case 109: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createEditable";
                break;
            }
            case 34: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createFragment";
                break;
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createFromBytes";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createDocumentFromBytes";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createBinary";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createContentFromFile";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryImpl";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "createTemporalFile";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "createPsiDocument";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryContent";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 97: 
            case 98: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "guessCharset";
                break;
            }
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "guessCharsetFromContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 53: 
            case 56: 
            case 60: 
            case 63: 
            case 66: 
            case 69: 
            case 80: 
            case 83: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 99: 
            case 100: 
            case 103: 
            case 104: 
            case 108: 
            case 109: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Context {
        @Nullable
        public VirtualFile getHighlightFile();

        @Nullable
        public FileType getContentType();

        public static class ByFileType
        implements Context {
            private final FileType myFileType;

            public ByFileType(@NotNull FileType fileType) {
                if (fileType == null) {
                    ByFileType.$$$reportNull$$$0(0);
                }
                this.myFileType = fileType;
            }

            @Override
            @Nullable
            public VirtualFile getHighlightFile() {
                return null;
            }

            @Override
            @Nullable
            public FileType getContentType() {
                return this.myFileType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/diff/DiffContentFactoryImpl$Context$ByFileType", "<init>"));
            }
        }

        public static class ByFilePath
        implements Context {
            private final FilePath myFilePath;

            public ByFilePath(@NotNull FilePath filePath) {
                if (filePath == null) {
                    ByFilePath.$$$reportNull$$$0(0);
                }
                this.myFilePath = filePath;
            }

            @Override
            @Nullable
            public VirtualFile getHighlightFile() {
                return this.myFilePath.getVirtualFile();
            }

            @Override
            @Nullable
            public FileType getContentType() {
                return this.myFilePath.getFileType();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/diff/DiffContentFactoryImpl$Context$ByFilePath", "<init>"));
            }
        }

        public static class ByReferent
        implements Context {
            private final DocumentContent myReferent;

            public ByReferent(@NotNull DocumentContent referent) {
                if (referent == null) {
                    ByReferent.$$$reportNull$$$0(0);
                }
                this.myReferent = referent;
            }

            @Override
            @Nullable
            public VirtualFile getHighlightFile() {
                return this.myReferent.getHighlightFile();
            }

            @Override
            @Nullable
            public FileType getContentType() {
                return this.myReferent.getContentType();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/diff/DiffContentFactoryImpl$Context$ByReferent", "<init>"));
            }
        }

        public static class ByHighlightFile
        implements Context {
            private final VirtualFile myHighlightFile;

            public ByHighlightFile(@NotNull VirtualFile highlightFile) {
                if (highlightFile == null) {
                    ByHighlightFile.$$$reportNull$$$0(0);
                }
                this.myHighlightFile = highlightFile;
            }

            @Override
            @Nullable
            public VirtualFile getHighlightFile() {
                return this.myHighlightFile;
            }

            @Override
            @Nullable
            public FileType getContentType() {
                return this.myHighlightFile.getFileType();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightFile", "com/intellij/diff/DiffContentFactoryImpl$Context$ByHighlightFile", "<init>"));
            }
        }
    }

    private static class TextContent {
        @NotNull
        public final String text;
        @Nullable
        public LineSeparator separators;
        @Nullable
        public Charset charset;
        @Nullable
        public Boolean isBom;
        @Nullable
        public JComponent notification;

        TextContent(@NotNull String text) {
            if (text == null) {
                TextContent.$$$reportNull$$$0(0);
            }
            this.text = text;
        }

        @NotNull
        public static TextContent fromText(@NotNull String text, boolean respectLineSeparators) {
            if (text == null) {
                TextContent.$$$reportNull$$$0(1);
            }
            String correctedContent = StringUtil.convertLineSeparators((String)text);
            TextContent textContent = new TextContent(correctedContent);
            if (respectLineSeparators) {
                textContent.separators = StringUtil.detectSeparators((CharSequence)text);
            }
            TextContent textContent2 = textContent;
            if (textContent2 == null) {
                TextContent.$$$reportNull$$$0(2);
            }
            return textContent2;
        }

        @NotNull
        public static TextContent fromBytes(byte @NotNull [] content2, @NotNull Charset charset) {
            if (charset == null) {
                TextContent.$$$reportNull$$$0(3);
            }
            if (content2 == null) {
                TextContent.$$$reportNull$$$0(4);
            }
            boolean isBom = CharsetToolkit.guessFromBOM((byte[])content2) != null;
            boolean malformedContent = false;
            String text = CharsetToolkit.tryDecodeString((byte[])content2, (Charset)charset);
            if (text == null) {
                text = CharsetToolkit.decodeString((byte[])content2, (Charset)charset);
                malformedContent = true;
            }
            TextContent textContent = TextContent.fromText(text, true);
            textContent.charset = charset;
            textContent.isBom = isBom;
            if (malformedContent) {
                String notificationText = DiffBundle.message((String)"error.content.decoded.with.wrong.charset", (Object[])new Object[]{charset.name()});
                textContent.notification = DiffNotifications.createNotification(notificationText, LightColors.RED);
            }
            TextContent textContent2 = textContent;
            if (textContent2 == null) {
                TextContent.$$$reportNull$$$0(5);
            }
            return textContent2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl$TextContent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "charset";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl$TextContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromBytes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fromText";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fromBytes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ContextReferentDocumentContent
    extends DocumentContentBase {
        @Nullable
        private final LineSeparator mySeparator;
        @Nullable
        private final Charset myCharset;
        @Nullable
        private final Boolean myBOM;
        @Nullable
        private final Context myReferent;

        private ContextReferentDocumentContent(@Nullable Project project, @NotNull Document document, @NotNull TextContent content2, @Nullable Context referent) {
            if (document == null) {
                ContextReferentDocumentContent.$$$reportNull$$$0(0);
            }
            if (content2 == null) {
                ContextReferentDocumentContent.$$$reportNull$$$0(1);
            }
            super(project, document);
            this.mySeparator = content2.separators;
            this.myCharset = content2.charset;
            this.myBOM = content2.isBom;
            this.myReferent = referent;
        }

        @Nullable
        public FileType getContentType() {
            return this.myReferent != null ? this.myReferent.getContentType() : null;
        }

        @Nullable
        public VirtualFile getHighlightFile() {
            return this.myReferent != null ? this.myReferent.getHighlightFile() : null;
        }

        @Nullable
        public LineSeparator getLineSeparator() {
            return this.mySeparator;
        }

        @Nullable
        public Charset getCharset() {
            return this.myCharset;
        }

        @Nullable
        public Boolean hasBom() {
            return this.myBOM;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/DiffContentFactoryImpl$ContextReferentDocumentContent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ContentReferentDocumentContent
    extends DocumentContentBase {
        @NotNull
        private final DocumentContent myReferent;

        private ContentReferentDocumentContent(@Nullable Project project, @NotNull Document document, @NotNull DocumentContent referent) {
            if (document == null) {
                ContentReferentDocumentContent.$$$reportNull$$$0(0);
            }
            if (referent == null) {
                ContentReferentDocumentContent.$$$reportNull$$$0(1);
            }
            super(project, document);
            this.myReferent = referent;
        }

        @Nullable
        public FileType getContentType() {
            return this.myReferent.getContentType();
        }

        @Nullable
        public VirtualFile getHighlightFile() {
            return this.myReferent.getHighlightFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "referent";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/DiffContentFactoryImpl$ContentReferentDocumentContent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FileReferentDocumentContent
    extends DocumentContentBase {
        @NotNull
        private final VirtualFile myHighlightFile;

        private FileReferentDocumentContent(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile highlightFile) {
            if (document == null) {
                FileReferentDocumentContent.$$$reportNull$$$0(0);
            }
            if (highlightFile == null) {
                FileReferentDocumentContent.$$$reportNull$$$0(1);
            }
            super(project, document);
            this.myHighlightFile = highlightFile;
        }

        @NotNull
        public FileType getContentType() {
            FileType fileType = this.myHighlightFile.getFileType();
            if (fileType == null) {
                FileReferentDocumentContent.$$$reportNull$$$0(2);
            }
            return fileType;
        }

        @NotNull
        public VirtualFile getHighlightFile() {
            VirtualFile virtualFile = this.myHighlightFile;
            if (virtualFile == null) {
                FileReferentDocumentContent.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightFile";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl$FileReferentDocumentContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl$FileReferentDocumentContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyBinaryLightVirtualFile
    extends BinaryLightVirtualFile {
        private final FilePath myPath;

        MyBinaryLightVirtualFile(@NotNull FilePath path, @Nullable FileType type, byte @NotNull [] content2) {
            if (path == null) {
                MyBinaryLightVirtualFile.$$$reportNull$$$0(0);
            }
            if (content2 == null) {
                MyBinaryLightVirtualFile.$$$reportNull$$$0(1);
            }
            super(path.getName(), type, content2);
            this.myPath = path;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath.getPath();
            if (string == null) {
                MyBinaryLightVirtualFile.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl$MyBinaryLightVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl$MyBinaryLightVirtualFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyLightVirtualFile
    extends LightVirtualFile {
        private final FilePath myPath;

        private MyLightVirtualFile(@NotNull FilePath path, @Nullable FileType fileType, @NotNull String content2) {
            if (path == null) {
                MyLightVirtualFile.$$$reportNull$$$0(0);
            }
            if (content2 == null) {
                MyLightVirtualFile.$$$reportNull$$$0(1);
            }
            super(path.getName(), fileType, (CharSequence)content2);
            this.myPath = path;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath.getPath();
            if (string == null) {
                MyLightVirtualFile.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl$MyLightVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl$MyLightVirtualFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DocumentContentBuilderImpl
    implements DiffContentFactoryEx.DocumentContentBuilder {
        @Nullable
        private final Project project;
        private boolean readOnly;
        @Nullable
        private Context context;
        @Nullable
        private FilePath originalFilePath;
        @Nullable
        @NonNls
        private String fileName;

        DocumentContentBuilderImpl(@Nullable Project project) {
            this.project = project;
        }

        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder withReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(0);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder withFileName(@Nullable String fileName) {
            this.fileName = fileName;
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(1);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder contextByFileType(@Nullable FileType fileType) {
            if (fileType != null) {
                this.context = new Context.ByFileType(fileType);
            }
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(2);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder contextByFilePath(@Nullable FilePath filePath) {
            if (filePath != null) {
                this.context = new Context.ByFilePath(filePath);
                this.originalFilePath = filePath;
                this.fileName = filePath.getName();
            }
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(3);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder contextByHighlightFile(@Nullable VirtualFile file2) {
            if (file2 != null) {
                this.context = new Context.ByHighlightFile(file2);
                this.originalFilePath = DiffVcsFacade.getInstance().getFilePath(file2);
                this.fileName = file2.getName();
            }
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(4);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DiffContentFactoryEx.DocumentContentBuilder contextByReferent(@Nullable DocumentContent referent) {
            if (referent != null) {
                this.context = new Context.ByReferent(referent);
                VirtualFile file2 = referent.getHighlightFile();
                if (file2 != null) {
                    this.originalFilePath = DiffVcsFacade.getInstance().getFilePath(file2);
                    this.fileName = file2.getName();
                }
            }
            DocumentContentBuilderImpl documentContentBuilderImpl = this;
            if (documentContentBuilderImpl == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(5);
            }
            return documentContentBuilderImpl;
        }

        @Override
        @NotNull
        public DocumentContent buildFromText(@NotNull String text, boolean respectLineSeparators) {
            if (text == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(6);
            }
            return this.build(TextContent.fromText(text, respectLineSeparators));
        }

        @Override
        @NotNull
        public DocumentContent buildFromBytes(byte @NotNull [] content2, @NotNull Charset charset) {
            if (charset == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(7);
            }
            if (content2 == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(8);
            }
            return this.build(TextContent.fromBytes(content2, charset));
        }

        @NotNull
        private DocumentContent build(@NotNull TextContent textContent) {
            if (textContent == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(9);
            }
            FileType fileType = this.context != null ? this.context.getContentType() : null;
            FilePath filePath = this.originalFilePath;
            if (filePath == null) {
                String name = this.fileName;
                if (name == null) {
                    name = "diff." + StringUtil.defaultIfEmpty((String)(fileType != null ? fileType.getDefaultExtension() : null), (String)"txt");
                }
                filePath = DiffVcsFacade.getInstance().getFilePath(name);
            }
            Document document = DiffContentFactoryImpl.createDocument(this.project, textContent.text, fileType, filePath, this.readOnly);
            ContextReferentDocumentContent documentContent = new ContextReferentDocumentContent(this.project, document, textContent, this.context);
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
            if (this.originalFilePath != null && file2 instanceof LightVirtualFile) {
                OutsidersPsiFileSupport.markFile(file2, this.originalFilePath.getPath());
            }
            if (this.fileName != null) {
                documentContent.putUserData(DiffUserDataKeysEx.FILE_NAME, this.fileName);
            }
            if (textContent.notification != null) {
                DiffUtil.addNotification(textContent.notification, (UserDataHolder)documentContent);
            }
            ContextReferentDocumentContent contextReferentDocumentContent = documentContent;
            if (contextReferentDocumentContent == null) {
                DocumentContentBuilderImpl.$$$reportNull$$$0(10);
            }
            return contextReferentDocumentContent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl$DocumentContentBuilderImpl";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "charset";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withReadOnly";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withFileName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contextByFileType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contextByFilePath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contextByHighlightFile";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contextByReferent";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl$DocumentContentBuilderImpl";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "buildFromText";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "buildFromBytes";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

