/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class StatusPanel
extends JPanel {
    private final JLabel myTextLabel = new JLabel("");
    private final AnimatedIcon myBusySpinner;

    public StatusPanel() {
        super(new GridBagLayout());
        this.myTextLabel.setVisible(false);
        this.myBusySpinner = new AsyncProcessIcon("StatusPanelSpinner");
        this.myBusySpinner.setVisible(false);
        GridBag bag = new GridBag().setDefaultInsets((Insets)JBInsets.create((int)0, (int)2)).setDefaultFill(1).setDefaultWeightY(1.0);
        this.add((Component)this.myBusySpinner, bag.next());
        this.add((Component)this.myTextLabel, bag.next().weightx(1.0));
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
    }

    public void update() {
        String message = this.getMessage();
        this.myTextLabel.setVisible(message != null);
        this.myTextLabel.setText(StringUtil.notNullize((String)message));
    }

    public void setBusy(boolean busy) {
        if (busy) {
            this.myBusySpinner.setVisible(true);
            this.myBusySpinner.resume();
        } else {
            this.myBusySpinner.setVisible(false);
            this.myBusySpinner.suspend();
        }
    }

    @Nls
    @Nullable
    protected String getMessage() {
        return null;
    }
}

