/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.annotations.NotNull;

public class FixLineSeparatorsAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FixLineSeparatorsAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project == null || vFiles == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            for (VirtualFile vFile : vFiles) {
                FixLineSeparatorsAction.fixSeparators(vFile);
            }
        }, IdeBundle.message((String)"command.fixing.line.separators", (Object[])new Object[0]), null);
    }

    private static void fixSeparators(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FixLineSeparatorsAction.$$$reportNull$$$0(1);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)vFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                Document document;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file2.isDirectory() && !file2.getFileType().isBinary() && (document = FileDocumentManager.getInstance().getDocument(file2)) != null && FixLineSeparatorsAction.areSeparatorsBroken(document)) {
                    FixLineSeparatorsAction.fixSeparators(document);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/FixLineSeparatorsAction$1", "visitFile"));
            }
        });
    }

    private static boolean areSeparatorsBroken(@NotNull Document document) {
        if (document == null) {
            FixLineSeparatorsAction.$$$reportNull$$$0(2);
        }
        int count = document.getLineCount();
        for (int i2 = 1; i2 < count; i2 += 2) {
            if (document.getLineStartOffset(i2) == document.getLineEndOffset(i2)) continue;
            return false;
        }
        return true;
    }

    private static void fixSeparators(@NotNull Document document) {
        if (document == null) {
            FixLineSeparatorsAction.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (int i2 = 1; i2 < document.getLineCount(); ++i2) {
                int start2 = document.getLineEndOffset(i2);
                int end = document.getLineEndOffset(i2) + document.getLineSeparatorLength(i2);
                document.deleteString(start2, end);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/FixLineSeparatorsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fixSeparators";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "areSeparatorsBroken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

