/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaCheckBoxBorder;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalCheckBoxUI;
import javax.swing.text.View;
import org.jetbrains.annotations.Nullable;

public class DarculaCheckBoxUI
extends MetalCheckBoxUI {
    private static final Icon DEFAULT_ICON = ((EmptyIcon)JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)18))).asUIResource();
    private final PropertyChangeListener textChangedListener = e -> DarculaCheckBoxUI.updateTextPosition((AbstractButton)e.getSource());

    public static ComponentUI createUI(JComponent c) {
        return new DarculaCheckBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (ComponentUtil.getParentOfType(CellRendererPane.class, (Component)c) != null) {
            c.setBorder(null);
        }
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setIconTextGap(this.textIconGap());
        DarculaCheckBoxUI.updateTextPosition(b);
    }

    private static void updateTextPosition(AbstractButton b) {
        b.setVerticalTextPosition(DarculaUIUtil.isMultiLineHTML(b.getText()) ? 1 : 0);
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener("text", this.textChangedListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton button2) {
        super.uninstallListeners(button2);
        button2.removePropertyChangeListener("text", this.textChangedListener);
    }

    protected int textIconGap() {
        return JBUIScale.scale((int)5);
    }

    @Override
    public void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        Dimension size = c.getSize();
        AbstractButton b = (AbstractButton)c;
        Rectangle viewRect = this.updateViewRect(b, new Rectangle(size));
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = UIUtilities.getFontMetrics((JComponent)c, (Graphics)g, (Font)f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        this.drawCheckIcon(c, g, b, iconRect, b.isSelected(), b.isEnabled());
        this.drawText(c, g, b, fm, textRect, text);
    }

    protected Rectangle updateViewRect(AbstractButton b, Rectangle viewRect) {
        if (!(b.getBorder() instanceof DarculaCheckBoxBorder)) {
            JBInsets.removeFrom((Rectangle)viewRect, (Insets)b.getInsets());
        }
        return viewRect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawCheckIcon(JComponent c, Graphics2D g, AbstractButton b, Rectangle iconRect, boolean selected2, boolean enabled) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            String iconName = this.isIndeterminate(b) ? "checkBoxIndeterminate" : "checkBox";
            Object op = b.getClientProperty("JComponent.outline");
            boolean hasFocus = op == null && b.hasFocus();
            Icon icon2 = LafIconLookup.getIcon((String)iconName, (selected2 || this.isIndeterminate(b) ? 1 : 0) != 0, (boolean)hasFocus, (boolean)b.isEnabled());
            icon2.paintIcon(b, g2, iconRect.x, iconRect.y);
            if (op != null) {
                DarculaUIUtil.Outline.valueOf(op.toString()).setGraphicsColor(g2, b.hasFocus());
                Path2D.Float outline = new Path2D.Float(0);
                outline.append(new RoundRectangle2D.Float(iconRect.x + JBUIScale.scale((int)1), iconRect.y, JBUIScale.scale((int)18), JBUIScale.scale((int)18), JBUIScale.scale((int)8), JBUIScale.scale((int)8)), false);
                outline.append(new RoundRectangle2D.Float(iconRect.x + JBUIScale.scale((int)4), iconRect.y + JBUIScale.scale((int)3), JBUIScale.scale((int)12), JBUIScale.scale((int)12), JBUIScale.scale((int)3), JBUIScale.scale((int)3)), false);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                g2.fill(outline);
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected void drawText(JComponent c, Graphics2D g, AbstractButton b, FontMetrics fm, Rectangle textRect, String text) {
        if (text != null) {
            View v = (View)b.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                g.setColor(b.isEnabled() ? b.getForeground() : this.getDisabledTextColor());
                UIUtilities.drawStringUnderlineCharAt((JComponent)b, (Graphics)g, (String)text, (int)this.getMnemonicIndex(b), (int)textRect.x, (int)(textRect.y + fm.getAscent()));
            }
        }
    }

    protected int getMnemonicIndex(AbstractButton b) {
        return DarculaLaf.isAltPressed() ? b.getDisplayedMnemonicIndex() : -1;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dimension = this.computeOurPreferredSize(c);
        return dimension != null ? dimension : super.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected Dimension computeOurPreferredSize(JComponent c) {
        return DarculaCheckBoxUI.computeCheckboxPreferredSize(c, this.getDefaultIcon());
    }

    @Nullable
    static Dimension computeCheckboxPreferredSize(JComponent c, Icon defaultIcon) {
        if (c.getComponentCount() > 0) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        Rectangle prefViewRect = new Rectangle();
        Rectangle prefIconRect = new Rectangle();
        Rectangle prefTextRect = new Rectangle();
        String text = b.getText();
        Icon buttonIcon = b.getIcon();
        if (buttonIcon == null) {
            buttonIcon = defaultIcon;
        }
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        prefViewRect.y = 0;
        prefViewRect.x = 0;
        prefViewRect.width = Short.MAX_VALUE;
        prefViewRect.height = Short.MAX_VALUE;
        prefIconRect.height = 0;
        prefIconRect.width = 0;
        prefIconRect.y = 0;
        prefIconRect.x = 0;
        prefTextRect.height = 0;
        prefTextRect.width = 0;
        prefTextRect.y = 0;
        prefTextRect.x = 0;
        SwingUtilities.layoutCompoundLabel(c, fm, text, buttonIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), prefViewRect, prefIconRect, prefTextRect, text == null ? 0 : b.getIconTextGap());
        Insets insets = b.getInsets();
        if (!(b.getBorder() instanceof DarculaCheckBoxBorder)) {
            JBInsets.addTo((Rectangle)prefIconRect, (Insets)insets);
        }
        JBInsets.addTo((Rectangle)prefTextRect, (Insets)insets);
        int x1 = Math.min(prefIconRect.x, prefTextRect.x);
        int x2 = Math.max(prefIconRect.x + prefIconRect.width, prefTextRect.x + prefTextRect.width);
        int y1 = Math.min(prefIconRect.y, prefTextRect.y);
        int y2 = Math.max(prefIconRect.y + prefIconRect.height, prefTextRect.y + prefTextRect.height);
        int width = x2 - x1;
        int height = y2 - y1;
        return new Dimension(width, height);
    }

    @Override
    public Icon getDefaultIcon() {
        return DEFAULT_ICON;
    }

    protected boolean isIndeterminate(AbstractButton checkBox2) {
        return "indeterminate".equals(checkBox2.getClientProperty("JButton.selectedState")) || checkBox2 instanceof ThreeStateCheckBox && ((ThreeStateCheckBox)checkBox2).getState() == ThreeStateCheckBox.State.DONT_CARE;
    }
}

