/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.impl.FrameBoundsConverter;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.Splash;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SplashManager {
    private static JFrame PROJECT_FRAME;
    private static Splash SPLASH_WINDOW;

    public static void show(String @NotNull [] args, Boolean visible) {
        if (args == null) {
            SplashManager.$$$reportNull$$$0(0);
        }
        for (String arg : args) {
            if (!"nosplash".equals(arg)) continue;
            System.setProperty("nosplash", "true");
            return;
        }
        Activity frameActivity = StartUpMeasurer.startActivity((String)"splash as project frame initialization");
        try {
            PROJECT_FRAME = SplashManager.createFrameIfPossible();
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
        }
        frameActivity.end();
        if (PROJECT_FRAME != null) {
            return;
        }
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        assert (SPLASH_WINDOW == null);
        Activity activity = StartUpMeasurer.startActivity((String)"splash initialization");
        SPLASH_WINDOW = new Splash(appInfo);
        EventQueue.invokeLater(() -> {
            Splash splash = SPLASH_WINDOW;
            if (splash != null) {
                splash.initAndShow(visible);
            }
            activity.end();
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static IdeFrameImpl createFrameIfPossible() throws IOException {
        ByteBuffer buffer;
        Path infoFile = Paths.get(PathManager.getSystemPath(), "lastProjectFrameInfo");
        try (SeekableByteChannel channel = Files.newByteChannel(infoFile, new OpenOption[0]);){
            buffer = ByteBuffer.allocate((int)channel.size());
            do {
                channel.read(buffer);
            } while (buffer.hasRemaining());
            buffer.flip();
            if (buffer.getShort() != 0) {
                IdeFrameImpl ideFrameImpl = null;
                return ideFrameImpl;
            }
        }
        catch (NoSuchFileException ignore) {
            return null;
        }
        Rectangle savedBounds = new Rectangle(buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt());
        Color backgroundColor = new Color(buffer.getInt(), true);
        boolean isFullScreen = buffer.get() == 1;
        int extendedState = buffer.getInt();
        IdeFrameImpl frame = new IdeFrameImpl();
        frame.setAutoRequestFocus(false);
        frame.setDefaultCloseOperation(0);
        frame.setBounds(FrameBoundsConverter.convertFromDeviceSpaceAndFitToScreen(savedBounds));
        frame.setExtendedState(extendedState);
        frame.setMinimumSize(new Dimension(340, (int)frame.getMinimumSize().getHeight()));
        frame.setBackground(backgroundColor);
        frame.getContentPane().setBackground(backgroundColor);
        if (SystemInfoRt.isMac) {
            frame.setIconImage(null);
        }
        StartUpMeasurer.addInstantEvent((String)"frame shown");
        Activity activity = StartUpMeasurer.startActivity((String)"frame set visible");
        frame.setVisible(true);
        activity.end();
        return frame;
    }

    public static void executeWithHiddenSplash(@NotNull Window window, @NotNull Runnable runnable2) {
        if (window == null) {
            SplashManager.$$$reportNull$$$0(1);
        }
        if (runnable2 == null) {
            SplashManager.$$$reportNull$$$0(2);
        }
        if (SPLASH_WINDOW == null) {
            Runnable task2;
            if (PROJECT_FRAME != null && (task2 = SplashManager.getHideTask()) != null) {
                task2.run();
            }
            runnable2.run();
            return;
        }
        WindowAdapter listener2 = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                SplashManager.setVisible(false);
            }
        };
        window.addWindowListener(listener2);
        runnable2.run();
        SplashManager.setVisible(true);
        window.removeWindowListener(listener2);
    }

    private static void setVisible(boolean value2) {
        Splash splash = SPLASH_WINDOW;
        if (splash != null) {
            splash.setVisible(value2);
            if (value2) {
                splash.paint(splash.getGraphics());
            }
        }
    }

    @Nullable
    public static ProgressIndicator createProgressIndicator() {
        if (SPLASH_WINDOW == null) {
            return null;
        }
        return new EmptyProgressIndicator(){

            public void setFraction(double fraction) {
                SPLASH_WINDOW.showProgress(fraction);
            }
        };
    }

    @Nullable
    public static JFrame getAndUnsetProjectFrame() {
        JFrame frame = PROJECT_FRAME;
        PROJECT_FRAME = null;
        return frame;
    }

    public static void hideBeforeShow(final @NotNull Window window) {
        Runnable hideSplashTask;
        if (window == null) {
            SplashManager.$$$reportNull$$$0(3);
        }
        if ((hideSplashTask = SplashManager.getHideTask()) != null) {
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    hideSplashTask.run();
                    window.removeWindowListener(this);
                }
            });
        }
    }

    @Nullable
    public static Runnable getHideTask() {
        Window window = SPLASH_WINDOW;
        if (window == null && (window = PROJECT_FRAME) == null) {
            return null;
        }
        Ref ref = new Ref((Object)window);
        SPLASH_WINDOW = null;
        PROJECT_FRAME = null;
        return () -> {
            Window w = (Window)ref.get();
            if (w != null) {
                ref.set(null);
                w.setVisible(false);
                w.dispose();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/idea/SplashManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "executeWithHiddenSplash";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hideBeforeShow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

