/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.execution.InvalidJavaHomeException;
import com.intellij.openapi.externalSystem.service.execution.InvalidSdkException;
import com.intellij.openapi.externalSystem.service.execution.ProjectJdkNotFoundException;
import com.intellij.openapi.externalSystem.service.execution.UndefinedJavaHomeException;
import com.intellij.openapi.externalSystem.util.environment.Environment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.DependentSdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public final class ExternalSystemJdkUtil {
    public static final String JAVA_HOME = "JAVA_HOME";
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    public static final String USE_JAVA_HOME = "#JAVA_HOME";

    @Nullable
    @Contract(value="_, null -> null")
    public static Sdk getJdk(@Nullable Project project, @Nullable String jdkName) throws ExternalSystemJdkException {
        return ExternalSystemJdkUtil.resolveJdkName(ExternalSystemJdkUtil.getProjectJdk(project), jdkName);
    }

    @Nullable
    @Contract(value="_, null -> null")
    public static Sdk resolveJdkName(@Nullable Sdk projectSdk, @Nullable String jdkName) throws ExternalSystemJdkException {
        if (jdkName == null) {
            return null;
        }
        switch (jdkName) {
            case "#JAVA_INTERNAL": {
                return ExternalSystemJdkUtil.getInternalJdk();
            }
            case "#USE_PROJECT_JDK": {
                if (projectSdk == null) {
                    throw new ProjectJdkNotFoundException();
                }
                return ExternalSystemJdkUtil.resolveDependentJdk(projectSdk);
            }
            case "#JAVA_HOME": {
                return ExternalSystemJdkUtil.getJavaHomeJdk();
            }
        }
        return ExternalSystemJdkUtil.getJdk(jdkName);
    }

    @NotNull
    private static Sdk getProjectJdk(@Nullable Project project) {
        if (project != null) {
            Module[] modules2;
            Sdk res2 = ProjectRootManager.getInstance((Project)project).getProjectSdk();
            if (res2 != null) {
                Sdk sdk2 = res2;
                if (sdk2 == null) {
                    ExternalSystemJdkUtil.$$$reportNull$$$0(0);
                }
                return sdk2;
            }
            for (Module module : modules2 = ModuleManager.getInstance((Project)project).getModules()) {
                Sdk sdk3 = ModuleRootManager.getInstance((Module)module).getSdk();
                if (sdk3 == null || !(sdk3.getSdkType() instanceof JavaSdkType)) continue;
                Sdk sdk4 = sdk3;
                if (sdk4 == null) {
                    ExternalSystemJdkUtil.$$$reportNull$$$0(1);
                }
                return sdk4;
            }
        }
        SdkType jdkType = ExternalSystemJdkUtil.getJavaSdk();
        Sdk sdk5 = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)jdkType).stream().filter(it -> ExternalSystemJdkUtil.isValidJdk(it)).max(jdkType.versionComparator()).orElseGet(ExternalSystemJdkUtil::getInternalJdk);
        if (sdk5 == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(2);
        }
        return sdk5;
    }

    @NotNull
    private static Sdk getJavaHomeJdk() {
        String javaHome = ExternalSystemJdkUtil.getJavaHome();
        if (StringUtil.isEmptyOrSpaces((String)javaHome)) {
            throw new UndefinedJavaHomeException();
        }
        if (!ExternalSystemJdkUtil.isValidJdk(javaHome)) {
            throw new InvalidJavaHomeException(javaHome);
        }
        Sdk sdk2 = ExternalSystemJdkProvider.getInstance().createJdk(null, javaHome);
        if (sdk2 == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(3);
        }
        return sdk2;
    }

    @Nullable
    public static String getJavaHome() {
        return Environment.getVariable(JAVA_HOME);
    }

    @Nullable
    private static Sdk getJdk(@NotNull String jdkName) {
        Sdk jdk;
        if (jdkName == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(4);
        }
        if ((jdk = ProjectJdkTable.getInstance().findJdk(jdkName)) == null) {
            return null;
        }
        String homePath = jdk.getHomePath();
        if (!ExternalSystemJdkUtil.isValidJdk(jdk)) {
            throw new InvalidSdkException(homePath);
        }
        return jdk;
    }

    @NotNull
    public static Pair<String, Sdk> getAvailableJdk(@Nullable Project project) throws ExternalSystemJdkException {
        String javaHome;
        List allJdks;
        Sdk mostRecentSdk;
        SdkType javaSdkType = ExternalSystemJdkUtil.getJavaSdkType();
        if (project != null) {
            Sdk projectJdk = ExternalSystemJdkUtil.findProjectJDK(project, javaSdkType);
            if (projectJdk != null) {
                Pair pair = Pair.pair((Object)USE_PROJECT_JDK, (Object)projectJdk);
                if (pair == null) {
                    ExternalSystemJdkUtil.$$$reportNull$$$0(5);
                }
                return pair;
            }
            Sdk referencedJdk = ExternalSystemJdkUtil.findReferencedJdk(project);
            if (referencedJdk != null) {
                Pair pair = Pair.pair((Object)USE_PROJECT_JDK, (Object)referencedJdk);
                if (pair == null) {
                    ExternalSystemJdkUtil.$$$reportNull$$$0(6);
                }
                return pair;
            }
        }
        if ((mostRecentSdk = (Sdk)(allJdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdkType)).stream().filter(sdk2 -> ExternalSystemJdkUtil.isValidJdk(sdk2)).max(javaSdkType.versionComparator()).orElse(null)) != null) {
            Pair pair = Pair.pair((Object)mostRecentSdk.getName(), (Object)mostRecentSdk);
            if (pair == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(7);
            }
            return pair;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && ExternalSystemJdkUtil.isValidJdk(javaHome = ExternalSystemJdkUtil.getJavaHome())) {
            SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
            String sdkName = simpleJavaSdkType.suggestSdkName(null, javaHome);
            Pair pair = Pair.pair((Object)USE_JAVA_HOME, (Object)simpleJavaSdkType.createJdk(sdkName, javaHome));
            if (pair == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(8);
            }
            return pair;
        }
        Pair pair = Pair.pair((Object)USE_INTERNAL_JAVA, (Object)ExternalSystemJdkUtil.getInternalJdk());
        if (pair == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(9);
        }
        return pair;
    }

    private static Sdk findProjectJDK(@NotNull Project project, SdkType javaSdkType) {
        if (project == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(10);
        }
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Stream<Sdk> projectSdks = Stream.concat(Stream.of(projectSdk), Stream.of(ModuleManager.getInstance((Project)project).getModules()).map(module -> ModuleRootManager.getInstance((Module)module).getSdk()));
        return projectSdks.filter(sdk2 -> sdk2 != null && sdk2.getSdkType() == javaSdkType && ExternalSystemJdkUtil.isValidJdk(sdk2)).findFirst().orElse(null);
    }

    @Nullable
    @Contract(value="null -> null")
    private static Sdk findReferencedJdk(Sdk projectSdk) {
        if (projectSdk != null && projectSdk.getSdkType() instanceof DependentSdkType && projectSdk.getSdkType() instanceof JavaSdkType) {
            JavaSdkType sdkType = (JavaSdkType)projectSdk.getSdkType();
            String jdkPath = FileUtil.toSystemIndependentName((String)new File(sdkType.getBinPath(projectSdk)).getParent());
            return Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).filter(sdk2 -> {
                String homePath = sdk2.getHomePath();
                return homePath != null && FileUtil.toSystemIndependentName((String)homePath).equals(jdkPath);
            }).findFirst().orElse(null);
        }
        return null;
    }

    @Nullable
    private static Sdk findReferencedJdk(Project project) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        return ExternalSystemJdkUtil.findReferencedJdk(projectSdk);
    }

    @NotNull
    public static Sdk resolveDependentJdk(@NotNull Sdk sdk2) {
        Sdk parentSdk;
        if (sdk2 == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(11);
        }
        if ((parentSdk = ExternalSystemJdkUtil.findReferencedJdk(sdk2)) == null) {
            Sdk sdk3 = sdk2;
            if (sdk3 == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(12);
            }
            return sdk3;
        }
        Sdk sdk4 = parentSdk;
        if (sdk4 == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(13);
        }
        return sdk4;
    }

    @NotNull
    public static Collection<String> suggestJdkHomePaths() {
        Collection collection = ExternalSystemJdkUtil.getJavaSdkType().suggestHomePaths();
        if (collection == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public static SdkType getJavaSdkType() {
        return ExternalSystemJdkUtil.getJavaSdk();
    }

    @Contract(value="null -> false")
    public static boolean isValidJdk(@Nullable Sdk jdk) {
        if (jdk == null) {
            return false;
        }
        if (!(jdk.getSdkType() instanceof JavaSdkType)) {
            return false;
        }
        if (SdkDownloadTracker.getInstance().isDownloading(jdk)) {
            return true;
        }
        return ExternalSystemJdkUtil.isValidJdk(jdk.getHomePath());
    }

    @Contract(value="null -> false")
    public static boolean isValidJdk(@Nullable String homePath) {
        return !StringUtil.isEmptyOrSpaces((String)homePath) && JdkUtil.checkForJdk((String)homePath) && JdkUtil.checkForJre((String)homePath);
    }

    @NotNull
    public static Sdk addJdk(String homePath) {
        ExternalSystemJdkProvider jdkProvider = ExternalSystemJdkProvider.getInstance();
        List<Sdk> sdks = Arrays.asList(ProjectJdkTable.getInstance().getAllJdks());
        String name = SdkConfigurationUtil.createUniqueSdkName(jdkProvider.getJavaSdkType(), homePath, sdks);
        Sdk jdk = jdkProvider.createJdk(name, homePath);
        SdkConfigurationUtil.addSdk(jdk);
        Sdk sdk2 = jdk;
        if (sdk2 == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(15);
        }
        return sdk2;
    }

    @NotNull
    private static SdkType getJavaSdk() {
        SdkType sdkType = ExternalSystemJdkProvider.getInstance().getJavaSdkType();
        if (sdkType == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(16);
        }
        return sdkType;
    }

    @NotNull
    private static Sdk getInternalJdk() {
        Sdk sdk2 = ExternalSystemJdkProvider.getInstance().getInternalJdk();
        if (sdk2 == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(17);
        }
        return sdk2;
    }

    @Contract(value="null -> false")
    public static boolean isJdk9orLater(@Nullable String javaHome) {
        JdkVersionDetector.JdkVersionInfo jdkVersionInfo = javaHome == null ? null : JdkVersionDetector.getInstance().detectJdkVersionInfo(javaHome);
        return jdkVersionInfo != null && jdkVersionInfo.version.isAtLeast(9);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectJdk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaHomeJdk";
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableJdk";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDependentJdk";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestJdkHomePaths";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addJdk";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaSdk";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalJdk";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJdk";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findProjectJDK";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveDependentJdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

