/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.UnknownInvalidSdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTracker;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownSdkEditorNotification {
    public static final Key<List<EditorNotificationPanel>> NOTIFICATIONS = Key.create((String)"notifications added to the editor");
    private static final Key<?> EDITOR_NOTIFICATIONS_KEY = Key.create((String)"SdkSetupNotificationNew");
    private final Project myProject;
    private final FileEditorManager myFileEditorManager;
    private final AtomicReference<Set<SimpleSdkFixInfo>> myNotifications;

    @NotNull
    public static UnknownSdkEditorNotification getInstance(@NotNull Project project) {
        if (project == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(0);
        }
        UnknownSdkEditorNotification unknownSdkEditorNotification = (UnknownSdkEditorNotification)project.getService(UnknownSdkEditorNotification.class);
        if (unknownSdkEditorNotification == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(1);
        }
        return unknownSdkEditorNotification;
    }

    UnknownSdkEditorNotification(@NotNull Project project) {
        if (project == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(2);
        }
        this.myNotifications = new AtomicReference(new LinkedHashSet());
        this.myProject = project;
        this.myFileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (FileEditor editor : UnknownSdkEditorNotification.this.myFileEditorManager.getEditors(file2)) {
                    UnknownSdkEditorNotification.this.updateEditorNotifications(editor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorNotification$1";
                objectArray[2] = "fileOpened";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public boolean allowProjectSdkNotifications() {
        return this.myNotifications.get().isEmpty();
    }

    @NotNull
    public List<SimpleSdkFixInfo> getNotifications() {
        ImmutableList immutableList = ImmutableList.copyOf((Collection)this.myNotifications.get());
        if (immutableList == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    public void showNotifications(@NotNull List<UnknownSdk> unfixableSdks, @NotNull Map<UnknownSdk, UnknownSdkDownloadableSdkFix> files2, @NotNull List<UnknownInvalidSdk> invalidSdks) {
        if (unfixableSdks == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(4);
        }
        if (files2 == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(5);
        }
        if (invalidSdks == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(6);
        }
        ImmutableSet.Builder notifications = ImmutableSet.builder();
        if (Registry.is((String)"unknown.sdk.show.editor.actions")) {
            for (UnknownSdk unknownSdk2 : unfixableSdks) {
                @Nullable String name = unknownSdk2.getSdkName();
                SdkType type = unknownSdk2.getSdkType();
                if (name == null) continue;
                notifications.add((Object)new UnknownSdkFixInfo(name, type, null, null));
            }
            for (Map.Entry entry : files2.entrySet()) {
                UnknownSdk unknownSdk2 = (UnknownSdk)entry.getKey();
                String name = unknownSdk2.getSdkName();
                if (name == null) continue;
                UnknownSdkDownloadableSdkFix fix = (UnknownSdkDownloadableSdkFix)entry.getValue();
                notifications.add((Object)new UnknownSdkFixInfo(name, unknownSdk2.getSdkType(), unknownSdk2, fix));
            }
            for (UnknownInvalidSdk unknownInvalidSdk : invalidSdks) {
                notifications.add((Object)new InvalidSdkFixInfo(unknownInvalidSdk));
            }
        }
        this.myNotifications.set((Set<SimpleSdkFixInfo>)notifications.build());
        EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        ApplicationManager.getApplication().invokeLater(() -> {
            for (FileEditor editor : this.myFileEditorManager.getAllEditors()) {
                this.updateEditorNotifications(editor);
            }
        });
    }

    private void updateEditorNotifications(@NotNull FileEditor editor) {
        if (editor == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(7);
        }
        if (!editor.isValid()) {
            return;
        }
        List notifications = (List)editor.getUserData(NOTIFICATIONS);
        if (notifications != null) {
            for (JComponent component2 : notifications) {
                this.myFileEditorManager.removeTopComponent(editor, component2);
            }
            notifications.clear();
        } else {
            notifications = new SmartList();
            editor.putUserData(NOTIFICATIONS, (Object)notifications);
        }
        for (SimpleSdkFixInfo info : this.myNotifications.get()) {
            EditorNotificationPanel notification;
            VirtualFile file2 = editor.getFile();
            if (file2 == null || (notification = info.createNotificationPanel(file2, this.myProject)) == null) continue;
            notifications.add(notification);
            this.myFileEditorManager.addTopComponent(editor, (JComponent)notification);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorNotification";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unfixableSdks";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidSdks";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorNotification";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showNotifications";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateEditorNotifications";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class InvalidSdkFixInfo
    extends SimpleSdkFixInfo {
        @NotNull
        private final String mySdkName;
        @NotNull
        private final UnknownInvalidSdk mySdk;

        InvalidSdkFixInfo(UnknownInvalidSdk invalidSdk) {
            if (invalidSdk == null) {
                InvalidSdkFixInfo.$$$reportNull$$$0(0);
            }
            super(invalidSdk.mySdkType);
            this.mySdkName = invalidSdk.getSdkName();
            this.mySdk = invalidSdk;
        }

        @Override
        @NotNull
        final EditorNotificationPanel createNotificationPanelImpl(@NotNull VirtualFile file2, @NotNull Project project) {
            if (file2 == null) {
                InvalidSdkFixInfo.$$$reportNull$$$0(1);
            }
            if (project == null) {
                InvalidSdkFixInfo.$$$reportNull$$$0(2);
            }
            String sdkTypeName = this.mySdkType.getPresentableName();
            String notificationText = ProjectBundle.message((String)"config.invalid.sdk.notification.text", (Object[])new Object[]{sdkTypeName, this.mySdkName});
            String configureText = ProjectBundle.message((String)"config.invalid.sdk.configure", (Object[])new Object[0]);
            UnknownSdkLocalSdkFix localFix2 = this.mySdk.myLocalSdkFix;
            UnknownSdkDownloadableSdkFix downloadFix2 = this.mySdk.myDownloadableSdkFix;
            String intentionActionText = ProjectBundle.message((String)"config.invalid.sdk.configure.missing", (Object[])new Object[]{sdkTypeName, this.mySdkName});
            String localText = "";
            String localTextTooltip = "";
            if (localFix2 != null) {
                localText = intentionActionText = ProjectBundle.message((String)"config.unknown.sdk.local", (Object[])new Object[]{sdkTypeName, localFix2.getPresentableVersionString()});
                localTextTooltip = SdkListPresenter.presentDetectedSdkPath(localFix2.getExistingSdkHome(), 90, 40);
            }
            String downloadText = downloadFix2 != null ? (intentionActionText = ProjectBundle.message((String)"config.unknown.sdk.download", (Object[])new Object[]{downloadFix2.getDownloadDescription()})) : "";
            EditorNotificationPanel notification = this.newNotificationPanel(intentionActionText);
            notification.setProject(UnknownSdkEditorNotification.this.myProject);
            notification.setProviderKey(EDITOR_NOTIFICATIONS_KEY);
            notification.setText(notificationText);
            if (localFix2 != null) {
                HyperlinkLabel actionLabel = notification.createActionLabel(localText, () -> this.mySdk.applyLocalFix(project), true);
                actionLabel.setToolTipText(localTextTooltip);
            } else if (downloadFix2 != null) {
                notification.createActionLabel(downloadText, () -> this.mySdk.applyDownloadFix(UnknownSdkEditorNotification.this.myProject), true);
            }
            notification.createActionLabel(configureText, this.mySdk.createSdkSelectionPopup(project), true);
            EditorNotificationPanel editorNotificationPanel = notification;
            if (editorNotificationPanel == null) {
                InvalidSdkFixInfo.$$$reportNull$$$0(3);
            }
            return editorNotificationPanel;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("InvalidSdkFixInfo { name: ").append(this.mySdkName);
            if (this.mySdk.myLocalSdkFix != null) {
                sb.append(", fix: ").append(this.mySdk.myLocalSdkFix.getExistingSdkHome());
            }
            if (this.mySdk.myDownloadableSdkFix != null) {
                sb.append(", fix: ").append(this.mySdk.myDownloadableSdkFix.getDownloadDescription());
            }
            sb.append("}");
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invalidSdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorNotification$InvalidSdkFixInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorNotification$InvalidSdkFixInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNotificationPanelImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createNotificationPanelImpl";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class UnknownSdkFixInfo
    extends SimpleSdkFixInfo {
        @NotNull
        private final String mySdkName;
        @Nullable
        private final UnknownSdk mySdk;
        @Nullable
        private final UnknownSdkDownloadableSdkFix myFix;

        UnknownSdkFixInfo(@NotNull String sdkName, @Nullable SdkType sdkType, @Nullable UnknownSdk sdk2, UnknownSdkDownloadableSdkFix fix) {
            if (sdkName == null) {
                UnknownSdkFixInfo.$$$reportNull$$$0(0);
            }
            if (sdkType == null) {
                UnknownSdkFixInfo.$$$reportNull$$$0(1);
            }
            super(sdkType);
            this.mySdkName = sdkName;
            this.mySdk = sdk2;
            this.myFix = fix;
        }

        @Override
        @NotNull
        final EditorNotificationPanel createNotificationPanelImpl(@NotNull VirtualFile file2, @NotNull Project project) {
            if (file2 == null) {
                UnknownSdkFixInfo.$$$reportNull$$$0(2);
            }
            if (project == null) {
                UnknownSdkFixInfo.$$$reportNull$$$0(3);
            }
            String sdkTypeName = this.mySdkType.getPresentableName();
            String notificationText = ProjectBundle.message((String)"config.unknown.sdk.notification.text", (Object[])new Object[]{sdkTypeName, this.mySdkName});
            String configureText = ProjectBundle.message((String)"config.unknown.sdk.configure", (Object[])new Object[0]);
            boolean hasDownload = this.myFix != null && this.mySdk != null;
            String downloadText = hasDownload ? ProjectBundle.message((String)"config.unknown.sdk.download", (Object[])new Object[]{this.myFix.getDownloadDescription()}) : "";
            String intentionActionText = hasDownload ? downloadText : ProjectBundle.message((String)"config.unknown.sdk.configure.missing", (Object[])new Object[]{sdkTypeName, this.mySdkName});
            EditorNotificationPanel notification = this.newNotificationPanel(intentionActionText);
            notification.setProject(UnknownSdkEditorNotification.this.myProject);
            notification.setProviderKey(EDITOR_NOTIFICATIONS_KEY);
            notification.setText(notificationText);
            if (hasDownload) {
                AtomicBoolean isRunning = new AtomicBoolean(false);
                notification.createActionLabel(downloadText, () -> {
                    if (isRunning.compareAndSet(false, true)) {
                        UnknownSdkTracker.getInstance(UnknownSdkEditorNotification.this.myProject).applyDownloadableFix(this.mySdk, this.myFix);
                    }
                }, true);
            }
            notification.createActionLabel(configureText, UnknownSdkTracker.getInstance(UnknownSdkEditorNotification.this.myProject).createSdkSelectionPopup(this.mySdkName, this.mySdkType), true);
            EditorNotificationPanel editorNotificationPanel = notification;
            if (editorNotificationPanel == null) {
                UnknownSdkFixInfo.$$$reportNull$$$0(4);
            }
            return editorNotificationPanel;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SdkFixInfo { name: ").append(this.mySdkName);
            if (this.myFix != null) {
                sb.append(", fix: ").append(this.myFix.getDownloadDescription());
            }
            sb.append("}");
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorNotification$UnknownSdkFixInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorNotification$UnknownSdkFixInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNotificationPanelImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createNotificationPanelImpl";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class SimpleSdkFixInfo {
        @NotNull
        protected final SdkType mySdkType;

        protected SimpleSdkFixInfo(@NotNull SdkType sdkType) {
            if (sdkType == null) {
                SimpleSdkFixInfo.$$$reportNull$$$0(0);
            }
            this.mySdkType = sdkType;
        }

        @Nullable
        final EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull Project project) {
            if (file2 == null) {
                SimpleSdkFixInfo.$$$reportNull$$$0(1);
            }
            if (project == null) {
                SimpleSdkFixInfo.$$$reportNull$$$0(2);
            }
            if (!this.mySdkType.isRelevantForFile(project, file2)) {
                return null;
            }
            return this.createNotificationPanelImpl(file2, project);
        }

        @NotNull
        abstract EditorNotificationPanel createNotificationPanelImpl(@NotNull VirtualFile var1, @NotNull Project var2);

        @NotNull
        protected EditorNotificationPanel newNotificationPanel(final @NotNull String intentionActionText) {
            if (intentionActionText == null) {
                SimpleSdkFixInfo.$$$reportNull$$$0(3);
            }
            return new EditorNotificationPanel(){

                protected String getIntentionActionText() {
                    return intentionActionText;
                }

                @NotNull
                protected PriorityAction.Priority getIntentionActionPriority() {
                    PriorityAction.Priority priority = PriorityAction.Priority.HIGH;
                    if (priority == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return priority;
                }

                @NotNull
                protected String getIntentionActionFamilyName() {
                    String string = ProjectBundle.message((String)"config.unknown.sdk.configuration", (Object[])new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorNotification$SimpleSdkFixInfo$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIntentionActionPriority";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIntentionActionFamilyName";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intentionActionText";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorNotification$SimpleSdkFixInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createNotificationPanel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "newNotificationPanel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

