/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ValidatableSdkAdditionalData;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownload;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTask;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSdksModel
implements SdkModel {
    private static final Logger LOG = Logger.getInstance(ProjectSdksModel.class);
    private final HashMap<Sdk, Sdk> myProjectSdks = new HashMap();
    private final EventDispatcher<SdkModel.Listener> mySdkEventsDispatcher = EventDispatcher.create(SdkModel.Listener.class);
    private boolean myModified;
    private Sdk myProjectSdk;
    private boolean myInitialized;

    @NotNull
    public SdkModel.Listener getMulticaster() {
        SdkModel.Listener listener2 = (SdkModel.Listener)this.mySdkEventsDispatcher.getMulticaster();
        if (listener2 == null) {
            ProjectSdksModel.$$$reportNull$$$0(0);
        }
        return listener2;
    }

    public Sdk @NotNull [] getSdks() {
        Sdk[] sdkArray = this.myProjectSdks.values().toArray(new Sdk[0]);
        if (sdkArray == null) {
            ProjectSdksModel.$$$reportNull$$$0(1);
        }
        return sdkArray;
    }

    @Nullable
    public Sdk findSdk(@NotNull String sdkName) {
        if (sdkName == null) {
            ProjectSdksModel.$$$reportNull$$$0(2);
        }
        for (Sdk projectJdk : this.myProjectSdks.values()) {
            if (!sdkName.equals(projectJdk.getName())) continue;
            return projectJdk;
        }
        return null;
    }

    public void addListener(@NotNull SdkModel.Listener listener2) {
        if (listener2 == null) {
            ProjectSdksModel.$$$reportNull$$$0(3);
        }
        this.mySdkEventsDispatcher.addListener((EventListener)listener2);
    }

    public void removeListener(@NotNull SdkModel.Listener listener2) {
        if (listener2 == null) {
            ProjectSdksModel.$$$reportNull$$$0(4);
        }
        this.mySdkEventsDispatcher.removeListener((EventListener)listener2);
    }

    public void syncSdks() {
        Sdk[] projectSdks;
        for (Sdk sdk2 : projectSdks = ProjectJdkTable.getInstance().getAllJdks()) {
            Sdk editableCopy;
            if (this.myProjectSdks.containsKey(sdk2) || this.myProjectSdks.containsValue(sdk2)) continue;
            try {
                editableCopy = (Sdk)sdk2.clone();
            }
            catch (CloneNotSupportedException e) {
                LOG.error((Throwable)e);
                continue;
            }
            this.myProjectSdks.put(sdk2, editableCopy);
            SdkDownloadTracker.getInstance().registerEditableSdk(sdk2, editableCopy);
            this.getMulticaster().sdkAdded(editableCopy);
        }
    }

    public void reset(@Nullable Project project) {
        Sdk[] projectSdks;
        this.myProjectSdks.clear();
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        jdkTable.preconfigure();
        for (Sdk sdk2 : projectSdks = jdkTable.getAllJdks()) {
            try {
                Sdk editable = (Sdk)sdk2.clone();
                this.myProjectSdks.put(sdk2, editable);
                SdkDownloadTracker.getInstance().registerEditableSdk(sdk2, editable);
            }
            catch (CloneNotSupportedException e) {
                LOG.error((Throwable)e);
            }
        }
        if (project != null) {
            String sdkName = ProjectRootManager.getInstance((Project)project).getProjectSdkName();
            this.myProjectSdk = sdkName == null ? null : this.findSdk(sdkName);
        }
        this.myModified = false;
        this.myInitialized = true;
    }

    public void disposeUIResources() {
        this.myProjectSdks.clear();
        this.myInitialized = false;
    }

    @NotNull
    public HashMap<Sdk, Sdk> getProjectSdks() {
        HashMap<Sdk, Sdk> hashMap = this.myProjectSdks;
        if (hashMap == null) {
            ProjectSdksModel.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void apply() throws ConfigurationException {
        this.apply(null);
    }

    public void apply(@Nullable MasterDetailsComponent configurable2) throws ConfigurationException {
        this.apply(configurable2, false);
    }

    public void apply(@Nullable MasterDetailsComponent configurable2, boolean addedOnly) throws ConfigurationException {
        String[] errorString = new String[1];
        if (!this.canApply(errorString, configurable2, addedOnly)) {
            throw new ConfigurationException(errorString[0]);
        }
        this.doApply();
        this.myModified = false;
    }

    private void doApply() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            ArrayList<Sdk> itemsInTable = new ArrayList<Sdk>();
            ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
            Sdk[] allFromTable = jdkTable.getAllJdks();
            for (Sdk tableItem : allFromTable) {
                if (this.myProjectSdks.containsKey(tableItem)) {
                    itemsInTable.add(tableItem);
                    continue;
                }
                jdkTable.removeJdk(tableItem);
            }
            for (Sdk originalJdk : itemsInTable) {
                Sdk modifiedJdk = this.myProjectSdks.get(originalJdk);
                LOG.assertTrue(modifiedJdk != null);
                LOG.assertTrue(originalJdk != modifiedJdk);
                jdkTable.updateJdk(originalJdk, modifiedJdk);
            }
            Object[] allJdks = jdkTable.getAllJdks();
            for (Sdk projectJdk : this.myProjectSdks.keySet()) {
                LOG.assertTrue(projectJdk != null);
                if (ArrayUtilRt.find((Object[])allJdks, (Object)projectJdk) != -1) continue;
                jdkTable.addJdk(projectJdk);
                jdkTable.updateJdk(projectJdk, this.myProjectSdks.get(projectJdk));
                SdkDownloadTracker.getInstance().tryRegisterSdkDownloadFailureHandler(projectJdk, () -> ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().removeJdk(projectJdk)));
            }
        });
    }

    private boolean canApply(String @NotNull [] errorString, @Nullable MasterDetailsComponent rootConfigurable, boolean addedOnly) throws ConfigurationException {
        if (errorString == null) {
            ProjectSdksModel.$$$reportNull$$$0(6);
        }
        LinkedHashMap<Sdk, Sdk> sdks = new LinkedHashMap<Sdk, Sdk>(this.myProjectSdks);
        if (addedOnly) {
            Sdk[] allJdks;
            for (Sdk jdk : allJdks = ProjectJdkTable.getInstance().getAllJdks()) {
                sdks.remove(jdk);
            }
        }
        ArrayList<String> allNames = new ArrayList<String>();
        Sdk itemWithError = null;
        for (Sdk currItem : sdks.values()) {
            String currName = currItem.getName();
            if (currName.isEmpty()) {
                itemWithError = currItem;
                errorString[0] = ProjectBundle.message((String)"sdk.list.name.required.error", (Object[])new Object[0]);
                break;
            }
            if (allNames.contains(currName)) {
                itemWithError = currItem;
                errorString[0] = ProjectBundle.message((String)"sdk.list.unique.name.required.error", (Object[])new Object[0]);
                break;
            }
            SdkAdditionalData sdkAdditionalData = currItem.getSdkAdditionalData();
            if (sdkAdditionalData instanceof ValidatableSdkAdditionalData) {
                try {
                    ((ValidatableSdkAdditionalData)sdkAdditionalData).checkValid((SdkModel)this);
                }
                catch (ConfigurationException e) {
                    Object projectJdk;
                    if (!(rootConfigurable == null || (projectJdk = rootConfigurable.getSelectedObject()) instanceof Sdk && Comparing.strEqual((String)((Sdk)projectJdk).getName(), (String)currName))) {
                        rootConfigurable.selectNodeInTree(currName);
                    }
                    throw new ConfigurationException(ProjectBundle.message((String)"sdk.configuration.exception", (Object[])new Object[]{currName}) + " " + e.getMessage());
                }
            }
            allNames.add(currName);
        }
        if (itemWithError == null) {
            return true;
        }
        if (rootConfigurable != null) {
            rootConfigurable.selectNodeInTree(itemWithError.getName());
        }
        return false;
    }

    public void removeSdk(@NotNull Sdk editableObject) {
        if (editableObject == null) {
            ProjectSdksModel.$$$reportNull$$$0(7);
        }
        Sdk projectJdk = null;
        for (Sdk jdk : this.myProjectSdks.keySet()) {
            if (this.myProjectSdks.get(jdk) != editableObject) continue;
            projectJdk = jdk;
            break;
        }
        if (projectJdk != null) {
            this.myProjectSdks.remove(projectJdk);
            SdkDownloadTracker.getInstance().onSdkRemoved(projectJdk);
            ((SdkModel.Listener)this.mySdkEventsDispatcher.getMulticaster()).beforeSdkRemove(projectJdk);
            this.myModified = true;
        }
    }

    public void createAddActions(@NotNull DefaultActionGroup group, @NotNull JComponent parent, @NotNull Consumer<? super Sdk> updateTree, @Nullable Condition<? super SdkTypeId> filter2) {
        if (group == null) {
            ProjectSdksModel.$$$reportNull$$$0(8);
        }
        if (parent == null) {
            ProjectSdksModel.$$$reportNull$$$0(9);
        }
        if (updateTree == null) {
            ProjectSdksModel.$$$reportNull$$$0(10);
        }
        this.createAddActions(group, parent, null, updateTree, filter2);
    }

    @NotNull
    private static List<SdkType> getAddableSdkTypes(@Nullable Condition<? super SdkTypeId> filter2) {
        List list2 = ContainerUtil.filter((Object[])SdkType.getAllTypes(), type -> type.allowCreationByUser() && (filter2 == null || filter2.value(type)));
        if (list2 == null) {
            ProjectSdksModel.$$$reportNull$$$0(11);
        }
        return list2;
    }

    public void createAddActions(@NotNull DefaultActionGroup group, @NotNull JComponent parent, @Nullable Sdk selectedSdk, @NotNull Consumer<? super Sdk> updateTree, @Nullable Condition<? super SdkTypeId> filter2) {
        if (group == null) {
            ProjectSdksModel.$$$reportNull$$$0(12);
        }
        if (parent == null) {
            ProjectSdksModel.$$$reportNull$$$0(13);
        }
        if (updateTree == null) {
            ProjectSdksModel.$$$reportNull$$$0(14);
        }
        Map<SdkType, NewSdkAction> downloadActions = this.createDownloadActions(filter2);
        Map<SdkType, NewSdkAction> defaultAddActions = this.createAddActions(filter2);
        for (SdkType type : ProjectSdksModel.getAddableSdkTypes(filter2)) {
            NewSdkAction defaultAction;
            NewSdkAction downloadAction = downloadActions.get(type);
            if (downloadAction != null) {
                group.add((AnAction)downloadAction.setOverrides(selectedSdk, parent, updateTree));
            }
            if ((defaultAction = defaultAddActions.get(type)) == null) continue;
            group.add((AnAction)defaultAction.setOverrides(selectedSdk, parent, updateTree));
        }
    }

    @NotNull
    public Map<SdkType, NewSdkAction> createDownloadActions(@Nullable Condition<? super SdkTypeId> filter2) {
        LinkedHashMap<SdkType, NewSdkAction> result2 = new LinkedHashMap<SdkType, NewSdkAction>();
        for (final SdkType type : ProjectSdksModel.getAddableSdkTypes(filter2)) {
            final SdkDownload downloadExtension = (SdkDownload)SdkDownload.EP_NAME.findFirstSafe(it -> it.supportsDownload((SdkTypeId)type));
            if (downloadExtension == null) continue;
            String downloadText = ProjectBundle.message((String)"sdk.configure.download.subAction", (Object[])new Object[]{type.getPresentableName()});
            NewSdkAction downloadAction = new NewSdkAction(type, downloadText, downloadExtension.getIconForDownloadAction((SdkTypeId)type)){

                @Override
                public void actionPerformed(@Nullable Sdk selectedSdk, @NotNull JComponent parent, @NotNull Consumer<? super Sdk> callback2) {
                    if (parent == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (callback2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ProjectSdksModel.this.doDownload(downloadExtension, parent, selectedSdk, type, callback2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "parent";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "callback";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ProjectSdksModel$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            result2.put(type, downloadAction);
        }
        LinkedHashMap<SdkType, NewSdkAction> linkedHashMap = result2;
        if (linkedHashMap == null) {
            ProjectSdksModel.$$$reportNull$$$0(15);
        }
        return linkedHashMap;
    }

    @NotNull
    public Map<SdkType, NewSdkAction> createAddActions(@Nullable Condition<? super SdkTypeId> filter2) {
        LinkedHashMap<SdkType, NewSdkAction> result2 = new LinkedHashMap<SdkType, NewSdkAction>();
        for (final SdkType type : ProjectSdksModel.getAddableSdkTypes(filter2)) {
            String addOnDiskText = ProjectBundle.message((String)"sdk.configure.add.sdkType.subAction", (Object[])new Object[]{type.getPresentableName()});
            NewSdkAction addAction = new NewSdkAction(type, addOnDiskText, type.getIconForAddAction()){

                @Override
                public void actionPerformed(@Nullable Sdk selectedSdk, @NotNull JComponent parent, @NotNull Consumer<? super Sdk> callback2) {
                    if (parent == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (callback2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (type.supportsCustomCreateUI()) {
                        type.showCustomCreateUI((SdkModel)ProjectSdksModel.this, parent, selectedSdk, sdk2 -> ProjectSdksModel.this.setupSdk(sdk2, (Consumer<? super Sdk>)callback2));
                    } else {
                        SdkConfigurationUtil.selectSdkHome(type, (Consumer<? super String>)((Consumer)home -> ProjectSdksModel.this.addSdk(type, (String)home, callback2)));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "parent";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "callback";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ProjectSdksModel$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            result2.put(type, addAction);
        }
        LinkedHashMap<SdkType, NewSdkAction> linkedHashMap = result2;
        if (linkedHashMap == null) {
            ProjectSdksModel.$$$reportNull$$$0(16);
        }
        return linkedHashMap;
    }

    public void doAdd(@NotNull JComponent parent, @NotNull SdkType type, @NotNull Consumer<? super Sdk> callback2) {
        if (parent == null) {
            ProjectSdksModel.$$$reportNull$$$0(17);
        }
        if (type == null) {
            ProjectSdksModel.$$$reportNull$$$0(18);
        }
        if (callback2 == null) {
            ProjectSdksModel.$$$reportNull$$$0(19);
        }
        this.doAdd(parent, null, type, callback2);
    }

    public void doDownload(@NotNull SdkDownload downloadExtension, @NotNull JComponent parent, @Nullable Sdk selectedSdk, @NotNull SdkType type, @NotNull Consumer<? super Sdk> callback2) {
        if (downloadExtension == null) {
            ProjectSdksModel.$$$reportNull$$$0(20);
        }
        if (parent == null) {
            ProjectSdksModel.$$$reportNull$$$0(21);
        }
        if (type == null) {
            ProjectSdksModel.$$$reportNull$$$0(22);
        }
        if (callback2 == null) {
            ProjectSdksModel.$$$reportNull$$$0(23);
        }
        LOG.assertTrue(downloadExtension.supportsDownload((SdkTypeId)type));
        this.myModified = true;
        downloadExtension.showDownloadUI((SdkTypeId)type, this, parent, selectedSdk, sdk2 -> this.setupInstallableSdk(type, (SdkDownloadTask)sdk2, callback2));
    }

    public void doAdd(@NotNull JComponent parent, @Nullable Sdk selectedSdk, @NotNull SdkType type, @NotNull Consumer<? super Sdk> callback2) {
        if (parent == null) {
            ProjectSdksModel.$$$reportNull$$$0(24);
        }
        if (type == null) {
            ProjectSdksModel.$$$reportNull$$$0(25);
        }
        if (callback2 == null) {
            ProjectSdksModel.$$$reportNull$$$0(26);
        }
        this.myModified = true;
        if (type.supportsCustomCreateUI()) {
            type.showCustomCreateUI((SdkModel)this, parent, selectedSdk, sdk2 -> this.setupSdk((Sdk)sdk2, callback2));
        } else {
            SdkConfigurationUtil.selectSdkHome(type, (Consumer<? super String>)((Consumer)home -> this.addSdk(type, (String)home, callback2)));
        }
    }

    public void addSdk(@NotNull SdkType type, @NotNull String home, @Nullable Consumer<? super Sdk> callback2) {
        if (type == null) {
            ProjectSdksModel.$$$reportNull$$$0(27);
        }
        if (home == null) {
            ProjectSdksModel.$$$reportNull$$$0(28);
        }
        Sdk newJdk = this.createSdk(type, home);
        this.setupSdk(newJdk, callback2);
    }

    @NotNull
    public Sdk createSdk(@NotNull SdkType type, @NotNull String home) {
        if (type == null) {
            ProjectSdksModel.$$$reportNull$$$0(29);
        }
        if (home == null) {
            ProjectSdksModel.$$$reportNull$$$0(30);
        }
        String newSdkName = SdkConfigurationUtil.createUniqueSdkName(type, home, this.myProjectSdks.values());
        return ProjectSdksModel.createSdkInternal(type, newSdkName, home);
    }

    @NotNull
    public Sdk createSdk(@NotNull SdkType type, @NotNull String suggestedName, @NotNull String home) {
        if (type == null) {
            ProjectSdksModel.$$$reportNull$$$0(31);
        }
        if (suggestedName == null) {
            ProjectSdksModel.$$$reportNull$$$0(32);
        }
        if (home == null) {
            ProjectSdksModel.$$$reportNull$$$0(33);
        }
        String newSdkName = SdkConfigurationUtil.createUniqueSdkName(suggestedName, this.myProjectSdks.values());
        return ProjectSdksModel.createSdkInternal(type, newSdkName, home);
    }

    @NotNull
    private static Sdk createSdkInternal(@NotNull SdkType type, @NotNull String newSdkName, @NotNull String home) {
        if (type == null) {
            ProjectSdksModel.$$$reportNull$$$0(34);
        }
        if (newSdkName == null) {
            ProjectSdksModel.$$$reportNull$$$0(35);
        }
        if (home == null) {
            ProjectSdksModel.$$$reportNull$$$0(36);
        }
        ProjectJdkImpl newJdk = new ProjectJdkImpl(newSdkName, (SdkTypeId)type);
        newJdk.setHomePath(home);
        ProjectJdkImpl projectJdkImpl = newJdk;
        if (projectJdkImpl == null) {
            ProjectSdksModel.$$$reportNull$$$0(37);
        }
        return projectJdkImpl;
    }

    public void setupInstallableSdk(@NotNull SdkType type, @NotNull SdkDownloadTask item, @Nullable Consumer<? super Sdk> callback2) {
        if (type == null) {
            ProjectSdksModel.$$$reportNull$$$0(38);
        }
        if (item == null) {
            ProjectSdksModel.$$$reportNull$$$0(39);
        }
        String suggestedName = item.getSuggestedSdkName();
        String homeDir = FileUtil.toSystemIndependentName((String)item.getPlannedHomeDir());
        Sdk sdk2 = this.createSdk(type, suggestedName, homeDir);
        SdkDownloadTracker tracker = SdkDownloadTracker.getInstance();
        tracker.registerSdkDownload(sdk2, item);
        this.doAdd(sdk2, (Consumer<? super Sdk>)((Consumer)editableSdk -> {
            tracker.registerEditableSdk(sdk2, (Sdk)editableSdk);
            tracker.tryRegisterSdkDownloadFailureHandler(sdk2, () -> this.removeSdk((Sdk)editableSdk));
            if (callback2 != null) {
                callback2.consume(editableSdk);
            }
        }));
        tracker.startSdkDownloadIfNeeded(sdk2);
    }

    private void setupSdk(@NotNull Sdk newJdk, @Nullable Consumer<? super Sdk> callback2) {
        if (newJdk == null) {
            ProjectSdksModel.$$$reportNull$$$0(40);
        }
        String home = newJdk.getHomePath();
        SdkType sdkType = (SdkType)newJdk.getSdkType();
        if (!sdkType.setupSdkPaths(newJdk, (SdkModel)this)) {
            return;
        }
        if (newJdk.getVersionString() == null) {
            String message = ProjectBundle.message((String)"sdk.java.corrupt.error", (Object[])new Object[]{home});
            Messages.showMessageDialog((String)message, (String)ProjectBundle.message((String)"sdk.java.corrupt.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        this.doAdd(newJdk, callback2);
    }

    public void addSdk(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            ProjectSdksModel.$$$reportNull$$$0(41);
        }
        this.doAdd(sdk2, null);
    }

    public void doAdd(@NotNull Sdk newSdk, @Nullable Consumer<? super Sdk> updateTree) {
        if (newSdk == null) {
            ProjectSdksModel.$$$reportNull$$$0(42);
        }
        this.myModified = true;
        try {
            Sdk editableCopy = (Sdk)newSdk.clone();
            this.myProjectSdks.put(newSdk, editableCopy);
            if (updateTree != null) {
                updateTree.consume((Object)editableCopy);
            }
            ((SdkModel.Listener)this.mySdkEventsDispatcher.getMulticaster()).sdkAdded(editableCopy);
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public Sdk findSdk(@Nullable Sdk modelJdk) {
        for (Map.Entry<Sdk, Sdk> entry : this.myProjectSdks.entrySet()) {
            Sdk jdk = entry.getKey();
            if (!Comparing.equal((Object)entry.getValue(), (Object)modelJdk)) continue;
            return jdk;
        }
        return null;
    }

    @Nullable
    public Sdk getProjectSdk() {
        if (!this.myProjectSdks.containsValue(this.myProjectSdk)) {
            return null;
        }
        return this.myProjectSdk;
    }

    public void setProjectSdk(Sdk projectSdk) {
        this.myProjectSdk = projectSdk;
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ProjectSdksModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorString";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editableObject";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateTree";
                break;
            }
            case 18: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadExtension";
                break;
            }
            case 28: 
            case 30: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSdkName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newJdk";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMulticaster";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdks";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ProjectSdksModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSdks";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddableSdkTypes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDownloadActions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddActions";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdkInternal";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSdk";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canApply";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeSdk";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createAddActions";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "doAdd";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doDownload";
                break;
            }
            case 27: 
            case 28: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addSdk";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createSdk";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createSdkInternal";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setupInstallableSdk";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setupSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class NewSdkAction
    extends DumbAwareAction {
        private final SdkType mySdkType;
        private Sdk mySelectedSdkOverride;
        private JComponent myParentOverride;
        private Consumer<? super Sdk> myCallbackOverride;

        private NewSdkAction(@NotNull SdkType sdkType, @Nls(capitalization=Nls.Capitalization.Title) @Nullable String text, @Nullable Icon icon2) {
            if (sdkType == null) {
                NewSdkAction.$$$reportNull$$$0(0);
            }
            super(text, null, icon2);
            this.mySdkType = sdkType;
        }

        @NotNull
        NewSdkAction setOverrides(@Nullable Sdk selectedSdkFallback, @NotNull JComponent parentFallback, @NotNull Consumer<? super Sdk> callbackFallback) {
            if (parentFallback == null) {
                NewSdkAction.$$$reportNull$$$0(1);
            }
            if (callbackFallback == null) {
                NewSdkAction.$$$reportNull$$$0(2);
            }
            this.mySelectedSdkOverride = selectedSdkFallback;
            this.myParentOverride = parentFallback;
            this.myCallbackOverride = callbackFallback;
            NewSdkAction newSdkAction = this;
            if (newSdkAction == null) {
                NewSdkAction.$$$reportNull$$$0(3);
            }
            return newSdkAction;
        }

        @NotNull
        public final SdkType getSdkType() {
            SdkType sdkType = this.mySdkType;
            if (sdkType == null) {
                NewSdkAction.$$$reportNull$$$0(4);
            }
            return sdkType;
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                NewSdkAction.$$$reportNull$$$0(5);
            }
            Sdk selectedSdk = this.mySelectedSdkOverride;
            JComponent parent = this.myParentOverride;
            Consumer<? super Sdk> callback2 = this.myCallbackOverride;
            if (callback2 == null || parent == null) {
                return;
            }
            this.actionPerformed(selectedSdk, parent, callback2);
        }

        public abstract void actionPerformed(@Nullable Sdk var1, @NotNull JComponent var2, @NotNull Consumer<? super Sdk> var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentFallback";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callbackFallback";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ProjectSdksModel$NewSdkAction";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ProjectSdksModel$NewSdkAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setOverrides";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdkType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setOverrides";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

