/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.apple.eawt.FullScreenUtilities;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.messages.SheetController;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.Animator;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SheetMessage
implements Disposable {
    private final JDialog myWindow;
    private final Window myParent;
    private final SheetController myController;
    private static final int TIME_TO_SHOW_SHEET = 250;
    private Image staticImage;
    private int imageHeight;

    SheetMessage(@Nullable Window owner, String title, String message, Icon icon2, String[] buttons, DialogWrapper.DoNotAskOption doNotAskOption, String defaultButton, String focusedButton) {
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Component recentFocusOwner = activeWindow == null ? null : activeWindow.getMostRecentFocusOwner();
        WeakReference<Component> beforeShowFocusOwner = new WeakReference<Component>(recentFocusOwner);
        SheetMessage.maximizeIfNeeded(owner);
        this.myWindow = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.myWindow.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
        this.myParent = owner == null ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() : owner;
        this.myWindow.setUndecorated(true);
        this.myWindow.setBackground(Gray.TRANSPARENT);
        this.myController = new SheetController(this, title, message, icon2, buttons, defaultButton, doNotAskOption, focusedButton);
        Disposer.register((Disposable)this, (Disposable)this.myController);
        this.imageHeight = 0;
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                SheetMessage.this.setPositionRelativeToParent();
            }

            @Override
            public void componentMoved(ComponentEvent event) {
                SheetMessage.this.setPositionRelativeToParent();
            }
        };
        this.myParent.addComponentListener(componentAdapter);
        Disposer.register((Disposable)this, () -> this.myParent.removeComponentListener(componentAdapter));
        this.myWindow.setFocusable(true);
        this.myWindow.setFocusableWindowState(true);
        this.myWindow.setSize(this.myController.SHEET_NC_WIDTH, 0);
        this.myWindow.setOpacity(0.0f);
        ComponentAdapter componentListener = new ComponentAdapter(){

            @Override
            public void componentShown(@NotNull ComponentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.componentShown(e);
                SheetMessage.this.myWindow.setOpacity(1.0f);
                SheetMessage.this.myWindow.setSize(((SheetMessage)SheetMessage.this).myController.SHEET_NC_WIDTH, ((SheetMessage)SheetMessage.this).myController.SHEET_NC_HEIGHT);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/messages/SheetMessage$2", "componentShown"));
            }
        };
        this.myWindow.addComponentListener(componentListener);
        Disposer.register((Disposable)this, () -> this.myWindow.removeComponentListener(componentListener));
        KeyListener animationKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int modifiersUnion;
                boolean modifiersAreNotPressed;
                int modifiers = e.getModifiers();
                boolean bl = modifiersAreNotPressed = (modifiers & (modifiersUnion = 960)) == 0;
                if (modifiersAreNotPressed) {
                    if (e.getKeyCode() == 27) {
                        Disposer.dispose((Disposable)SheetMessage.this);
                    }
                    if (e.getKeyCode() == 10) {
                        SheetMessage.this.myController.setDefaultResult();
                        Disposer.dispose((Disposable)SheetMessage.this);
                    }
                    if (e.getKeyCode() == 32) {
                        SheetMessage.this.myController.setFocusedResult();
                        Disposer.dispose((Disposable)SheetMessage.this);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
        Disposer.register((Disposable)this, () -> this.myWindow.removeKeyListener(animationKeyListener));
        this.myWindow.addKeyListener(animationKeyListener);
        this.startAnimation(true);
        if (this.couldBeInFullScreen()) {
            FullScreenUtilities.setWindowCanFullScreen((Window)this.myParent, (boolean)false);
            Disposer.register((Disposable)this, () -> FullScreenUtilities.setWindowCanFullScreen((Window)this.myParent, (boolean)true));
        }
        LaterInvocator.enterModal(this.myWindow);
        this._showTouchBar();
        this.myWindow.setVisible(true);
        LaterInvocator.leaveModal(this.myWindow);
        Component focusCandidate = (Component)beforeShowFocusOwner.get();
        if (focusCandidate == null) {
            focusCandidate = IdeFocusManager.getGlobalInstance().getLastFocusedFor(IdeFocusManager.getGlobalInstance().getLastFocusedIdeWindow());
        }
        Component finalFocusCandidate = focusCandidate;
        if (focusCandidate != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(finalFocusCandidate, true));
        }
    }

    public void dispose() {
        DialogWrapper.cleanupRootPane((JRootPane)this.myWindow.getRootPane());
        this.myWindow.dispose();
    }

    private void _showTouchBar() {
        if (!TouchBarsManager.isTouchBarEnabled()) {
            return;
        }
        Disposable tb = TouchBarsManager.showDialogWrapperButtons(this.myController.getSheetPanel());
        if (tb != null) {
            Disposer.register((Disposable)this, (Disposable)tb);
        }
    }

    private static void maximizeIfNeeded(@Nullable Window owner) {
        Frame f;
        if (owner instanceof Frame && (f = (Frame)owner).getState() == 1) {
            f.setState(0);
        }
    }

    private boolean couldBeInFullScreen() {
        if (this.myParent instanceof JFrame) {
            JRootPane rootPane = ((JFrame)this.myParent).getRootPane();
            return rootPane.getClientProperty("Idea.Is.In.FullScreen.Mode.Now") == null;
        }
        return false;
    }

    public boolean toBeShown() {
        return !this.myController.getDoNotAskResult();
    }

    public String getResult() {
        return this.myController.getResult();
    }

    void startAnimation(final boolean enlarge) {
        this.staticImage = this.myController.getStaticImage();
        JPanel staticPanel = new JPanel(){

            @Override
            public void paint(@NotNull Graphics g) {
                if (g == null) {
                    4.$$$reportNull$$$0(0);
                }
                super.paint(g);
                if (SheetMessage.this.staticImage != null) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setBackground((Color)new JBColor(new Color(255, 255, 255, 0), new Color(110, 110, 110, 0)));
                    g2d.clearRect(0, 0, ((SheetMessage)SheetMessage.this).myController.SHEET_NC_WIDTH, ((SheetMessage)SheetMessage.this).myController.SHEET_NC_HEIGHT);
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.95f));
                    int multiplyFactor = SheetMessage.this.staticImage.getWidth(null) / ((SheetMessage)SheetMessage.this).myController.SHEET_NC_WIDTH;
                    g.drawImage(SheetMessage.this.staticImage, 0, 0, ((SheetMessage)SheetMessage.this).myController.SHEET_NC_WIDTH, SheetMessage.this.imageHeight, 0, SheetMessage.this.staticImage.getHeight(null) - SheetMessage.this.imageHeight * multiplyFactor, SheetMessage.this.staticImage.getWidth(null), SheetMessage.this.staticImage.getHeight(null), null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/messages/SheetMessage$4", "paint"));
            }
        };
        staticPanel.setOpaque(false);
        staticPanel.setSize(this.myController.SHEET_NC_WIDTH, this.myController.SHEET_NC_HEIGHT);
        this.myWindow.setContentPane(staticPanel);
        Animator myAnimator = new Animator("Roll Down Sheet Animator", this.myController.SHEET_NC_HEIGHT, 250, false){

            public void paintNow(int frame, int totalFrames, int cycle) {
                SheetMessage.this.setPositionRelativeToParent();
                float percentage = (float)frame / (float)totalFrames;
                SheetMessage.this.imageHeight = enlarge ? (int)((float)((SheetMessage)SheetMessage.this).myController.SHEET_NC_HEIGHT * percentage) : (int)((float)((SheetMessage)SheetMessage.this).myController.SHEET_NC_HEIGHT - percentage * (float)((SheetMessage)SheetMessage.this).myController.SHEET_HEIGHT);
                SheetMessage.this.myWindow.repaint();
            }

            protected void paintCycleEnd() {
                SheetMessage.this.setPositionRelativeToParent();
                if (enlarge) {
                    SheetMessage.this.imageHeight = ((SheetMessage)SheetMessage.this).myController.SHEET_NC_HEIGHT;
                    SheetMessage.this.staticImage = null;
                    SheetMessage.this.myWindow.setContentPane(SheetMessage.this.myController.getPanel(SheetMessage.this.myWindow));
                    IJSwingUtilities.moveMousePointerOn(SheetMessage.this.myWindow.getRootPane().getDefaultButton());
                    SheetMessage.this.myController.requestFocus();
                } else {
                    Disposer.dispose((Disposable)SheetMessage.this);
                }
            }
        };
        Disposer.register((Disposable)this, (Disposable)myAnimator);
        myAnimator.resume();
    }

    private void setPositionRelativeToParent() {
        int width = this.myParent.getWidth();
        this.myWindow.setBounds(width / 2 - this.myController.SHEET_NC_WIDTH / 2 + this.myParent.getLocation().x, this.myParent.getInsets().top + this.myParent.getLocation().y, this.myController.SHEET_NC_WIDTH, this.myController.SHEET_NC_HEIGHT);
    }
}

