/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.NameEnumerator;
import com.intellij.rt.coverage.data.TestDiscoveryProtocolDataListener;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.coverage.gnu.trove.TIntArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketTestDiscoveryProtocolDataListener
extends TestDiscoveryProtocolDataListener {
    private static final int SOCKET_BUFFER_SIZE = 131072;
    public static final String HOST_PROP = "test.discovery.data.host";
    public static final String PORT_PROP = "test.discovery.data.port";
    public static final String DATA_VERSION = "test.discovery.data.version";
    private static final byte DEFAULT_VERSION = 1;
    private final Socket mySocket;
    private final BlockingQueue<ByteBuffer> myData = new ArrayBlockingQueue<ByteBuffer>(10);
    private final NameEnumerator.Incremental incrementalNameEnumerator = new NameEnumerator.Incremental();
    private final DataOutputStream dos;
    private final OutputStream os;

    public SocketTestDiscoveryProtocolDataListener() throws IOException {
        super(Byte.parseByte(System.getProperty(DATA_VERSION, String.valueOf(1))));
        String host = System.getProperty(HOST_PROP, "127.0.0.1");
        int port = Integer.parseInt(System.getProperty(PORT_PROP));
        this.mySocket = new Socket(host, port);
        this.mySocket.setSendBufferSize(131072);
        this.mySocket.setTcpNoDelay(true);
        this.os = this.mySocket.getOutputStream();
        this.dos = new DataOutputStream(this.os);
        this.start(this.dos);
    }

    @Override
    public void testFinished(String className, String methodName, Map<Integer, boolean[]> classToVisitedMethods, Map<Integer, int[]> classToMethodNames, List<int[]> openedFiles) {
        try {
            this.writeTestFinished(this.dos, className, methodName, classToVisitedMethods, classToMethodNames, openedFiles);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void testsFinished() {
        try {
            this.finish(this.dos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.dos.close();
                this.os.close();
                this.mySocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addMetadata(Map<String, String> metadata) throws IOException {
        this.writeMetadata(this.dos, metadata);
    }

    @Override
    public void addClassMetadata(List<ClassMetadata> metadata) throws IOException {
        this.writeClassMetadata(this.dos, metadata);
    }

    @Override
    public NameEnumerator.Incremental getNameEnumerator() {
        return this.incrementalNameEnumerator;
    }

    private static class VisitedMethods {
        private final int classId;
        private final TIntArrayList methodIds = new TIntArrayList(1);

        private VisitedMethods(int classId) {
            this.classId = classId;
        }
    }
}

