(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define scheme/base-ports#input-port-open?
    (lambda (_port4569_)
      (if (not (input-port? _port4569_))
          (error '"Bad argument; expected input port" _port4569_)
          (if (macro-closed? (macro-port-roptions _port4569_))
              '#f
              (if (macro-device-port? _port4569_)
                  (scheme/base-ports#rdevice-open?
                   (macro-condvar-name
                    (macro-device-port-rdevice-condvar _port4569_)))
                  (if (macro-raw-device-port? _port4569_)
                      (scheme/base-ports#rdevice-open?
                       (macro-condvar-name
                        (macro-raw-device-port-rdevice-condvar _port4569_)))
                      '#t))))))
  (define scheme/base-ports#output-port-open?
    (lambda (_port4567_)
      (if (not (output-port? _port4567_))
          (error '"Bad argument; expected input port" _port4567_)
          (if (macro-closed? (macro-port-woptions _port4567_))
              '#f
              (if (macro-device-port? _port4567_)
                  (scheme/base-ports#wdevice-open?
                   (macro-condvar-name
                    (macro-device-port-wdevice-condvar _port4567_)))
                  (if (macro-raw-device-port? _port4567_)
                      (scheme/base-ports#wdevice-open?
                       (macro-condvar-name
                        (macro-raw-device-port-wdevice-condvar _port4567_)))
                      '#t))))))
  (namespace ("scheme/base-ports#" rdevice-open? wdevice-open?))
  (c-declare
   "#ifndef ___STAGE_OPEN\n#define ___STAGE_OPEN 0\n#endif\n#ifndef ___FFI_HAVE_DEVICE\n#define ___FFI_HAVE_DEVICE\ntypedef struct ___device_struct\n  {\n    void *vtbl;\n    int refcount;                  /* device structure is released when zero */\n    void *group;                   /* device group this device belongs to */\n    struct ___device_struct *prev; /* bidirectional list pointer to previous */\n    struct ___device_struct *next; /* bidirectional list pointer to next */\n    int direction;                 /* ___DIRECTION_RD and/or ___DIRECTION_WR */\n    int close_direction;           /* ___DIRECTION_RD and/or ___DIRECTION_WR */\n    int read_stage;                /* ___STAGE_OPEN ... ___STAGE_CLOSED */\n    int write_stage;               /* ___STAGE_OPEN ... ___STAGE_CLOSED */\n  } ___device;\n#endif\n\nstatic ___SCMOBJ ___rdevice_openp(___SCMOBJ dev)\n{\n ___device *d = ___CAST(___device*,___FIELD(dev,___FOREIGN_PTR));\n if (d->read_stage != ___STAGE_OPEN)\n {\n  return ___FAL;\n }\n else\n {\n  return ___TRU;\n }\n}\n\nstatic ___SCMOBJ ___wdevice_openp(___SCMOBJ dev)\n{\n ___device *d = ___CAST(___device*,___FIELD(dev,___FOREIGN_PTR));\n if (d->write_stage != ___STAGE_OPEN)\n {\n  return ___FAL;\n }\n else\n {\n  return ___TRU;\n }\n}")
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (##symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-c-lambda
   rdevice-open?
   (scheme-object)
   scheme-object
   "___rdevice_openp")
  (define-c-lambda
   wdevice-open?
   (scheme-object)
   scheme-object
   "___wdevice_openp")
  (define scheme/base-ports#port-buffered-chars?
    (lambda (_port4562_)
      (let ((_$e4564_
             (##fx< (macro-character-port-rlo _port4562_)
                    (macro-character-port-rhi _port4562_))))
        (if _$e4564_ _$e4564_ (macro-character-port-peek-eof? _port4562_)))))
  (define scheme/base-ports#check-byte-port/lock!
    (lambda (_port4559_ _proc4560_)
      (if (macro-byte-port? _port4559_)
          '#!void
          (error '"Illegal argument; expected byte-port" _port4559_))
      (macro-port-mutex-lock! _port4559_)
      (if (scheme/base-ports#port-buffered-chars? _port4559_)
          (begin
            (macro-port-mutex-unlock! _port4559_)
            (##raise-nonempty-input-port-character-buffer-exception
             _port4559_
             _proc4560_
             _port4559_))
          '#!void)))
  (define scheme/base-ports#peek-u8
    (lambda (_port4547_)
      (scheme/base-ports#check-byte-port/lock!
       _port4547_
       scheme/base-ports#peek-u8)
      (let _lp4549_ ()
        (let ((_byte-rlo4552_ (macro-byte-port-rlo _port4547_))
              (_byte-rhi4553_ (macro-byte-port-rhi _port4547_)))
          (if (##fx< _byte-rlo4552_ _byte-rhi4553_)
              (let ((_byte4555_
                     (u8vector-ref
                      (macro-byte-port-rbuf _port4547_)
                      _byte-rlo4552_)))
                (macro-port-mutex-unlock! _port4547_)
                _byte4555_)
              (let ((_res4557_
                     ((macro-byte-port-rbuf-fill _port4547_)
                      _port4547_
                      '1
                      '#t)))
                (if (eq? _res4557_ ##err-code-EAGAIN)
                    (begin (macro-port-mutex-unlock! _port4547_) (eof-object))
                    (if (fixnum? _res4557_)
                        (begin
                          (macro-port-mutex-unlock! _port4547_)
                          (##raise-os-io-exception
                           _port4547_
                           '#f
                           _res4557_
                           scheme/base-ports#peek-u8
                           _port4547_))
                        (if _res4557_
                            (_lp4549_)
                            (begin
                              (macro-port-mutex-unlock! _port4547_)
                              (eof-object))))))))))))
