/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.ibootim;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.ios.ibootim.iBootImHeader;
import ghidra.file.formats.ios.ibootim.iBootImUtil;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class iBootImAnalyzer
extends FileFormatAnalyzer
implements AnalysisWorker {
    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)program);
        return manager.scheduleWorker((AnalysisWorker)this, null, false, monitor);
    }

    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        Address address = program.getMinAddress();
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), address);
        iBootImHeader header = new iBootImHeader((ByteProvider)provider);
        if (!header.getSignature().equals("iBootIm")) {
            return false;
        }
        DataType headerDataType = header.toDataType();
        Data headerData = this.createData(program, address, headerDataType);
        this.createFragment(program, headerDataType.getName(), headerData.getMinAddress(), headerData.getMaxAddress().add(1L));
        this.changeDataSettings(program, monitor);
        this.removeEmptyFragments(program);
        return true;
    }

    public String getWorkerName() {
        return this.getName();
    }

    public boolean canAnalyze(Program program) {
        return iBootImUtil.isiBootIm(program);
    }

    public boolean getDefaultEnablement(Program program) {
        return iBootImUtil.isiBootIm(program);
    }

    public String getDescription() {
        return "Annotates an iBoot Image (iBootIm) file.";
    }

    public String getName() {
        return "iBoot Image (iBootIm) Annotation";
    }

    public boolean isPrototype() {
        return true;
    }
}

