/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypeSynchronizer;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;

public class SyncRefreshAction
extends DockingAction {
    public static final String MENU_NAME = "Refresh Sync Indicators For";
    private DataTypeManagerHandler dataTypeManagerHandler;
    private final DataTypeManager dtm;
    private final SourceArchive sourceArchive;
    private final DataTypeManagerPlugin plugin;
    private DataTypeSynchronizer synchronizer;
    private ArchiveNode archiveNode;

    public SyncRefreshAction(DataTypeManagerPlugin plugin, DataTypeManagerHandler dataTypeManagerHandler, DataTypeManager dtm, ArchiveNode archiveNode, SourceArchive sourceArchive, boolean isEnabled) {
        super("Refresh The Sync Indicators For Archive", plugin.getName());
        this.plugin = plugin;
        this.dataTypeManagerHandler = dataTypeManagerHandler;
        this.dtm = dtm;
        this.archiveNode = archiveNode;
        this.sourceArchive = sourceArchive;
        this.synchronizer = new DataTypeSynchronizer(dataTypeManagerHandler, dtm, sourceArchive);
        this.setEnabled(isEnabled);
        this.setPopupMenuData(new MenuData(new String[]{MENU_NAME, sourceArchive.getName()}));
        this.setHelpLocation(new HelpLocation(plugin.getName(), this.getHelpTopic()));
    }

    protected String getHelpTopic() {
        return "Refresh_Sync_Indicators";
    }

    public void actionPerformed(ActionContext context) {
        if (!this.dtm.isUpdatable()) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)"Sync Refresh Failed", (Object)("\"" + this.dtm.getName() + "\" must be open for editing."));
            return;
        }
        DataTypeManager sourceDTM = this.dataTypeManagerHandler.getDataTypeManager(this.sourceArchive);
        if (sourceDTM == null) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)"Cannot Access Source Archive", (Object)("Can't access the data types for the " + this.sourceArchive.getName() + " archive."));
            return;
        }
        DataTypesProvider provider = this.plugin.getProvider();
        DataTypeArchiveGTree tree = provider.getGTree();
        GTreeState treeState = tree.getTreeState();
        tree.collapseAll((GTreeNode)this.archiveNode);
        this.synchronizer.reSyncDataTypes();
        Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)"Refresh Completed", (Object)("Sync indicators refresh for " + this.dtm.getName() + " to archive \"" + this.sourceArchive.getName() + "\"."));
        tree.restoreTreeState(treeState);
    }
}

