/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.widgets.label.GLabel;
import docking.widgets.textfield.HintTextField;
import ghidra.app.cmd.function.CreateFunctionTagCmd;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.function.tags.FunctionTagButtonPanel;
import ghidra.app.plugin.core.function.tags.FunctionTagPlugin;
import ghidra.app.plugin.core.function.tags.SourceTagsPanel;
import ghidra.app.plugin.core.function.tags.TagListPanel;
import ghidra.app.plugin.core.function.tags.TargetTagsPanel;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FunctionTagsComponentProvider
extends ComponentProviderAdapter
implements DomainObjectListener {
    private Color BORDER_COLOR = Color.GRAY;
    private SourceTagsPanel sourcePanel;
    private TargetTagsPanel targetPanel;
    private FunctionTagButtonPanel buttonPanel;
    private Program program;
    private JPanel mainPanel;
    private JPanel inputPanel;
    private JPanel filterPanel;
    private HintTextField tagInputTF;
    private HintTextField filterInputTF;
    private int MIN_WIDTH = 400;
    private int MIN_HEIGHT = 150;
    private ProgramLocation currentLocation = null;
    private static String INPUT_DELIMITER = ",";

    public FunctionTagsComponentProvider(FunctionTagPlugin plugin, Program program) {
        super(plugin.getTool(), "Function Tags", plugin.getName(), ProgramActionContext.class);
        this.setHelpLocation(new HelpLocation(plugin.getName(), plugin.getName()));
        this.program = program;
        this.addToTool();
    }

    public void reload() {
        SystemUtilities.runSwingLater(() -> {
            if (this.tagInputTF != null) {
                this.tagInputTF.setText("");
            }
            this.updateTitle(this.currentLocation);
            this.updateTagLists();
        });
    }

    public void componentShown() {
        this.mainPanel = this.createWorkPanel();
        this.updateTagLists();
        this.updateTitle(this.currentLocation);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void locationChanged(ProgramLocation loc) {
        this.currentLocation = loc;
        this.updateTitle(loc);
        this.updateTagLists();
    }

    public void programActivated(Program activatedProgram) {
        this.program = activatedProgram;
        activatedProgram.addListener((DomainObjectListener)this);
        this.updateTagLists();
    }

    public void programDeactivated(Program deactivatedProgram) {
        deactivatedProgram.removeListener((DomainObjectListener)this);
        this.program = null;
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(147) || ev.containsEvent(148) || ev.containsEvent(149) || ev.containsEvent(157) || ev.containsEvent(156)) {
            this.reload();
        }
    }

    private void updateTitle(ProgramLocation location) {
        if (!this.isVisible()) {
            return;
        }
        Function function = this.getFunctionAtLocation(location);
        if (function == null) {
            this.setSubTitle("NOT A FUNCTION");
        } else {
            this.setSubTitle(" " + function.getName() + " (" + function.getEntryPoint().toString() + ")");
        }
    }

    private JPanel createWorkPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 50.0;
        bottomPanel.add((Component)this.createInputPanel(), gbc);
        gbc.gridx = 1;
        bottomPanel.add((Component)this.createFilterPanel(), gbc);
        this.mainPanel.add((Component)bottomPanel, "South");
        this.mainPanel.setPreferredSize(new Dimension(this.MIN_WIDTH, this.MIN_HEIGHT));
        JPanel tagPanel = new JPanel();
        tagPanel.setLayout(new GridBagLayout());
        this.sourcePanel = new SourceTagsPanel(this, this.tool, "Available Tags");
        this.targetPanel = new TargetTagsPanel(this, this.tool, "Assigned To Function");
        this.buttonPanel = new FunctionTagButtonPanel(this.sourcePanel, this.targetPanel);
        this.sourcePanel.setBorder(BorderFactory.createLineBorder(this.BORDER_COLOR));
        this.targetPanel.setBorder(BorderFactory.createLineBorder(this.BORDER_COLOR));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        tagPanel.add((Component)this.sourcePanel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        tagPanel.add((Component)this.buttonPanel, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.5;
        tagPanel.add((Component)this.targetPanel, gbc);
        this.mainPanel.add((Component)tagPanel, "Center");
        return this.mainPanel;
    }

    public void selectionChanged(TagListPanel panel) {
        Function function = this.getFunctionAtLocation(this.currentLocation);
        if (panel instanceof SourceTagsPanel) {
            this.buttonPanel.sourcePanelSelectionChanged(function != null);
            this.targetPanel.clearSelection();
        } else if (panel instanceof TargetTagsPanel) {
            this.buttonPanel.targetPanelSelectionChanged(function != null);
            this.sourcePanel.clearSelection();
        }
    }

    private Function getFunctionAtLocation(ProgramLocation loc) {
        Address functionAddress = this.getFunctionAddress(loc);
        if (functionAddress == null) {
            return null;
        }
        return this.program.getFunctionManager().getFunctionContaining(functionAddress);
    }

    private Address getFunctionAddress(ProgramLocation loc) {
        if (this.program == null || loc == null) {
            return null;
        }
        if (this.program.getFunctionManager().isInFunction(loc.getAddress())) {
            return loc.getAddress();
        }
        if (loc instanceof FunctionLocation) {
            FunctionLocation functionLocation = (FunctionLocation)loc;
            Address functionAddress = functionLocation.getFunctionAddress();
            return functionAddress;
        }
        return null;
    }

    private void updateTagLists() {
        if (this.sourcePanel == null || this.targetPanel == null) {
            return;
        }
        this.sourcePanel.setProgram(this.program);
        this.targetPanel.setProgram(this.program);
        Function function = this.getFunctionAtLocation(this.currentLocation);
        this.sourcePanel.refresh(function);
        this.targetPanel.refresh(function);
    }

    private void processCreates() {
        if (this.program == null) {
            Msg.showInfo((Object)((Object)this), (Component)this.tool.getActiveWindow(), (String)"No program!", (Object)"You must load a program before trying to create tags");
            return;
        }
        List<String> names = this.getInputNames();
        for (String name : names) {
            if (this.sourcePanel.tagExists(name) || this.targetPanel.tagExists(name)) {
                Msg.showInfo((Object)((Object)this), (Component)this.tool.getActiveWindow(), (String)"Duplicate Tag Name", (Object)("There is already a tag with the name [" + name + "]. Please try again."));
                continue;
            }
            CreateFunctionTagCmd cmd = new CreateFunctionTagCmd(name);
            this.tool.execute((Command)cmd, (DomainObject)this.program);
        }
    }

    private List<String> getInputNames() {
        String[] names = this.tagInputTF.getText().split(INPUT_DELIMITER);
        ArrayList<String> nameList = new ArrayList<String>();
        for (String name : names) {
            if (name.trim().isEmpty()) continue;
            nameList.add(name.trim());
        }
        return nameList;
    }

    private JPanel createFilterPanel() {
        this.filterPanel = new JPanel(new BorderLayout());
        this.filterInputTF = new HintTextField("");
        this.filterInputTF.setName("filterInputTF");
        this.filterInputTF.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JTextField textField = (JTextField)e.getSource();
                String text = textField.getText();
                FunctionTagsComponentProvider.this.sourcePanel.setFilterText(text);
                FunctionTagsComponentProvider.this.targetPanel.setFilterText(text);
                if (!text.isEmpty()) {
                    FunctionTagsComponentProvider.this.filterInputTF.setBackground(Color.YELLOW);
                } else {
                    FunctionTagsComponentProvider.this.filterInputTF.setBackground(Color.WHITE);
                }
            }
        });
        this.filterPanel.add((Component)new GLabel(" Filter:"), "West");
        this.filterPanel.add((Component)this.filterInputTF, "Center");
        return this.filterPanel;
    }

    private JPanel createInputPanel() {
        this.inputPanel = new JPanel(new BorderLayout());
        this.tagInputTF = new HintTextField("tag 1, tag 2, ...");
        this.tagInputTF.setName("tagInputTF");
        this.tagInputTF.addActionListener(e -> this.processCreates());
        this.inputPanel.add((Component)new GLabel(" Create new tag(s):"), "West");
        this.inputPanel.add((Component)this.tagInputTF, "Center");
        return this.inputPanel;
    }
}

