/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.cmd.refs.ClearExternalNameCmd;
import ghidra.app.plugin.core.references.ExternalReferencesProvider;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class ClearExternalNameAssociationAction
extends DockingAction {
    private static ImageIcon CLEAR_ICON = ResourceManager.loadImage((String)"images/erase16.png");
    private final ExternalReferencesProvider provider;

    public ClearExternalNameAssociationAction(ExternalReferencesProvider provider) {
        super("Clear External Name Association", provider.getOwner());
        this.provider = provider;
        this.setPopupMenuData(new MenuData(new String[]{"Clear External Name Association"}, (Icon)CLEAR_ICON, null));
        this.setToolBarData(new ToolBarData((Icon)CLEAR_ICON, null));
        this.setEnabled(true);
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }

    public void actionPerformed(ActionContext context) {
        Program program = this.provider.getProgram();
        List<String> externalNames = this.provider.getSelectedExternalNames();
        CompoundCmd cmd = new CompoundCmd("Clear External Program Associations");
        for (String externalName : externalNames) {
            cmd.add((Command)new ClearExternalNameCmd(externalName));
        }
        this.provider.getTool().execute((Command)cmd, (DomainObject)program);
    }
}

